/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.BinaryParserBlock;
import org.eclipse.cdt.ui.wizards.CProjectWizard;
import org.eclipse.cdt.ui.wizards.ReferenceBlock;
import org.eclipse.cdt.ui.wizards.SettingsBlock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class StdMakeProjectWizard
extends CProjectWizard {
    private static final String OP_ERROR = "StdMakeProjectWizard.op_error";
    private static final String WZ_TITLE = "StdMakeProjectWizard.title";
    private static final String WZ_DESC = "StdMakeProjectWizard.description";
    private static final String SETTINGS_TITLE = "StdMakeWizardSettings.title";
    private static final String SETTINGS_DESC = "StdMakeWizardSettings.description";
    private ReferenceBlock referenceBlock;
    private SettingsBlock settingsBlock;
    private BinaryParserBlock binaryParserBlock;

    public StdMakeProjectWizard() {
        this(CUIPlugin.getResourceString(WZ_TITLE), CUIPlugin.getResourceString(WZ_DESC));
    }

    public StdMakeProjectWizard(String title, String desc) {
        super(title, desc);
    }

    public void addTabItems(TabFolder folder) {
        this.fTabFolderPage.setTitle(CUIPlugin.getResourceString(SETTINGS_TITLE));
        this.fTabFolderPage.setDescription(CUIPlugin.getResourceString(SETTINGS_DESC));
        this.referenceBlock = new ReferenceBlock(this.getValidation());
        TabItem item = new TabItem(folder, 0);
        item.setText(this.referenceBlock.getLabel());
        Image img = this.referenceBlock.getImage();
        if (img != null) {
            item.setImage(img);
        }
        item.setData((Object)this.referenceBlock);
        item.setControl((Control)this.referenceBlock.getControl((Composite)folder));
        this.addTabItem(this.referenceBlock);
        this.settingsBlock = new SettingsBlock(this.getValidation());
        TabItem item2 = new TabItem(folder, 0);
        item2.setText(this.settingsBlock.getLabel());
        Image img2 = this.settingsBlock.getImage();
        if (img2 != null) {
            item2.setImage(img2);
        }
        item2.setData((Object)this.settingsBlock);
        item2.setControl((Control)this.settingsBlock.getControl((Composite)folder));
        this.addTabItem(this.settingsBlock);
        this.binaryParserBlock = new BinaryParserBlock(this.getValidation());
        TabItem item3 = new TabItem(folder, 0);
        item3.setText(this.binaryParserBlock.getLabel());
        Image img3 = this.binaryParserBlock.getImage();
        if (img3 != null) {
            item3.setImage(img3);
        }
        item3.setData((Object)this.binaryParserBlock);
        item3.setControl((Control)this.binaryParserBlock.getControl((Composite)folder));
        this.addTabItem(this.binaryParserBlock);
    }

    protected void doRunPrologue(IProgressMonitor monitor) {
    }

    protected void doRunEpilogue(IProgressMonitor monitor) {
    }

    protected void doRun(IProgressMonitor monitor) throws CoreException {
        super.doRun(monitor);
        if (this.newProject != null) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Standard Make", 3);
            if (this.referenceBlock != null) {
                this.referenceBlock.doRun(this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (this.settingsBlock != null) {
                this.settingsBlock.doRun(this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (this.binaryParserBlock != null) {
                this.binaryParserBlock.doRun(this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
    }

    public String getProjectID() {
        StringBuffer stringBuffer = new StringBuffer();
        CCorePlugin.getDefault();
        return stringBuffer.append("org.eclipse.cdt.core").append(".make").toString();
    }
}

