/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.MITargetAttach;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;

public class MIPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.mi.core";
    private static MIPlugin plugin;

    public MIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static MIPlugin getDefault() {
        return plugin;
    }

    public MISession createMISession(Process process, PTY pty, int timeout, int type) throws MIException {
        return new MISession(process, pty, timeout, type);
    }

    public MISession createMISession(Process process, PTY pty, int type) throws MIException {
        MIPlugin plugin = MIPlugin.getDefault();
        Preferences prefs = plugin.getPluginPreferences();
        int timeout = prefs.getInt(IMIConstants.PREF_REQUEST_TIMEOUT);
        return this.createMISession(process, pty, timeout, type);
    }

    public ICDISession createCSession(String gdb, String program) throws IOException, MIException {
        PTY pty = null;
        try {
            pty = new PTY();
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.createCSession(gdb, program, pty);
    }

    public ICDISession createCSession(String gdb, String program, PTY pty) throws IOException, MIException {
        if (gdb == null || gdb.length() == 0) {
            gdb = "gdb";
        }
        String[] args = pty != null ? new String[]{gdb, "-q", "-nw", "-tty", pty.getSlaveName(), "-i", "mi1", program} : new String[]{gdb, "-q", "-nw", "-i", "mi1", program};
        Process pgdb = ProcessFactory.getFactory().exec(args);
        MISession session = this.createMISession(pgdb, pty, 0);
        try {
            CommandFactory factory = session.getCommandFactory();
            MIGDBSet set = factory.createMIGDBSet(new String[]{"new-console"});
            session.postCommand(set);
            MIInfo info = set.getMIInfo();
            if (info == null) {
                throw new MIException("No answer");
            }
        }
        catch (MIException e) {
            // empty catch block
        }
        return new CSession(session, false);
    }

    public ICDISession createCSession(String gdb, String program, String core) throws IOException, MIException {
        if (gdb == null || gdb.length() == 0) {
            gdb = "gdb";
        }
        String[] args = new String[]{gdb, "--quiet", "-nw", "-i", "mi1", program, core};
        Process pgdb = ProcessFactory.getFactory().exec(args);
        MISession session = this.createMISession(pgdb, null, 2);
        return new CSession(session);
    }

    public ICDISession createCSession(String gdb, String program, int pid, String[] targetParams) throws IOException, MIException {
        if (gdb == null || gdb.length() == 0) {
            gdb = "gdb";
        }
        String[] args = new String[]{gdb, "--quiet", "-nw", "-i", "mi1", program};
        Process pgdb = ProcessFactory.getFactory().exec(args);
        MISession session = this.createMISession(pgdb, null, 1);
        MIInfo info = null;
        CommandFactory factory = session.getCommandFactory();
        if (targetParams != null && targetParams.length > 0) {
            MITargetSelect target = factory.createMITargetSelect(targetParams);
            session.postCommand(target);
            info = target.getMIInfo();
            if (info == null) {
                throw new MIException("No answer");
            }
        }
        MITargetAttach attach = factory.createMITargetAttach(pid);
        session.postCommand(attach);
        info = attach.getMIInfo();
        if (info == null) {
            throw new MIException("No answer");
        }
        session.getMIInferior().setSuspended();
        return new CSession(session, true);
    }

    public static String getUniqueIdentifier() {
        if (MIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return MIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public void debugLog(String message) {
        if (MIPlugin.getDefault().isDebugging()) {
            while (message.length() > 100) {
                String partial = message.substring(0, 100);
                message = message.substring(100);
                System.err.println(partial + "\\");
            }
            if (message.endsWith("\n")) {
                System.err.print(message);
            } else {
                System.err.println(message);
            }
        }
    }

    public void startup() throws CoreException {
        super.startup();
    }

    protected void initializeDefaultPluginPreferences() {
        this.getPluginPreferences().setDefault(IMIConstants.PREF_REQUEST_TIMEOUT, MISession.REQUEST_TIMEOUT);
    }

    public void shutdown() throws CoreException {
        this.savePluginPreferences();
        super.shutdown();
    }
}

