/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterObject;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDIGlobalVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CThread;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.command.MIExecContinue;
import org.eclipse.cdt.debug.mi.core.command.MIExecFinish;
import org.eclipse.cdt.debug.mi.core.command.MIExecNext;
import org.eclipse.cdt.debug.mi.core.command.MIExecNextInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecRun;
import org.eclipse.cdt.debug.mi.core.command.MIExecStep;
import org.eclipse.cdt.debug.mi.core.command.MIExecStepInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecUntil;
import org.eclipse.cdt.debug.mi.core.command.MIInfoThreads;
import org.eclipse.cdt.debug.mi.core.command.MITargetDetach;
import org.eclipse.cdt.debug.mi.core.command.MIThreadSelect;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoThreadsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIThreadSelectInfo;

public class CTarget
implements ICDITarget {
    CSession session;
    CThread[] noThreads = new CThread[0];
    CThread[] currentThreads;
    int currentThreadId;
    int lastExecutionToken;

    public CTarget(CSession s) {
        this.session = s;
        this.currentThreads = this.noThreads;
    }

    CSession getCSession() {
        return this.session;
    }

    int getLastExecutionToken() {
        return this.lastExecutionToken;
    }

    public ICDISession getSession() {
        return this.session;
    }

    public ICDITarget getTarget() {
        return this;
    }

    public void setCurrentThread(ICDIThread cthread) throws CDIException {
        if (cthread instanceof CThread) {
            this.setCurrentThread((CThread)cthread);
        }
    }

    public void setCurrentThread(CThread cthread) throws CDIException {
        MISession mi;
        this.session.setCurrentTarget(this);
        int id = cthread.getId();
        if (id == 0) {
            return;
        }
        if (this.currentThreadId != id) {
            mi = this.session.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIThreadSelect select = factory.createMIThreadSelect(id);
            try {
                mi.postCommand(select);
                MIThreadSelectInfo info = select.getMIThreadSelectInfo();
                if (info == null) {
                    throw new CDIException("No Answer");
                }
                this.currentThreadId = info.getNewThreadId();
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            RegisterManager regMgr = this.session.getRegisterManager();
            regMgr.update();
        }
        if (this.currentThreadId != id) {
            mi = this.session.getMISession();
            mi.fireEvent(new MIThreadExitEvent(id));
            throw new CDIException("Thread destroyed");
        }
    }

    void updateState(int newThreadId) {
        CThread[] oldThreads = this.currentThreads;
        this.currentThreadId = newThreadId;
        CThread[] newThreads = this.getCThreads();
        this.currentThreads = newThreads;
        if (oldThreads != null && oldThreads.length > 0) {
            int j;
            ArrayList<Integer> dList = new ArrayList<Integer>(oldThreads.length);
            int i = 0;
            while (i < oldThreads.length) {
                boolean found = false;
                j = 0;
                while (j < newThreads.length) {
                    if (newThreads[j].getId() == oldThreads[i].getId()) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    dList.add(new Integer(oldThreads[i].getId()));
                }
                ++i;
            }
            if (!dList.isEmpty()) {
                MIEvent[] events = new MIThreadExitEvent[dList.size()];
                j = 0;
                while (j < events.length) {
                    int id = (Integer)dList.get(j);
                    events[j] = new MIThreadExitEvent(id);
                    ++j;
                }
                MISession miSession = this.session.getMISession();
                miSession.fireEvents(events);
            }
        }
    }

    public CThread[] getCThreads() {
        CThread[] cthreads = this.noThreads;
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIInfoThreads tids = factory.createMIInfoThreads();
        try {
            mi.postCommand(tids);
            MIInfoThreadsInfo info = tids.getMIInfoThreadsInfo();
            int[] ids = info == null ? new int[]{} : info.getThreadIds();
            if (ids != null && ids.length > 0) {
                cthreads = new CThread[ids.length];
                int i = 0;
                while (i < ids.length) {
                    cthreads[i] = new CThread(this, ids[i]);
                    ++i;
                }
            } else {
                cthreads = new CThread[]{new CThread(this, 0)};
            }
            this.currentThreadId = info.getCurrentThread();
        }
        catch (MIException e) {
            // empty catch block
        }
        return cthreads;
    }

    public ICDIThread getCurrentThread() throws CDIException {
        ICDIThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            CThread cthread = (CThread)threads[i];
            if (cthread.getId() == this.currentThreadId) {
                return cthread;
            }
            ++i;
        }
        return null;
    }

    public ICDIThread[] getThreads() throws CDIException {
        if (this.currentThreads.length == 0) {
            this.currentThreads = this.getCThreads();
        }
        return this.currentThreads;
    }

    public void restart() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecRun run = factory.createMIExecRun(new String[0]);
        try {
            mi.postCommand(run);
            MIInfo info = run.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = run.getToken();
    }

    public void resume() throws CDIException {
        MISession mi = this.session.getMISession();
        if (mi.getMIInferior().isRunning()) {
            throw new CDIException("Inferior already running");
        }
        if (mi.getMIInferior().isSuspended()) {
            CommandFactory factory = mi.getCommandFactory();
            MIExecContinue cont = factory.createMIExecContinue();
            try {
                mi.postCommand(cont);
                MIInfo info = cont.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            this.lastExecutionToken = cont.getToken();
        } else if (mi.getMIInferior().isTerminated()) {
            this.restart();
        } else {
            this.restart();
        }
    }

    public void stepInto() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecStep step = factory.createMIExecStep();
        try {
            mi.postCommand(step);
            MIInfo info = step.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = step.getToken();
    }

    public void stepIntoInstruction() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecStepInstruction stepi = factory.createMIExecStepInstruction();
        try {
            mi.postCommand(stepi);
            MIInfo info = stepi.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = stepi.getToken();
    }

    public void stepOver() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecNext next = factory.createMIExecNext();
        try {
            mi.postCommand(next);
            MIInfo info = next.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = next.getToken();
    }

    public void stepOverInstruction() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecNextInstruction nexti = factory.createMIExecNextInstruction();
        try {
            mi.postCommand(nexti);
            MIInfo info = nexti.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = nexti.getToken();
    }

    public void stepReturn() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecFinish finish = factory.createMIExecFinish();
        try {
            mi.postCommand(finish);
            MIInfo info = finish.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = finish.getToken();
    }

    public void suspend() throws CDIException {
        MISession mi = this.session.getMISession();
        try {
            mi.getMIInferior().interrupt();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void disconnect() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MITargetDetach detach = factory.createMITargetDetach();
        try {
            mi.postCommand(detach);
            MIInfo info = detach.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        MISession miSession = this.session.getMISession();
        miSession.fireEvent(new MIDetachedEvent(detach.getToken()));
        this.session.getMISession().getMIInferior().setDisconnected();
    }

    public void finish() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecFinish finish = factory.createMIExecFinish();
        try {
            mi.postCommand(finish);
            MIInfo info = finish.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = finish.getToken();
    }

    public void runUntil(ICDILocation location) throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        String loc = "";
        if (location.getFile() != null) {
            loc = location.getFile() + ":" + location.getLineNumber();
        } else if (location.getFunction() != null) {
            loc = location.getFunction();
        } else if (location.getAddress() != 0L) {
            loc = "" + location.getAddress();
        }
        MIExecUntil until = factory.createMIExecUntil(loc);
        try {
            mi.postCommand(until);
            MIInfo info = until.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = until.getToken();
    }

    public String evaluateExpressionToString(String expressionText) throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataEvaluateExpression evaluate = factory.createMIDataEvaluateExpression(expressionText);
        try {
            mi.postCommand(evaluate);
            MIDataEvaluateExpressionInfo info = evaluate.getMIDataEvaluateExpressionInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info.getExpression();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void terminate() throws CDIException {
        this.session.getMISession().getMIInferior().destroy();
    }

    public boolean isTerminated() {
        return this.session.getMISession().getMIInferior().isTerminated();
    }

    public boolean isDisconnected() {
        return !this.session.getMISession().getMIInferior().isConnected();
    }

    public boolean isSuspended() {
        return this.session.getMISession().getMIInferior().isSuspended();
    }

    public boolean isRunning() {
        return this.session.getMISession().getMIInferior().isRunning();
    }

    public ICDIGlobalVariable[] getGlobalVariables() throws CDIException {
        return new ICDIGlobalVariable[0];
    }

    public ICDIRegisterObject[] getRegisterObjects() throws CDIException {
        RegisterManager mgr = this.session.getRegisterManager();
        return mgr.getRegisterObjects();
    }

    public ICDIRegister[] getRegisters(ICDIRegisterObject[] regs) throws CDIException {
        ICDIRegister[] registers = null;
        RegisterManager mgr = this.session.getRegisterManager();
        registers = new ICDIRegister[regs.length];
        int i = 0;
        while (i < registers.length) {
            registers[i] = mgr.createRegister(regs[i]);
            ++i;
        }
        return registers;
    }

    public ICDISharedLibrary[] getSharedLibraries() throws CDIException {
        return new ICDISharedLibrary[0];
    }

    public Process getProcess() {
        return this.session.getMISession().getMIInferior();
    }
}

