/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.mi.core.cdi.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.Register;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.event.MIBreakPointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;

public class ChangedEvent
implements ICDIChangedEvent {
    CSession session;
    ICDIObject source;

    public ChangedEvent(CSession s, MIVarChangedEvent var) {
        this.session = s;
        VariableManager mgr = this.session.getVariableManager();
        String varName = var.getVarName();
        VariableManager.Element element = mgr.getElement(varName);
        this.source = element != null && element.variable != null ? element.variable : new CObject(this.session.getCTarget());
    }

    public ChangedEvent(CSession s, MIRegisterChangedEvent var) {
        this.session = s;
        RegisterManager mgr = this.session.getRegisterManager();
        int regno = var.getNumber();
        Register reg = null;
        try {
            reg = mgr.getRegister(regno);
        }
        catch (CDIException e) {
            // empty catch block
        }
        this.source = reg != null ? reg : new CObject(this.session.getCTarget());
    }

    public ChangedEvent(CSession s, MIBreakPointChangedEvent bpoint) {
        this.session = s;
        BreakpointManager mgr = (BreakpointManager)this.session.getBreakpointManager();
        int number = bpoint.getNumber();
        Breakpoint breakpoint = mgr.getBreakpoint(number);
        this.source = breakpoint != null ? breakpoint : new CObject(this.session.getCTarget());
    }

    public ChangedEvent(CSession s, ICDIObject src) {
        this.session = s;
        this.source = src;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

