/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterObject;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Register;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterObject;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataListChangedRegisters;
import org.eclipse.cdt.debug.mi.core.command.MIDataListRegisterNames;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataListChangedRegistersInfo;
import org.eclipse.cdt.debug.mi.core.output.MIDataListRegisterNamesInfo;

public class RegisterManager
extends SessionObject {
    List regList = new ArrayList();

    public RegisterManager(CSession session) {
        super(session);
    }

    public ICDIRegisterObject[] getRegisterObjects() throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataListRegisterNames registers = factory.createMIDataListRegisterNames();
        try {
            mi.postCommand(registers);
            MIDataListRegisterNamesInfo info = registers.getMIDataListRegisterNamesInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            String[] names = info.getRegisterNames();
            ICDIRegisterObject[] regs = new RegisterObject[names.length];
            int i = 0;
            while (i < names.length) {
                regs[i] = new RegisterObject(names[i], i);
                ++i;
            }
            return regs;
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    Register[] getRegisters() {
        return this.regList.toArray(new Register[0]);
    }

    Register getRegister(int regno) throws CDIException {
        Register[] regs = this.getRegisters();
        int i = 0;
        while (i < regs.length) {
            if (regs[i].getId() == regno) {
                return regs[i];
            }
            ++i;
        }
        return null;
    }

    Register getRegister(ICDIRegisterObject regObject) throws CDIException {
        Register[] regs = this.getRegisters();
        int i = 0;
        while (i < regs.length) {
            if (regObject.getName().equals(regs[i].getName())) {
                return regs[i];
            }
            ++i;
        }
        return null;
    }

    Register createRegister(ICDIRegisterObject regObject) throws CDIException {
        Register reg = this.getRegister(regObject);
        if (reg == null) {
            reg = new Register(this.getCSession().getCTarget(), regObject);
            this.regList.add(reg);
        }
        return reg;
    }

    Register[] createRegisters(ICDIRegisterObject[] regObjects) throws CDIException {
        Register[] regs = new Register[regObjects.length];
        int i = 0;
        while (i < regs.length) {
            regs[i] = this.createRegister(regObjects[i]);
            ++i;
        }
        return regs;
    }

    void update() throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataListChangedRegisters changed = factory.createMIDataListChangedRegisters();
        try {
            mi.postCommand(changed);
            MIDataListChangedRegistersInfo info = changed.getMIDataListChangedRegistersInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            int[] regnos = info.getRegisterNumbers();
            ArrayList<MIRegisterChangedEvent> eventList = new ArrayList<MIRegisterChangedEvent>(regnos.length);
            int i = 0;
            while (i < regnos.length) {
                Register reg = this.getRegister(regnos[i]);
                if (reg != null) {
                    eventList.add(new MIRegisterChangedEvent(changed.getToken(), reg.getName(), regnos[i]));
                }
                ++i;
            }
            MIEvent[] events = eventList.toArray(new MIEvent[0]);
            mi.fireEvents(events);
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }
}

