/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.MemoryActionSelectionGroup;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.texteditor.IUpdate;

public class MemoryNumberOfColumnAction
extends Action
implements IUpdate {
    private MemoryActionSelectionGroup fGroup;
    private MemoryViewer fMemoryViewer;
    private int fNumberOfColumns = 0;

    public MemoryNumberOfColumnAction(MemoryActionSelectionGroup group, MemoryViewer viewer, int numberOfColumns) {
        super(MemoryNumberOfColumnAction.getLabel(numberOfColumns));
        this.fGroup = group;
        this.fMemoryViewer = viewer;
        this.fNumberOfColumns = numberOfColumns;
        this.setChecked(false);
    }

    private static String getLabel(int numberOfColumns) {
        return Integer.toString(numberOfColumns) + " column" + (numberOfColumns > 1 ? "s" : "");
    }

    public void update() {
        this.setEnabled(this.fMemoryViewer.canUpdate());
        this.setChecked(this.fMemoryViewer.getCurrentNumberOfColumns() == this.fNumberOfColumns);
    }

    public void run() {
        try {
            this.fMemoryViewer.setNumberOfColumns(this.fNumberOfColumns);
            this.fGroup.setCurrentSelection((IAction)this);
        }
        catch (DebugException e) {
            CDebugUIPlugin.errorDialog("Unable to change the column  number.", e.getStatus());
            this.setChecked(false);
        }
    }

    public String getActionId() {
        return "MemoryNumberOfColumns" + this.fNumberOfColumns;
    }
}

