/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.MemoryActionSelectionGroup;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.texteditor.IUpdate;

public class MemorySizeAction
extends Action
implements IUpdate {
    private MemoryActionSelectionGroup fGroup;
    private MemoryViewer fMemoryViewer;
    private int fId = 0;

    public MemorySizeAction(MemoryActionSelectionGroup group, MemoryViewer viewer, int id) {
        super(MemorySizeAction.getLabel(id));
        this.fGroup = group;
        this.fMemoryViewer = viewer;
        this.fId = id;
        this.setChecked(false);
    }

    public void update() {
        this.setEnabled(this.fMemoryViewer.canUpdate());
        this.setChecked(this.fMemoryViewer.getCurrentWordSize() == this.fId);
    }

    private static String getLabel(int id) {
        String label = "";
        switch (id) {
            case 1: {
                label = "1 byte";
                break;
            }
            case 2: {
                label = "2 bytes";
                break;
            }
            case 4: {
                label = "4 bytes";
                break;
            }
            case 8: {
                label = "8 bytes";
            }
        }
        return label;
    }

    public void run() {
        try {
            this.fMemoryViewer.setWordSize(this.fId);
            this.fGroup.setCurrentSelection((IAction)this);
        }
        catch (DebugException e) {
            CDebugUIPlugin.errorDialog("Unable to change memory unit size.", e.getStatus());
            this.setChecked(false);
        }
    }

    public String getActionId() {
        return "MemorySize" + this.fId;
    }
}

