/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.wizards.AddDirectorySourceLocationWizard;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class AttachSourceEditor
extends EditorPart
implements IPropertyChangeListener {
    public static final String EDITOR_ID = CDebugUIPlugin.getUniqueIdentifier() + ".editor.AttachSourceEditor";
    private static final int HORIZONTAL_SCROLL_INCREMENT = 10;
    private static final int VERTICAL_SCROLL_INCREMENT = 10;
    private ScrolledComposite fScrolledComposite;
    private Color fBackgroundColor;
    private Color fForegroundColor;
    private Color fSeparatorColor;
    private List fBannerLabels = new ArrayList();
    private List fHeaderLabels = new ArrayList();
    private Font fFont;
    private Button fAttachButton;
    private Label fInputLabel;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        this.fBackgroundColor = display.getSystemColor(25);
        this.fForegroundColor = display.getSystemColor(24);
        this.fSeparatorColor = new Color((Device)display, 152, 170, 203);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.fScrolledComposite = new ScrolledComposite(parent, 768);
        this.fScrolledComposite.setAlwaysShowScrollBars(false);
        this.fScrolledComposite.setExpandHorizontal(true);
        this.fScrolledComposite.setExpandVertical(true);
        this.fScrolledComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)AttachSourceEditor.this);
                AttachSourceEditor.this.fScrolledComposite = null;
                AttachSourceEditor.this.fSeparatorColor.dispose();
                AttachSourceEditor.this.fSeparatorColor = null;
                AttachSourceEditor.this.fBannerLabels.clear();
                AttachSourceEditor.this.fHeaderLabels.clear();
                if (AttachSourceEditor.this.fFont != null) {
                    AttachSourceEditor.this.fFont.dispose();
                    AttachSourceEditor.this.fFont = null;
                }
            }
        });
        this.fScrolledComposite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Rectangle clientArea = AttachSourceEditor.this.fScrolledComposite.getClientArea();
                ScrollBar verticalBar = AttachSourceEditor.this.fScrolledComposite.getVerticalBar();
                verticalBar.setIncrement(10);
                verticalBar.setPageIncrement(clientArea.height - verticalBar.getIncrement());
                ScrollBar horizontalBar = AttachSourceEditor.this.fScrolledComposite.getHorizontalBar();
                horizontalBar.setIncrement(10);
                horizontalBar.setPageIncrement(clientArea.width - horizontalBar.getIncrement());
            }
        });
        Composite composite = this.createComposite((Composite)this.fScrolledComposite);
        composite.setLayout((Layout)new GridLayout());
        this.createTitleLabel(composite, "C/C++ File Editor");
        this.createLabel(composite, null);
        this.createLabel(composite, null);
        this.createHeadingLabel(composite, "Source not found");
        Composite separator = this.createCompositeSeparator(composite);
        GridData data = new GridData(768);
        data.heightHint = 2;
        separator.setLayoutData((Object)data);
        this.fInputLabel = this.createLabel(composite, "");
        this.createLabel(composite, "You can attach the source location by pressing the button below:");
        this.createLabel(composite, null);
        this.fAttachButton = this.createButton(composite, "&Attach Source...");
        this.fAttachButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AttachSourceEditor.this.attachSourceLocation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        separator = this.createCompositeSeparator(composite);
        data = new GridData(768);
        data.heightHint = 2;
        separator.setLayoutData((Object)data);
        this.fScrolledComposite.setContent((Control)composite);
        this.fScrolledComposite.setMinSize(composite.computeSize(-1, -1));
        if (this.getEditorInput() != null) {
            this.setInputLabelText(this.getEditorInput().getName());
        }
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.fBackgroundColor);
        return composite;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    private Label createTitleLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        label.setFont(JFaceResources.getHeaderFont());
        this.fHeaderLabels.add(label);
        return label;
    }

    private Label createHeadingLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        label.setFont(JFaceResources.getBannerFont());
        this.fBannerLabels.add(label);
        return label;
    }

    private Composite createCompositeSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.fSeparatorColor);
        return composite;
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 0x800000);
        button.setBackground(this.fBackgroundColor);
        button.setForeground(this.fForegroundColor);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public void setFocus() {
        if (this.fAttachButton != null) {
            this.fAttachButton.setFocus();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input != null && this.fInputLabel != null) {
            this.setInputLabelText(this.getEditorInput().getName());
        }
    }

    private void setInputLabelText(String inputName) {
        this.fInputLabel.setText(MessageFormat.format("There is no source for the file {0}", inputName));
    }

    protected void attachSourceLocation() {
        FileNotFoundElement element;
        if (this.getEditorInput() != null && this.getEditorInput().getAdapter(class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement == null ? (class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement = AttachSourceEditor.class$("org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement")) : class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement) != null && (element = (FileNotFoundElement)this.getEditorInput().getAdapter(class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement == null ? (class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement = AttachSourceEditor.class$("org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement")) : class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement)).getLaunch() != null && element.getLaunch().getSourceLocator() instanceof IAdaptable) {
            ILaunch launch = element.getLaunch();
            ICSourceLocator locator = (ICSourceLocator)((IAdaptable)element.getLaunch().getSourceLocator()).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = AttachSourceEditor.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator);
            if (locator != null) {
                Path path = new Path(element.getName());
                Wizard wizard = null;
                if (path.isAbsolute()) {
                    path = path.removeLastSegments(1);
                    wizard = new AddDirectorySourceLocationWizard((IPath)path);
                } else {
                    wizard = new AddSourceLocationWizard(locator.getSourceLocations());
                }
                WizardDialog dialog = new WizardDialog(CDebugUIPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    ICSourceLocation[] locations = locator.getSourceLocations();
                    ArrayList<ICSourceLocation> list = new ArrayList<ICSourceLocation>(Arrays.asList(locations));
                    list.add(wizard.getSourceLocation());
                    locator.setSourceLocations(list.toArray(new ICSourceLocation[list.size()]));
                    if (locator instanceof IPersistableSourceLocator) {
                        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                        this.saveChanges(configuration, (IPersistableSourceLocator)launch.getSourceLocator());
                    }
                }
            }
        }
    }

    protected void saveChanges(ILaunchConfiguration configuration, IPersistableSourceLocator locator) {
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(configuration.getName());
            copy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
            copy.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), (IStatus)null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

