/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.registers;

import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.actions.ChangeRegisterValueAction;
import org.eclipse.cdt.debug.internal.ui.actions.ShowRegisterTypesAction;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.registers.RegistersViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.registers.RegistersViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.registers.RegistersViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class RegistersView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    private IDebugModelPresentation fModelPresentation;
    protected static final String VARIABLES_SELECT_ALL_ACTION = "selectAll.Registers";

    protected Viewer createViewer(Composite parent) {
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        RegistersViewer vv = new RegistersViewer(parent, 770);
        vv.setContentProvider(this.createContentProvider());
        vv.setLabelProvider((IBaseLabelProvider)this.getModelPresentation());
        vv.setUseHashlookup(true);
        this.setAction("selectAll", this.getAction(VARIABLES_SELECT_ALL_ACTION));
        this.getViewSite().getActionBars().updateActionBars();
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler((Viewer)vv));
        return vv;
    }

    protected void createActions() {
        Object action = new ShowRegisterTypesAction(this.getStructuredViewer());
        action.setChecked(CDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_SHOW_TYPE_NAMES));
        this.setAction("ShowTypeNames", (IAction)action);
        action = new ChangeRegisterValueAction(this.getViewer());
        action.setEnabled(false);
        this.setAction("ChangeRegisterValue", (IAction)action);
        this.setAction("Double_Click_ActionId", (IAction)action);
        this.setInitialContent();
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.REGISTERS_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyRegisterGroup"));
        menu.add((IContributionItem)new Separator("registerGroup"));
        menu.add(this.getAction("ChangeRegisterValue"));
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add(this.getAction("ShowTypeNames"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator(this.getClass().getName()));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.add(this.getAction("ShowTypeNames"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("Changed.Register.RGB")) {
            this.getEventHandler().refresh();
        }
    }

    public void handleException(DebugException e) {
    }

    public void dispose() {
        this.fModelPresentation.dispose();
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected IContentProvider createContentProvider() {
        RegistersViewContentProvider cp = new RegistersViewContentProvider();
        cp.setExceptionHandler(this);
        return cp;
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = DebugUITools.newDebugModelPresentation();
        }
        return this.fModelPresentation;
    }

    protected AbstractDebugEventHandler createEventHandler(Viewer viewer) {
        return new RegistersViewEventHandler(this);
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        Object input;
        IStackFrame frame = null;
        if (ssel.size() == 1 && (input = ssel.getFirstElement()) instanceof IStackFrame) {
            frame = (IStackFrame)input;
        }
        if (this.getViewer() == null) {
            return;
        }
        Object current = this.getViewer().getInput();
        if (current == null && frame == null) {
            return;
        }
        if (current != null && current.equals(frame)) {
            return;
        }
        if (current != null && frame != null && current instanceof IStackFrame && ((IStackFrame)current).getDebugTarget().equals(frame.getDebugTarget())) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput((Object)frame);
    }

    protected void setInitialContent() {
        ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.setViewerInput((IStructuredSelection)selection);
        }
    }
}

