/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CApplicationLaunchShortcut
implements ILaunchShortcut {
    public void launch(IEditorPart editor, String mode) {
        this.searchAndLaunch(new Object[]{editor.getEditorInput()}, mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    public void launch(IBinary bin, String mode) {
        try {
            ILaunchConfiguration config = this.findLaunchConfiguration(bin, mode);
            if (config != null) {
                DebugUITools.saveAndBuildBeforeLaunch();
                config.launch(mode, null);
            }
        }
        catch (CoreException e) {
            LaunchUIPlugin.errorDialog("Launch failed", e.getStatus());
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IBinary bin, String mode) {
        ILaunchConfiguration configuration = null;
        ILaunchConfigurationType configType = this.getCLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                String programName = AbstractCLaunchDelegate.getProgramName(config);
                String projectName = AbstractCLaunchDelegate.getProjectName(config);
                String name = bin.getResource().getProjectRelativePath().toString();
                if (projectName != null && programName.equals(name) && projectName != null && projectName.equals(bin.getCProject().getProject().getName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            ICDebugConfiguration debugConfig = null;
            ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getDebugConfigurations();
            ArrayList<ICDebugConfiguration> debugList = new ArrayList<ICDebugConfiguration>(debugConfigs.length);
            int i = 0;
            while (i < debugConfigs.length) {
                String platform = debugConfigs[i].getPlatform();
                if (platform == null || platform.equals("native")) {
                    debugList.add(debugConfigs[i]);
                }
                ++i;
            }
            debugConfigs = debugList.toArray(new ICDebugConfiguration[0]);
            if (debugConfigs.length == 1) {
                debugConfig = debugConfigs[0];
            } else if (debugConfigs.length > 1) {
                debugConfig = this.chooseDebugConfig(debugConfigs, mode);
            }
            if (debugConfig != null) {
                configuration = this.createConfiguration(bin, debugConfig);
            }
        } else {
            configuration = candidateCount == 1 ? (ILaunchConfiguration)candidateConfigs.get(0) : this.chooseConfiguration(candidateConfigs, mode);
        }
        return configuration;
    }

    private ILaunchConfiguration createConfiguration(IBinary bin, ICDebugConfiguration debugConfig) {
        ILaunchConfiguration config = null;
        try {
            String projectName = bin.getResource().getProjectRelativePath().toString();
            ILaunchConfigurationType configType = this.getCLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(bin.getElementName()));
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", projectName);
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", bin.getCProject().getElementName());
            wc.setAttribute(IDebugUIConstants.ATTR_TARGET_DEBUG_PERSPECTIVE, "perspective_default");
            wc.setAttribute(IDebugUIConstants.ATTR_TARGET_RUN_PERSPECTIVE, "perspective_default");
            wc.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", (String)null);
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", debugConfig.getID());
            config = wc.doSave();
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log((Throwable)ce);
        }
        return config;
    }

    protected ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.cdt.launch.localCLaunch");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return CDebugUIPlugin.getActiveWorkbenchShell();
    }

    private ICDebugConfiguration chooseDebugConfig(ICDebugConfiguration[] debugConfigs, String mode) {
        LabelProvider provider = new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof ICDebugConfiguration) {
                    return ((ICDebugConfiguration)element).getName();
                }
                return element.toString();
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)provider);
        dialog.setElements((Object[])debugConfigs);
        dialog.setTitle("Launch Debug Configuration Selection");
        if (mode.equals("debug")) {
            dialog.setMessage("Choose a debug configuration to debug");
        } else {
            dialog.setMessage("Choose a configuration to run");
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        provider.dispose();
        if (result == 0) {
            return (ICDebugConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Launch Configuration Selection");
        if (mode.equals("debug")) {
            dialog.setMessage("Choose a launch configuration to debug");
        } else {
            dialog.setMessage("Choose a launch configuration to run");
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected IBinary chooseBinary(List binList, String mode) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setElements(binList.toArray());
        dialog.setTitle("C ApplicationAction");
        if (mode.equals("debug")) {
            dialog.setMessage("Choose an application to debug");
        } else {
            dialog.setMessage("Choose an application to run");
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IBinary)dialog.getFirstResult();
        }
        return null;
    }

    private void searchAndLaunch(final Object[] elements, String mode) {
        final ArrayList results = new ArrayList();
        if (elements != null && elements.length > 0) {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
                IRunnableWithProgress runnable = new IRunnableWithProgress(){
                    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

                    public void run(IProgressMonitor pm) throws InterruptedException {
                        int nElements = elements.length;
                        pm.beginTask("Looking for executables", nElements);
                        try {
                            SubProgressMonitor sub = new SubProgressMonitor(pm, 1);
                            int i = 0;
                            while (i < nElements) {
                                if (elements[i] instanceof IAdaptable) {
                                    IResource r = (IResource)((IAdaptable)elements[i]).getAdapter(class$org$eclipse$core$resources$IResource == null ? 2.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
                                    ICProject cproject = CoreModel.getDefault().create(r.getProject());
                                    if (cproject != null) {
                                        IBinary[] bins = cproject.getBinaryContainer().getBinaries();
                                        int j = 0;
                                        while (j < bins.length) {
                                            if (bins[j].isExecutable()) {
                                                results.add(bins[j]);
                                            }
                                            ++j;
                                        }
                                    }
                                }
                                if (pm.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                sub.done();
                                ++i;
                            }
                            Object var10_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_10 = null;
                            pm.done();
                            throw throwable;
                        }
                        pm.done();
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                };
                dialog.run(true, true, runnable);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"C Application Launcher", (String)e.getMessage());
                return;
            }
            if (results.size() == 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)"C Application Launcher", (String)"Launch failed no binaries");
            } else {
                IBinary bin = this.chooseBinary(results, mode);
                if (bin != null) {
                    this.launch(bin, mode);
                }
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"C Application Launcher", (String)"Launch failed no project selected");
        }
    }
}

