/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CMainTab
extends CLaunchConfigurationTab {
    protected Label fProjLabel;
    protected Text fProjText;
    protected Button fProjButton;
    protected Label fProgLabel;
    protected Text fProgText;
    protected Button fSearchButton;
    protected static final String EMPTY_STRING = "";
    private String filterPlatform = "";

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        Composite projComp = new Composite(comp, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText("&Project:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(projComp, "&Browse...", null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CMainTab.this.handleProjectButtonSelected();
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(comp, 1);
        Composite mainComp = new Composite(comp, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.fProgLabel = new Label(mainComp, 0);
        this.fProgLabel.setText("C/C++ Application:");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProgLabel.setLayoutData((Object)gd);
        this.fProgText = new Text(mainComp, 2052);
        gd = new GridData(768);
        this.fProgText.setLayoutData((Object)gd);
        this.fProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton(mainComp, "Searc&h...", null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CMainTab.this.handleSearchButtonSelected();
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        LaunchUIPlugin.setDialogShell(parent.getShell());
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.filterPlatform = this.getPlatform(config);
        this.updateProjectFromConfig(config);
        this.updateProgramFromConfig(config);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log(ce);
        }
        this.fProjText.setText(projectName);
    }

    protected void updateProgramFromConfig(ILaunchConfiguration config) {
        String programName = EMPTY_STRING;
        try {
            programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY_STRING);
        }
        catch (CoreException ce) {
            LaunchUIPlugin.log(ce);
        }
        this.fProgText.setText(programName);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.fProjText.getText());
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.fProgText.getText());
    }

    protected void handleSearchButtonSelected() {
        if (this.getCProject() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Project required", (String)"Project must first be entered before searching for a program");
            return;
        }
        Object[] executables = this.getBinaryFiles(this.getCProject());
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(executables);
        dialog.setMessage("Choose a &program to run");
        dialog.setTitle("Program Selection");
        if (dialog.open() == 0) {
            IBinary binary = (IBinary)dialog.getFirstResult();
            try {
                this.fProgText.setText(binary.getResource().getProjectRelativePath().toString());
            }
            catch (CModelException e) {
                // empty catch block
            }
        }
    }

    protected IBinary[] getBinaryFiles(ICProject cproject) {
        return cproject.getBinaryContainer().getBinaries();
    }

    protected void handleProjectButtonSelected() {
        ICProject project = this.chooseCProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    protected ICProject chooseCProject() {
        Object[] projects = this.getCProjects();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project Selection");
        dialog.setMessage("Choose a &project to constrain the search for a program");
        dialog.setElements(projects);
        ICProject cProject = this.getCProject();
        if (cProject != null) {
            dialog.setInitialSelections(new Object[]{cProject});
        }
        if (dialog.open() == 0) {
            return (ICProject)dialog.getFirstResult();
        }
        return null;
    }

    protected ICProject[] getCProjects() {
        ICProject[] cproject = CoreModel.getDefault().getCRoot().getCProjects();
        ArrayList<ICProject> list = new ArrayList<ICProject>(cproject.length);
        boolean isNative = this.filterPlatform.equals(BootLoader.getOS());
        int i = 0;
        while (i < cproject.length) {
            ICDescriptor cdesciptor = null;
            try {
                cdesciptor = CCorePlugin.getDefault().getCProjectDescription((IProject)cproject[i].getResource());
                String projectPlatform = cdesciptor.getPlatform();
                if (this.filterPlatform.equals("*") || projectPlatform.equals("*") || isNative && cdesciptor.getPlatform().equalsIgnoreCase("native") || this.filterPlatform.equalsIgnoreCase(cdesciptor.getPlatform())) {
                    list.add(cproject[i]);
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
            ++i;
        }
        return list.toArray(new ICProject[list.size()]);
    }

    protected ICProject getCProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return CoreModel.getDefault().getCRoot().getCProject(projectName);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage("Project not specified");
            return false;
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage("Project does not exist");
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        name = this.fProgText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage("Program not specified");
            return false;
        }
        if (name.equals(".") || name.equals("..")) {
            this.setErrorMessage("Program does not exist");
            return false;
        }
        if (!project.isOpen()) {
            this.setErrorMessage("Project must be opened");
            return false;
        }
        if (!project.getFile(name).exists()) {
            this.setErrorMessage("Program does not exist");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
        ICElement cElement = null;
        cElement = this.getContext((ILaunchConfiguration)config, this.getPlatform((ILaunchConfiguration)config));
        if (cElement != null) {
            this.initializeCProject(cElement, config);
        }
        this.initializeProgramName(cElement, config);
    }

    protected void initializeProgramName(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        IBinaryContainer bc;
        IBinary[] bins;
        IBinary binary = null;
        if (cElement instanceof ICProject && (bins = (bc = ((ICProject)cElement).getBinaryContainer()).getBinaries()).length == 1) {
            binary = bins[0];
        }
        if (binary != null) {
            try {
                String path = binary.getResource().getProjectRelativePath().toOSString();
                config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", path);
                String name = binary.getElementName();
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(index + 1);
                }
                name = this.getLaunchConfigurationDialog().generateName(name);
                config.rename(name);
            }
            catch (CModelException e) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_MAIN_TAB);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }
}

