/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.ConsoleEvent;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class BuildConsoleManager
implements IBuildConsoleManager,
IResourceChangeListener,
IPropertyChangeListener {
    private HashMap fConsoleDocumentMap;
    ListenerList listeners = new ListenerList(1);

    public BuildConsoleManager() {
        this.fConsoleDocumentMap = new HashMap();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fConsoleDocumentMap == null) {
            return;
        }
        IResource resource = event.getResource();
        if (resource != null && resource.getType() == 4 && (event.getType() == 4 || event.getType() == 2)) {
            this.fConsoleDocumentMap.remove(resource);
            Object[] list = this.listeners.getListeners();
            if (list.length > 0) {
                int i = 0;
                while (i < list.length) {
                    IBuildConsoleListener listener = (IBuildConsoleListener)list[i];
                    ConsoleEvent consoleEvent = new ConsoleEvent(this, (IProject)resource, 2);
                    listener.consoleChange(consoleEvent);
                    ++i;
                }
            }
        }
    }

    public void shutdown() {
        CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void startup() {
        CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private BuildConsole getBuildConsole(IProject project) {
        BuildConsole console = (BuildConsole)((Object)this.fConsoleDocumentMap.get(project));
        if (console == null) {
            console = new BuildConsole();
            this.fConsoleDocumentMap.put(project, console);
        }
        return console;
    }

    public IConsole getConsole(IProject project) {
        return this.getBuildConsole(project);
    }

    public IDocument getConsoleDocument(IProject project) {
        return this.getBuildConsole(project).getDocument();
    }

    public void addConsoleListener(IBuildConsoleListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeConsoleListener(IBuildConsoleListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "buildConsoleLines") {
            Collection consoles = this.fConsoleDocumentMap.values();
            Iterator iter = consoles.iterator();
            while (iter.hasNext()) {
                BuildConsole console = (BuildConsole)((Object)iter.next());
                console.setConsoleSize(BuildConsolePreferencePage.buildConsoleLines());
            }
        }
    }

    private class BuildConsole
    extends ConsoleOutputStream
    implements IConsole {
        protected BuildConsoleDocument fDocument;

        public BuildConsole() {
            this.fDocument = new BuildConsoleDocument(BuildConsolePreferencePage.buildConsoleLines());
        }

        public void setConsoleSize(int nLines) {
            this.fDocument.setDocumentSize(nLines);
        }

        public void start(IProject project) {
            Object[] list;
            if (BuildConsolePreferencePage.isClearBuildConsole()) {
                this.clear();
            }
            if ((list = BuildConsoleManager.this.listeners.getListeners()).length > 0) {
                int i = 0;
                while (i < list.length) {
                    IBuildConsoleListener listener = (IBuildConsoleListener)list[i];
                    ConsoleEvent event = new ConsoleEvent(BuildConsoleManager.this, project, 1);
                    listener.consoleChange(event);
                    ++i;
                }
            }
        }

        public void clear() {
            super.clear();
            Display.getDefault().syncExec(new Runnable(this){
                private final /* synthetic */ BuildConsole this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    this.this$1.fDocument.set("");
                }
            });
        }

        public ConsoleOutputStream getOutputStream() {
            return this;
        }

        public IDocument getDocument() {
            return this.fDocument;
        }

        public void flush() throws IOException {
            this.flush(false);
        }

        public void flush(boolean force) throws IOException {
            if (force || this.fBuffer.length() > 512) {
                Display.getDefault().syncExec(new Runnable(this){
                    private final /* synthetic */ BuildConsole this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (BuildConsolePreferencePage.isConsoleOnTop()) {
                            this.this$1.bringConsoleOnTop();
                        }
                        try {
                            int len = this.this$1.fDocument.getLength();
                            this.this$1.fDocument.replace(len, 0, this.this$1.readBuffer());
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        void bringConsoleOnTop() {
            IWorkbenchWindow window = CUIPlugin.getDefault().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                try {
                    IViewPart cBuild = page.findView("org.eclipse.cdt.ui.BuildConsoleView");
                    if (cBuild == null) {
                        if (BuildConsolePreferencePage.isAutoOpenConsole()) {
                            IWorkbenchPart activePart = page.getActivePart();
                            cBuild = page.showView("org.eclipse.cdt.ui.BuildConsoleView");
                            page.activate(activePart);
                        }
                    } else {
                        page.bringToTop((IWorkbenchPart)cBuild);
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }

        public void close() throws IOException {
            this.flush(true);
        }
    }

    private class BuildConsoleDocument
    extends Document {
        private int fMaxLines;

        public BuildConsoleDocument(int nLines) {
            this.fMaxLines = nLines;
        }

        public void setDocumentSize(int nLines) {
            this.fMaxLines = nLines;
            nLines = this.getNumberOfLines();
            if (nLines > this.fMaxLines) {
                try {
                    int start = this.getLineOffset(nLines - this.fMaxLines);
                    String part = this.get(start, this.getLength() - start);
                    this.set(part);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public BuildConsoleDocument(String initialContent) {
            super(initialContent);
        }

        public void replace(int offset, int length, String text) throws BadLocationException {
            super.replace(offset, length, text);
            int nLines = this.getNumberOfLines();
            if (nLines > this.fMaxLines) {
                int start = this.getLineOffset(nLines - this.fMaxLines);
                String part = this.get(start, this.getLength() - start);
                this.set(part);
            }
        }
    }
}

