/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICResource;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.IAdornmentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ErrorTickAdornmentProvider
implements IAdornmentProvider {
    private static final int ERRORTICK_WARNING = 16;
    private static final int ERRORTICK_ERROR = 8;

    public int computeAdornmentFlags(Object obj) {
        try {
            if (obj instanceof ICElement) {
                ICElement element = (ICElement)obj;
                if (!element.exists()) {
                    // empty if block
                }
                int type = element.getElementType();
                switch (type) {
                    case 11: 
                    case 12: {
                        return this.getErrorTicksFromMarkers(((ICResource)element).getResource(), 2, null);
                    }
                    case 13: {
                        return this.getErrorTicksFromMarkers(((ICResource)element).getResource(), 1, null);
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 71: 
                    case 74: {
                        ITranslationUnit tu = ((ISourceReference)element).getTranslationUnit();
                        if (tu == null || !tu.exists()) break;
                        ISourceRange range = ((ISourceReference)element).getSourceRange();
                        return this.getErrorTicksFromMarkers(tu.getResource(), 1, range);
                    }
                }
            } else if (obj instanceof IResource) {
                return this.getErrorTicksFromMarkers((IResource)obj, 2, null);
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        return 0;
    }

    public void dispose() {
    }

    private int getErrorTicksFromMarkers(IResource res, int depth, ISourceRange range) throws CoreException {
        if (res == null || !res.exists()) {
            return 0;
        }
        int info = 0;
        IMarker[] markers = res.findMarkers("org.eclipse.cdt.core.problem", true, depth);
        if (markers != null) {
            int i = 0;
            while (i < markers.length && info != 8) {
                IMarker curr = markers[i];
                if (range == null || this.isMarkerInRange(curr, range)) {
                    int priority = curr.getAttribute("severity", -1);
                    if (priority == 1) {
                        info = 16;
                    } else if (priority == 2) {
                        info = 8;
                    }
                }
                ++i;
            }
        }
        return info;
    }

    private boolean isMarkerInRange(IMarker marker, ISourceRange range) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int line;
            int pos = marker.getAttribute("charStart", -1);
            int offset = range.getStartPos();
            if (pos == -1 && (line = MarkerUtilities.getLineNumber((IMarker)marker)) >= 0) {
                return line >= range.getStartLine() && line <= range.getEndLine();
            }
            return offset <= pos && offset + range.getLength() > pos;
        }
        return false;
    }

    private IMarker isAnnotationInRange(IAnnotationModel model, Annotation annot, ISourceRange range) throws CoreException {
        Position pos;
        IMarker marker;
        if (annot instanceof MarkerAnnotation && (marker = ((MarkerAnnotation)annot).getMarker()).exists() && marker.isSubtypeOf("org.eclipse.cdt.core.problem") && (pos = model.getPosition(annot)).overlapsWith(range.getStartPos(), range.getLength())) {
            return marker;
        }
        return null;
    }
}

