/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.core.index.IndexModel;
import org.eclipse.cdt.core.index.TagFlags;
import org.eclipse.cdt.internal.ui.CCompletionContributorManager;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.text.HTMLPrinter;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class DefaultCEditorTextHover
implements ITextHover {
    protected IEditorPart fEditor;

    public DefaultCEditorTextHover(IEditorPart editor) {
        this.fEditor = editor;
    }

    public String getHoverInfo(ITextViewer viewer, IRegion region) {
        String expression = null;
        if (this.fEditor == null) {
            return null;
        }
        try {
            expression = viewer.getDocument().get(region.getOffset(), region.getLength());
            expression = expression.trim();
            if (expression.length() == 0) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            IFunctionSummary fs = CCompletionContributorManager.getDefault().getFunctionInfo(expression);
            if (fs != null) {
                buffer.append("<b>" + HTMLPrinter.convertToHTMLContent(expression) + "()</b> - " + HTMLPrinter.convertToHTMLContent(fs.getSummary()) + "<br><br>" + HTMLPrinter.convertToHTMLContent(fs.getSynopsis()));
                int i = 0;
                while (i < buffer.length()) {
                    if (buffer.charAt(i) == '\\' && i + 1 < buffer.length() && buffer.charAt(i + 1) == 'n') {
                        buffer.replace(i, i + 2, "<br>");
                    }
                    ++i;
                }
            } else {
                IndexModel model = IndexModel.getDefault();
                IEditorInput input = this.fEditor.getEditorInput();
                if (input instanceof IFileEditorInput) {
                    IProject project = ((IFileEditorInput)input).getFile().getProject();
                    if (!project.exists()) {
                        throw new CoreException((IStatus)new Status(0, "", 0, "", null));
                    }
                    IProject[] refs = project.getReferencedProjects();
                    ITagEntry[] tags = model.query(project, expression, false, true);
                    if (tags == null || tags.length == 0) {
                        int j = 0;
                        while (j < refs.length) {
                            if (refs[j].exists() && (tags = model.query(refs[j], expression, false, true)) != null && tags.length > 0) break;
                            ++j;
                        }
                    }
                    if (tags != null && tags.length > 0) {
                        ITagEntry selectedTag = this.selectTag(tags);
                        buffer.append("<b> " + TagFlags.value((int)selectedTag.getKind()) + " " + HTMLPrinter.convertToHTMLContent(expression) + "</b> - " + selectedTag.getIFile().getFullPath().toString() + "[" + selectedTag.getLineNumber() + "]");
                        buffer.append("<br><br>" + HTMLPrinter.convertToHTMLContent(selectedTag.getPattern()));
                    }
                }
            }
            if (buffer.length() > 0) {
                HTMLPrinter.insertPageProlog(buffer, 0);
                HTMLPrinter.addPageEpilog(buffer);
                return buffer.toString();
            }
        }
        catch (BadLocationException x) {
        }
        catch (CoreException x) {
            // empty catch block
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.x >= 0 && selectedRange.y > 0 && offset >= selectedRange.x && offset <= selectedRange.x + selectedRange.y) {
            return new Region(selectedRange.x, selectedRange.y);
        }
        if (viewer != null) {
            return CWordFinder.findWord(viewer.getDocument(), offset);
        }
        return null;
    }

    private ITagEntry selectTag(ITagEntry[] tags) {
        int i = 0;
        while (i < tags.length) {
            if (tags[i].getKind() == 8) {
                return tags[i];
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < tags.length) {
            if (tags[i2].getKind() == 4) {
                return tags[i2];
            }
            ++i2;
        }
        return tags[0];
    }
}

