/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.template;

import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.TemplateVariable;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateVariableProposal
implements ICompletionProposal {
    private TemplateVariable fVariable;
    private int fOffset;
    private int fLength;
    private ITextViewer fViewer;
    private Point fSelection;

    public TemplateVariableProposal(TemplateVariable variable, int offset, int length, ITextViewer viewer) {
        this.fVariable = variable;
        this.fOffset = offset;
        this.fLength = length;
        this.fViewer = viewer;
    }

    public void apply(IDocument document) {
        try {
            String variable = this.fVariable.getName().equals("dollar") ? "$$" : "${" + this.fVariable.getName() + '}';
            document.replace(this.fOffset, this.fLength, variable);
            this.fSelection = new Point(this.fOffset + variable.length(), 0);
        }
        catch (BadLocationException e) {
            CUIPlugin.getDefault().log(e);
            Shell shell = this.fViewer.getTextWidget().getShell();
            MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateVariableProposal.error.title"), (String)e.getMessage());
        }
    }

    public Point getSelection(IDocument document) {
        return this.fSelection;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.fVariable.getName() + " - " + this.fVariable.getDescription();
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

