/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.core.index.IndexModel;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.CDescriptorManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CCorePlugin
extends Plugin {
    public static final int STATUS_CDTPROJECT_EXISTS = 1;
    public static final int STATUS_CDTPROJECT_MISMATCH = 2;
    public static final int CDT_PROJECT_NATURE_ID_MISMATCH = 3;
    public static final String PLUGIN_ID = "org.eclipse.cdt.core";
    public static final String BUILDER_MODEL_ID = "org.eclipse.cdt.core.CBuildModel";
    public static final String BINARY_PARSER_SIMPLE_ID = "BinaryParser";
    public static final String BINARY_PARSER_UNIQ_ID = "org.eclipse.cdt.core.BinaryParser";
    public static final String PREF_BINARY_PARSER = "binaryparser";
    public static final String DEFAULT_BINARY_PARSER_SIMPLE_ID = "ELF";
    public static final String DEFAULT_BINARY_PARSER_UNIQ_ID = "org.eclipse.cdt.core.ELF";
    private static CCorePlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;
    private CDescriptorManager fDescriptorManager;

    public static String getResourceString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
        catch (NullPointerException e) {
            return "#" + key + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getFormattedString(String key, String arg) {
        return MessageFormat.format(CCorePlugin.getResourceString(key), arg);
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(CCorePlugin.getResourceString(key), args);
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public static CCorePlugin getDefault() {
        return fgCPlugin;
    }

    public static void log(Throwable e) {
        CCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }

    public static void log(IStatus status) {
        CCorePlugin.getDefault().getLog().log(status);
    }

    public CCorePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgCPlugin = this;
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        this.fDescriptorManager.shutdown();
    }

    public void startup() throws CoreException {
        super.startup();
        this.getCoreModel();
        this.getIndexModel();
        this.fDescriptorManager = new CDescriptorManager();
        this.fDescriptorManager.startup();
    }

    public IConsole getConsole(String id) {
        try {
            IExtensionPoint extension = this.getDescriptor().getExtensionPoint("CBuildConsole");
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        String builderID = configElements[j].getAttribute("builderID");
                        if (id == null && builderID == null || id != null && builderID.equals(id)) {
                            return (IConsole)configElements[j].createExecutableExtension("class");
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new IConsole(){

            public void clear() {
            }

            public void start(IProject project) {
            }

            public ConsoleOutputStream getOutputStream() {
                return new ConsoleOutputStream();
            }
        };
    }

    public IConsole getConsole() throws CoreException {
        return this.getConsole(null);
    }

    public IBinaryParser getBinaryParser(IProject project) throws CoreException {
        IBinaryParser parser = null;
        try {
            ICDescriptor cdesc = this.getCProjectDescription(project);
            ICExtensionReference[] cextensions = cdesc.get(BINARY_PARSER_UNIQ_ID);
            if (cextensions.length > 0) {
                parser = (IBinaryParser)((Object)cextensions[0].createExtension());
            }
        }
        catch (CoreException e) {
            // empty catch block
        }
        if (parser == null) {
            IExtensionPoint extensionPoint;
            IExtension extension;
            String id = this.getPluginPreferences().getDefaultString(PREF_BINARY_PARSER);
            if (id == null || id.length() == 0) {
                id = DEFAULT_BINARY_PARSER_UNIQ_ID;
            }
            if ((extension = (extensionPoint = this.getDescriptor().getExtensionPoint(BINARY_PARSER_SIMPLE_ID)).getExtension(id)) != null) {
                IConfigurationElement[] element = extension.getConfigurationElements();
                int i = 0;
                while (i < element.length) {
                    if (element[i].getName().equalsIgnoreCase("cextension")) {
                        parser = (IBinaryParser)element[i].createExecutableExtension("run");
                        break;
                    }
                    ++i;
                }
            } else {
                Status s = new Status(4, PLUGIN_ID, -1, "No Binary Format", null);
                throw new CoreException((IStatus)s);
            }
        }
        return parser;
    }

    public CoreModel getCoreModel() {
        return CoreModel.getDefault();
    }

    public IndexModel getIndexModel() {
        return IndexModel.getDefault();
    }

    public ICDescriptor getCProjectDescription(IProject project) throws CoreException {
        return this.fDescriptorManager.getDescriptor(project);
    }

    public void mapCProjectOwner(IProject project, String id, boolean override) throws CoreException {
        if (!override) {
            this.fDescriptorManager.configure(project, id);
        } else {
            this.fDescriptorManager.convert(project, id);
        }
    }

    public IProject createCProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException, OperationCanceledException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Creating C Project", 3);
            if (!projectHandle.exists()) {
                projectHandle.create(description, monitor);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(monitor);
            CProjectNature.addCNature(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.mapCProjectOwner(projectHandle, projectID, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
        return projectHandle;
    }

    public void convertProjectFromCtoCC(IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        if (projectHandle != null && projectHandle.hasNature("org.eclipse.cdt.core.cnature") && !projectHandle.hasNature("org.eclipse.cdt.core.ccnature")) {
            CCProjectNature.addCCNature(projectHandle, monitor);
        }
    }

    public void addDefaultCBuilder(IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        CProjectNature.addCBuildSpec(projectHandle, monitor);
    }

    public void convertProjectToC(IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException {
        this.convertProjectToC(projectHandle, monitor, projectID, true);
    }

    public void convertProjectToC(IProject projectHandle, IProgressMonitor monitor, String projectID, boolean addMakeBuilder) throws CoreException {
        if (projectHandle == null || monitor == null || projectID == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectHandle.getName());
        description.setLocation(projectHandle.getFullPath());
        this.createCProject(description, projectHandle, monitor, projectID);
        if (addMakeBuilder) {
            this.addDefaultCBuilder(projectHandle, monitor);
        }
    }

    public void convertProjectToCC(IProject projectHandle, IProgressMonitor monitor, String projectID, boolean addMakeBuilder) throws CoreException {
        if (projectHandle == null || monitor == null || projectID == null) {
            return;
        }
        this.createCProject(projectHandle.getDescription(), projectHandle, monitor, projectID);
        this.convertProjectFromCtoCC(projectHandle, monitor);
        if (addMakeBuilder) {
            this.addDefaultCBuilder(projectHandle, monitor);
        }
    }

    public void convertProjectToCC(IProject projectHandle, IProgressMonitor monitor, String projectID) throws CoreException {
        this.convertProjectToCC(projectHandle, monitor, projectID, true);
    }

    public IProcessList getProcessList() {
        IExtension[] extensions;
        IConfigurationElement[] configElements;
        IExtensionPoint extension = this.getDescriptor().getExtensionPoint("ProcessList");
        if (extension != null && (configElements = (extensions = extension.getExtensions())[0].getConfigurationElements()).length != 0) {
            try {
                return (IProcessList)configElements[0].createExecutableExtension("class");
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.CCorePluginResources");
        }
        catch (MissingResourceException x) {
            fgResourceBundle = null;
        }
    }
}

