/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIStoppedEvent
extends MIEvent {
    private int threadId;
    private MIFrame frame;
    private MIExecAsyncOutput exec;
    private MIResultRecord rr;

    public MIStoppedEvent(MIExecAsyncOutput record) {
        super(record.getToken());
        this.exec = record;
        this.parse();
    }

    public MIStoppedEvent(MIResultRecord record) {
        super(record.getToken());
        this.rr = record;
        this.parse();
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int id) {
        this.threadId = id;
    }

    public MIFrame getFrame() {
        return this.frame;
    }

    public void setFrame(MIFrame f) {
        this.frame = f;
    }

    public MIExecAsyncOutput getMIExecAsyncOutput() {
        return this.exec;
    }

    public MIResultRecord getMIResultRecord() {
        return this.rr;
    }

    void parse() {
        MIResult[] results = null;
        if (this.exec != null) {
            results = this.exec.getMIResults();
        } else if (this.rr != null) {
            results = this.rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                if (var.equals("thread-id")) {
                    if (value instanceof MIConst) {
                        String str = ((MIConst)value).getString();
                        try {
                            this.threadId = Integer.parseInt(str.trim());
                        }
                        catch (NumberFormatException e) {}
                    }
                } else if (var.equals("frame") && value instanceof MITuple) {
                    this.frame = new MIFrame((MITuple)value);
                }
                ++i;
            }
        }
    }
}

