/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIShared;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public class MIInfoSharedLibraryInfo
extends MIInfo {
    MIShared[] shared;
    boolean isUnixFormat = true;
    boolean hasProcessHeader = false;

    public MIInfoSharedLibraryInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public MIShared[] getMIShared() {
        return this.shared;
    }

    void parse() {
        ArrayList aList = new ArrayList();
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord cons = (MIStreamRecord)oobs[i];
                    String str = cons.getString();
                    this.parseShared(str.trim(), aList);
                }
                ++i;
            }
        }
        this.shared = new MIShared[aList.size()];
        int i = 0;
        while (i < aList.size()) {
            this.shared[i] = (MIShared)aList.get(i);
            ++i;
        }
    }

    void parseShared(String str, List aList) {
        if (!this.hasProcessHeader) {
            if (str.startsWith("DLL")) {
                this.isUnixFormat = false;
            }
            this.hasProcessHeader = true;
        } else if (this.isUnixFormat) {
            this.parseUnixShared(str, aList);
        } else {
            this.parseWinShared(str, aList);
        }
    }

    void parseUnixShared(String str, List aList) {
        if (str.length() > 0 && Character.isDigit(str.charAt(0))) {
            int index = -1;
            long from = 0L;
            long to = 0L;
            boolean syms = false;
            int i = 0;
            while (i < 3 && (index = str.indexOf(32)) != -1) {
                String sub = str.substring(0, index).trim();
                str = str.substring(index).trim();
                switch (i) {
                    case 0: {
                        try {
                            from = Long.decode(sub);
                        }
                        catch (NumberFormatException e) {}
                        break;
                    }
                    case 1: {
                        try {
                            to = Long.decode(sub);
                        }
                        catch (NumberFormatException e) {}
                        break;
                    }
                    case 2: {
                        if (!sub.equalsIgnoreCase("Yes")) break;
                        syms = true;
                        break;
                    }
                    default: {
                        i = 3;
                    }
                }
                ++i;
            }
            MIShared s = new MIShared(from, to, syms, str.trim());
            aList.add(s);
        }
    }

    void parseWinShared(String str, List aList) {
        long from = 0L;
        long to = 0L;
        boolean syms = true;
        int index = str.lastIndexOf(32);
        if (index > 0) {
            String sub = str.substring(index).trim();
            if (!sub.startsWith("0x")) {
                sub = "0x" + sub;
            }
            try {
                from = Long.decode(sub);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            str = str.substring(0, index).trim();
        }
        MIShared s = new MIShared(from, to, syms, str.trim());
        aList.add(s);
    }
}

