/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICFile;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDIEndSteppingRange;
import org.eclipse.cdt.debug.core.cdi.ICDIErrorInfo;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointScope;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointTrigger;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIExitedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIRestartedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.IGlobalVariable;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.CDebugUtils;
import org.eclipse.cdt.debug.internal.core.CMemoryManager;
import org.eclipse.cdt.debug.internal.core.CSharedLibraryManager;
import org.eclipse.cdt.debug.internal.core.CSignalManager;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CRegisterGroup;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceManager;
import org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;

public class CDebugTarget
extends CDebugElement
implements ICDebugTarget,
ICDIEventListener,
ILaunchListener,
IExpressionListener {
    private int fTargetType;
    private ArrayList fThreads;
    private IProcess fDebuggeeProcess = null;
    private IProcess fDebuggerProcess = null;
    private ICDITarget fCDITarget;
    private String fName;
    private boolean fSuspended = true;
    private boolean fTerminated;
    private boolean fTerminating;
    private boolean fDisconnected;
    private ILaunch fLaunch;
    private ICDIConfiguration fConfig;
    private boolean fSupportsTerminate;
    private boolean fSupportsDisconnect;
    private int fCurrentStateId = 0;
    private Object fCurrentStateInfo = null;
    private int fSuspendCount = 0;
    private HashMap fBreakpoints;
    private List fRegisterGroups;
    private CMemoryManager fMemoryManager;
    private DisassemblyManager fDisassemblyManager;
    private CSharedLibraryManager fSharedLibraryManager;
    private CSignalManager fSignalManager;
    private boolean fIsDebuggerProcessDefault = false;
    private IFile fExecFile;
    private boolean fSetBreakpoints = true;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator;
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IDebugTarget;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$model$CDebugTarget;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$cdi$model$ICDITarget;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IState;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$ICExpressionEvaluator;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$ICDebugTargetType;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$ICMemoryManager;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IDebuggerProcessSupport;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IExecFileInfo;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IRunToLine;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IRunToAddress;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IJumpToLine;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IJumpToAddress;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$ICBreakpointManager;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$sourcelookup$DisassemblyManager;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$ICSharedLibraryManager;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$ICSignalManager;

    public CDebugTarget(ILaunch launch, int targetType, ICDITarget cdiTarget, String name, IProcess debuggeeProcess, IProcess debuggerProcess, IFile file, boolean allowsTerminate, boolean allowsDisconnect) {
        super(null);
        this.setLaunch(launch);
        this.setTargetType(targetType);
        this.setDebugTarget(this);
        this.setName(name);
        this.setProcesses(debuggeeProcess, debuggerProcess);
        this.setCDITarget(cdiTarget);
        this.initializeBreakpointMap(new HashMap(5));
        this.setExecFile(file);
        this.setConfiguration(cdiTarget.getSession().getConfiguration());
        this.fSupportsTerminate = allowsTerminate & this.getConfiguration().supportsTerminate();
        this.fSupportsDisconnect = allowsDisconnect & this.getConfiguration().supportsDisconnect();
        this.setThreadList(new ArrayList(5));
        this.setDisassemblyManager(new DisassemblyManager(this));
        this.setSharedLibraryManager(new CSharedLibraryManager(this));
        this.setSignalManager(new CSignalManager(this));
        this.initialize();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionListener)this);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.initializeState();
        this.initializeBreakpoints();
        this.initializeRegisters();
        this.initializeMemoryManager();
        this.getLaunch().addDebugTarget((IDebugTarget)this);
        this.fireCreationEvent();
    }

    private void initializeBreakpoints() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.setBreakpoints();
    }

    protected void initializeState() {
        ICDIThread[] threads = new ICDIThread[]{};
        try {
            threads = this.getCDITarget().getThreads();
        }
        catch (CDIException e) {
            // empty catch block
        }
        int i = 0;
        while (i < threads.length) {
            this.createThread(threads[i]);
            ++i;
        }
    }

    protected void setBreakpoints() {
        if (this.getRetryBreakpoints()) {
            IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] bps = manager.getBreakpoints(CDebugModel.getPluginIdentifier());
            int i = 0;
            while (i < bps.length) {
                if (bps[i] instanceof ICBreakpoint && this.isTargetBreakpoint(bps[i]) && this.findCDIBreakpoint(bps[i]) == null) {
                    if (bps[i] instanceof ICAddressBreakpoint) {
                        try {
                            bps[i].setEnabled(false);
                        }
                        catch (CoreException e) {
                            // empty catch block
                        }
                    }
                    this.breakpointAdded((ICBreakpoint)bps[i]);
                }
                ++i;
            }
            this.setRetryBreakpoints(false);
        }
    }

    private void disableAddressBreakpoints() {
    }

    private boolean isTargetBreakpoint(IBreakpoint bp) {
        IProject project = bp.getMarker().getResource().getProject();
        if (project != null && project.exists()) {
            if (this.getSourceLocator() instanceof IAdaptable) {
                ICSourceLocator sl = (ICSourceLocator)((IAdaptable)this.getSourceLocator()).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = CDebugTarget.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator);
                if (sl != null) {
                    return sl.contains((IResource)project);
                }
            } else {
                if (project.equals((Object)this.getExecFile().getProject())) {
                    return true;
                }
                return CDebugUtils.isReferencedProject(this.getExecFile().getProject(), project);
            }
        }
        return false;
    }

    protected void initializeRegisters() {
        this.fRegisterGroups = new ArrayList(20);
        this.createMainRegisterGroup();
    }

    protected void initializeMemoryManager() {
        this.fMemoryManager = new CMemoryManager(this);
    }

    public IProcess getProcess() {
        return this.fIsDebuggerProcessDefault ? this.fDebuggerProcess : this.fDebuggeeProcess;
    }

    protected void setProcesses(IProcess debuggeeProcess, IProcess debuggerProcess) {
        this.fDebuggeeProcess = debuggeeProcess;
        this.fDebuggerProcess = debuggerProcess;
    }

    public IThread[] getThreads() {
        ArrayList threads = this.getThreadList();
        return threads.toArray(new IThread[threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreadList().size() > 0;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    protected void setName(String name) {
        this.fName = name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (!this.getConfiguration().supportsBreakpoints()) {
            return false;
        }
        return this.findCDIBreakpoint(breakpoint) != null;
    }

    private boolean supportsAddressBreakpoint(ICAddressBreakpoint breakpoint) {
        return this.getExecFile() != null && this.getExecFile().getLocation().toOSString().equals(breakpoint.getMarker().getResource().getLocation().toOSString());
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.isAvailable()) {
            return;
        }
        if (launch.equals(this.getLaunch())) {
            this.disconnected();
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public boolean canTerminate() {
        return this.supportsTerminate() && this.isAvailable();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        try {
            this.setTerminating(true);
            this.getCDISession().terminate();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    protected void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    public boolean canResume() {
        return this.getConfiguration().supportsResume() && this.isSuspended() && this.isAvailable();
    }

    public boolean canSuspend() {
        if (!this.getConfiguration().supportsSuspend()) {
            return false;
        }
        if (!this.isSuspended() && this.isAvailable()) {
            IThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                if (threads[i].isSuspended()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        if (!this.isSuspended()) {
            return;
        }
        this.setBreakpoints();
        try {
            this.getCDITarget().resume();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public void suspend() throws DebugException {
        if (this.isSuspended()) {
            return;
        }
        try {
            this.getCDITarget().suspend();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    protected void suspendThreads(ICDISuspendedEvent event) {
        Iterator it = ((AbstractList)this.getThreadList()).iterator();
        while (it.hasNext()) {
            ((CThread)it.next()).handleDebugEvent(event);
        }
    }

    protected synchronized List refreshThreads() {
        ArrayList<CThread> list = new ArrayList<CThread>(5);
        ArrayList<CThread> newThreads = new ArrayList<CThread>(5);
        try {
            ICDIThread[] cdiThreads = this.getCDITarget().getThreads();
            int i = 0;
            while (i < cdiThreads.length) {
                CThread thread = this.findThread(cdiThreads[i]);
                if (thread == null) {
                    thread = new CThread(this, cdiThreads[i]);
                    newThreads.add(thread);
                } else {
                    ((AbstractCollection)this.getThreadList()).remove(thread);
                }
                list.add(thread);
                ++i;
            }
            Iterator it = ((AbstractList)this.getThreadList()).iterator();
            while (it.hasNext()) {
                ((CThread)it.next()).terminated();
            }
            this.getThreadList().clear();
            this.setThreadList(list);
            it = ((AbstractList)newThreads).iterator();
            while (it.hasNext()) {
                ((CThread)it.next()).fireCreationEvent();
            }
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
        this.setCurrentThread();
        return newThreads;
    }

    protected void resumeThreads(ICDIResumedEvent event) {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!this.isAvailable()) {
            return;
        }
        if (this.getConfiguration().supportsBreakpoints()) {
            try {
                if (breakpoint instanceof ICAddressBreakpoint) {
                    if (this.supportsAddressBreakpoint((ICAddressBreakpoint)breakpoint)) {
                        this.setAddressBreakpoint((ICAddressBreakpoint)breakpoint);
                    }
                } else if (breakpoint instanceof ICLineBreakpoint) {
                    this.setLineBreakpoint((ICLineBreakpoint)breakpoint);
                } else if (breakpoint instanceof ICWatchpoint) {
                    this.setWatchpoint((ICWatchpoint)breakpoint);
                }
            }
            catch (DebugException e) {
                CDebugCorePlugin.log(e);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        try {
            if (breakpoint instanceof CBreakpoint) {
                this.removeBreakpoint((CBreakpoint)breakpoint);
            }
        }
        catch (DebugException e) {
            CDebugCorePlugin.log(e);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        try {
            if (breakpoint instanceof CBreakpoint) {
                this.changeBreakpointProperties((CBreakpoint)breakpoint, delta);
            }
        }
        catch (DebugException e) {
            CDebugCorePlugin.log(e);
        }
    }

    protected boolean supportsDisconnect() {
        return this.getConfiguration().supportsDisconnect();
    }

    protected boolean supportsTerminate() {
        return this.getConfiguration().supportsTerminate();
    }

    public boolean canDisconnect() {
        return this.supportsDisconnect() && !this.isDisconnected() && this.isSuspended();
    }

    public void disconnect() throws DebugException {
        if (this.isDisconnected()) {
            return;
        }
        if (!this.canDisconnect()) {
            this.notSupported("Session does not support 'disconnect'");
        }
        try {
            this.getCDITarget().disconnect();
            this.getCDISession().terminate();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public boolean isDisconnected() {
        return this.fDisconnected;
    }

    protected void setDisconnected(boolean disconnected) {
        this.fDisconnected = disconnected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    private void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    protected ArrayList getThreadList() {
        return this.fThreads;
    }

    private void setThreadList(ArrayList threads) {
        this.fThreads = threads;
    }

    private void setCDITarget(ICDITarget cdiTarget) {
        this.fCDITarget = cdiTarget;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$debug$core$model$IDebugTarget == null ? (class$org$eclipse$debug$core$model$IDebugTarget = CDebugTarget.class$("org.eclipse.debug.core.model.IDebugTarget")) : class$org$eclipse$debug$core$model$IDebugTarget)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$model$CDebugTarget == null ? (class$org$eclipse$cdt$debug$internal$core$model$CDebugTarget = CDebugTarget.class$("org.eclipse.cdt.debug.internal.core.model.CDebugTarget")) : class$org$eclipse$cdt$debug$internal$core$model$CDebugTarget)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$cdi$model$ICDITarget == null ? (class$org$eclipse$cdt$debug$core$cdi$model$ICDITarget = CDebugTarget.class$("org.eclipse.cdt.debug.core.cdi.model.ICDITarget")) : class$org$eclipse$cdt$debug$core$cdi$model$ICDITarget)) {
            return this.fCDITarget;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$IState == null ? (class$org$eclipse$cdt$debug$core$model$IState = CDebugTarget.class$("org.eclipse.cdt.debug.core.model.IState")) : class$org$eclipse$cdt$debug$core$model$IState)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$ICExpressionEvaluator == null ? (class$org$eclipse$cdt$debug$core$model$ICExpressionEvaluator = CDebugTarget.class$("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator")) : class$org$eclipse$cdt$debug$core$model$ICExpressionEvaluator)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$ICDebugTargetType == null ? (class$org$eclipse$cdt$debug$core$model$ICDebugTargetType = CDebugTarget.class$("org.eclipse.cdt.debug.core.model.ICDebugTargetType")) : class$org$eclipse$cdt$debug$core$model$ICDebugTargetType)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode = CDebugTarget.class$("org.eclipse.cdt.debug.core.sourcelookup.ISourceMode")) : class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode) && this.getSourceLocator() instanceof IAdaptable) {
            return ((IAdaptable)this.getSourceLocator()).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode = CDebugTarget.class$("org.eclipse.cdt.debug.core.sourcelookup.ISourceMode")) : class$org$eclipse$cdt$debug$core$sourcelookup$ISourceMode);
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$ICMemoryManager == null ? (class$org$eclipse$cdt$debug$core$ICMemoryManager = CDebugTarget.class$("org.eclipse.cdt.debug.core.ICMemoryManager")) : class$org$eclipse$cdt$debug$core$ICMemoryManager)) {
            return this.getMemoryManager();
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$IDebuggerProcessSupport == null ? (class$org$eclipse$cdt$debug$core$model$IDebuggerProcessSupport = CDebugTarget.class$("org.eclipse.cdt.debug.core.model.IDebuggerProcessSupport")) : class$org$eclipse$cdt$debug$core$model$IDebuggerProcessSupport)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$IExecFileInfo == null ? (class$org$eclipse$cdt$debug$core$model$IExecFileInfo = CDebugTarget.class$("org.eclipse.cdt.debug.core.model.IExecFileInfo")) : class$org$eclipse$cdt$debug$core$model$IExecFileInfo)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$IRunToLine == null ? (class$org$eclipse$cdt$debug$core$model$IRunToLine = CDebugTarget.class$("org.eclipse.cdt.debug.core.model.IRunToLine")) : class$org$eclipse$cdt$debug$core$model$IRunToLine)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$IRunToAddress == null ? (class$org$eclipse$cdt$debug$core$model$IRunToAddress = CDebugTarget.class$("org.eclipse.cdt.debug.core.model.IRunToAddress")) : class$org$eclipse$cdt$debug$core$model$IRunToAddress)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$IJumpToLine == null ? (class$org$eclipse$cdt$debug$core$model$IJumpToLine = CDebugTarget.class$("org.eclipse.cdt.debug.core.model.IJumpToLine")) : class$org$eclipse$cdt$debug$core$model$IJumpToLine)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$model$IJumpToAddress == null ? (class$org$eclipse$cdt$debug$core$model$IJumpToAddress = CDebugTarget.class$("org.eclipse.cdt.debug.core.model.IJumpToAddress")) : class$org$eclipse$cdt$debug$core$model$IJumpToAddress)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$ICBreakpointManager == null ? (class$org$eclipse$cdt$debug$core$ICBreakpointManager = CDebugTarget.class$("org.eclipse.cdt.debug.core.ICBreakpointManager")) : class$org$eclipse$cdt$debug$core$ICBreakpointManager)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$sourcelookup$DisassemblyManager == null ? (class$org$eclipse$cdt$debug$internal$core$sourcelookup$DisassemblyManager = CDebugTarget.class$("org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager")) : class$org$eclipse$cdt$debug$internal$core$sourcelookup$DisassemblyManager)) {
            return this.getDisassemblyManager();
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$ICSharedLibraryManager == null ? (class$org$eclipse$cdt$debug$core$ICSharedLibraryManager = CDebugTarget.class$("org.eclipse.cdt.debug.core.ICSharedLibraryManager")) : class$org$eclipse$cdt$debug$core$ICSharedLibraryManager)) {
            return this.getSharedLibraryManager();
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$ICSignalManager == null ? (class$org$eclipse$cdt$debug$core$ICSignalManager = CDebugTarget.class$("org.eclipse.cdt.debug.core.ICSignalManager")) : class$org$eclipse$cdt$debug$core$ICSignalManager)) {
            return this.getSignalManager();
        }
        return super.getAdapter(adapter);
    }

    public void handleDebugEvent(ICDIEvent event) {
        ICDIObject source = event.getSource();
        if (source == null && event instanceof ICDIDestroyedEvent) {
            this.handleTerminatedEvent((ICDIDestroyedEvent)event);
        } else if (source.getTarget().equals(this.getCDITarget())) {
            if (event instanceof ICDICreatedEvent) {
                if (source instanceof ICDIThread) {
                    this.handleThreadCreatedEvent((ICDICreatedEvent)event);
                }
                if (source instanceof ICDISharedLibrary) {
                    this.getSharedLibraryManager().sharedLibraryLoaded((ICDISharedLibrary)source);
                    if (((ICDISharedLibrary)source).areSymbolsLoaded()) {
                        this.setRetryBreakpoints(true);
                    }
                }
                if (source instanceof ICDILocationBreakpoint) {
                    this.handleLocationBreakpointCreatedEvent((ICDILocationBreakpoint)source);
                }
                if (source instanceof ICDIWatchpoint) {
                    this.handleWatchpointCreatedEvent((ICDIWatchpoint)source);
                }
            } else if (event instanceof ICDISuspendedEvent) {
                if (source instanceof ICDITarget || source instanceof ICDIThread) {
                    this.handleSuspendedEvent((ICDISuspendedEvent)event);
                }
            } else if (event instanceof ICDIResumedEvent) {
                if (source instanceof ICDITarget) {
                    this.handleResumedEvent((ICDIResumedEvent)event);
                }
            } else if (event instanceof ICDIExitedEvent) {
                if (source instanceof ICDITarget) {
                    this.handleExitedEvent((ICDIExitedEvent)event);
                }
            } else if (event instanceof ICDIDestroyedEvent) {
                if (source instanceof ICDIThread) {
                    this.handleThreadTerminatedEvent((ICDIDestroyedEvent)event);
                }
                if (source instanceof ICDISharedLibrary) {
                    this.getSharedLibraryManager().sharedLibraryUnloaded((ICDISharedLibrary)source);
                }
                if (source instanceof ICDIBreakpoint) {
                    this.handleBreakpointDestroyedEvent((ICDIBreakpoint)source);
                }
            } else if (event instanceof ICDIDisconnectedEvent) {
                if (source instanceof ICDITarget) {
                    this.handleDisconnectedEvent((ICDIDisconnectedEvent)event);
                }
            } else if (event instanceof ICDIChangedEvent) {
                if (source instanceof ICDITarget) {
                    this.handleChangedEvent((ICDIChangedEvent)event);
                }
                if (source instanceof ICDISharedLibrary) {
                    this.getSharedLibraryManager().symbolsLoaded((ICDISharedLibrary)source);
                }
                if (source instanceof ICDISignal) {
                    this.getSignalManager().signalChanged((ICDISignal)source);
                }
                if (source instanceof ICDIBreakpoint) {
                    this.handleBreakpointChangedEvent((ICDIBreakpoint)source);
                }
            } else if (event instanceof ICDIRestartedEvent && source instanceof ICDITarget) {
                this.handleRestartedEvent((ICDIRestartedEvent)event);
            }
        }
    }

    public boolean canRestart() {
        return this.getConfiguration().supportsRestart() && this.isSuspended() && this.isAvailable();
    }

    public void restart() throws DebugException {
        if (!this.canRestart()) {
            return;
        }
        try {
            ICDILocation location = this.getCDISession().getBreakpointManager().createLocation("", "main", 0);
            this.setInternalTemporaryBreakpoint(location);
            this.getCDITarget().restart();
            this.restarted();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    protected void restarted() {
    }

    public int[] getSupportedFormats() throws DebugException {
        return null;
    }

    public boolean isAvailable() {
        return !this.isTerminated() && !this.isTerminating() && !this.isDisconnected();
    }

    private void setSuspended(boolean suspended) {
        this.fSuspended = suspended;
    }

    protected boolean isTerminating() {
        return this.fTerminating;
    }

    protected void setTerminating(boolean terminating) {
        this.fTerminating = terminating;
    }

    protected void terminated() {
        this.setTerminating(false);
        if (!this.isTerminated()) {
            if (!this.isDisconnected()) {
                this.setTerminated(true);
            }
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void disconnected() {
        if (!this.isDisconnected()) {
            this.setDisconnected(true);
            try {
                this.getCDISession().terminate();
            }
            catch (CDIException e) {
                this.logError(e);
            }
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected void cleanup() {
        this.removeAllThreads();
        this.removeAllRegisterGroups();
        this.getCDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.disposeMemoryManager();
        this.disposeSharedLibraryManager();
        this.disposeSignalManager();
        this.removeAllExpressions();
        try {
            this.removeAllBreakpoints();
        }
        catch (DebugException e) {
            CDebugCorePlugin.log(e);
        }
    }

    protected void removeAllThreads() {
        Iterator itr = ((AbstractList)this.getThreadList()).iterator();
        this.setThreadList(new ArrayList(0));
        while (itr.hasNext()) {
            CThread thread = (CThread)itr.next();
            thread.terminated();
        }
    }

    protected void removeAllExpressions() {
        IExpressionManager em = DebugPlugin.getDefault().getExpressionManager();
        IExpression[] expressions = em.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            if (expressions[i] instanceof CExpression && expressions[i].getDebugTarget().equals(this)) {
                em.removeExpression(expressions[i]);
            }
            ++i;
        }
    }

    protected void removeAllBreakpoints() throws DebugException {
        ICDIBreakpoint[] cdiBreakpoints = this.getBreakpoints().values().toArray(new ICDIBreakpoint[0]);
        ICDIBreakpointManager bm = this.getCDISession().getBreakpointManager();
        if (cdiBreakpoints.length > 0) {
            try {
                bm.deleteBreakpoints(cdiBreakpoints);
            }
            catch (CDIException e) {
                this.logError(e);
            }
            try {
                Iterator it = this.getBreakpoints().keySet().iterator();
                while (it.hasNext()) {
                    ((CBreakpoint)it.next()).decrementInstallCount();
                }
                this.getBreakpoints().clear();
            }
            catch (CoreException ce) {
                this.logError((Exception)((Object)ce));
            }
        }
    }

    protected void removeBreakpoint(CBreakpoint breakpoint) throws DebugException {
        ICDIBreakpoint cdiBreakpoint = this.findCDIBreakpoint(breakpoint);
        if (cdiBreakpoint == null) {
            return;
        }
        ICDIBreakpointManager bm = this.getCDISession().getBreakpointManager();
        try {
            bm.deleteBreakpoints(new ICDIBreakpoint[]{cdiBreakpoint});
            this.getBreakpoints().remove(breakpoint);
            breakpoint.decrementInstallCount();
        }
        catch (CoreException ce) {
            this.requestFailed("Operation failed. Reason: ", (Exception)((Object)ce));
        }
        catch (CDIException e) {
            this.requestFailed("Operation failed. Reason: ", e);
        }
    }

    protected void changeBreakpointProperties(CBreakpoint breakpoint, IMarkerDelta delta) throws DebugException {
        ICDIBreakpoint cdiBreakpoint = this.findCDIBreakpoint(breakpoint);
        if (cdiBreakpoint == null) {
            return;
        }
        ICDIBreakpointManager bm = this.getCDISession().getBreakpointManager();
        try {
            boolean enabled = breakpoint.isEnabled();
            boolean oldEnabled = delta.getAttribute("org.eclipse.debug.core.enabled", true);
            int ignoreCount = breakpoint.getIgnoreCount();
            int oldIgnoreCount = delta.getAttribute("org.eclipse.cdt.debug.core.ignoreCount", 0);
            String condition = breakpoint.getCondition();
            String oldCondition = delta.getAttribute("org.eclipse.cdt.debug.core.condition", "");
            if (enabled != oldEnabled) {
                cdiBreakpoint.setEnabled(enabled);
            }
            if (ignoreCount != oldIgnoreCount || !condition.equals(oldCondition)) {
                ICDICondition cdiCondition = bm.createCondition(ignoreCount, condition);
                cdiBreakpoint.setCondition(cdiCondition);
            }
        }
        catch (CoreException ce) {
            this.requestFailed("Operation failed. Reason: ", (Exception)((Object)ce));
        }
        catch (CDIException e) {
            this.requestFailed("Operation failed. Reason: ", e);
        }
    }

    protected CThread createThread(ICDIThread cdiThread) {
        CThread thread = new CThread(this, cdiThread);
        this.getThreadList().add(thread);
        thread.fireCreationEvent();
        return thread;
    }

    protected CThread createRunningThread(ICDIThread cdiThread) {
        CThread thread = new CThread(this, cdiThread);
        thread.setRunning(true);
        this.getThreadList().add(thread);
        thread.fireCreationEvent();
        return thread;
    }

    private void handleSuspendedEvent(ICDISuspendedEvent event) {
        CThread thread;
        this.setSuspended(true);
        this.setCurrentStateId(7);
        ICDISessionObject reason = event.getReason();
        this.setCurrentStateInfo(reason);
        List newThreads = this.refreshThreads();
        if (event.getSource() instanceof ICDITarget) {
            this.suspendThreads(event);
            this.fireSuspendEvent(0);
        } else if (event.getSource() instanceof ICDIThread && (thread = this.findThread((ICDIThread)event.getSource())) != null && newThreads.contains(thread)) {
            thread.handleDebugEvent(event);
        }
        if (reason instanceof ICDIEndSteppingRange) {
            this.handleEndSteppingRange((ICDIEndSteppingRange)reason);
        } else if (reason instanceof ICDIBreakpointHit) {
            this.handleBreakpointHit((ICDIBreakpointHit)reason);
        } else if (reason instanceof ICDISignalReceived) {
            this.handleSuspendedBySignal((ICDISignalReceived)reason);
        } else if (reason instanceof ICDIWatchpointTrigger) {
            this.handleWatchpointTrigger((ICDIWatchpointTrigger)reason);
        } else if (reason instanceof ICDIWatchpointScope) {
            this.handleWatchpointScope((ICDIWatchpointScope)reason);
        } else if (reason instanceof ICDIErrorInfo) {
            this.handleErrorInfo((ICDIErrorInfo)reason);
        }
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        this.setSuspended(false);
        this.setCurrentStateId(5);
        this.setCurrentStateInfo(null);
        this.resumeThreads(event);
        int detail = 0;
        switch (event.getType()) {
            case 0: {
                detail = 32;
                break;
            }
            case 2: 
            case 4: {
                detail = 1;
                break;
            }
            case 1: 
            case 3: {
                detail = 2;
                break;
            }
            case 5: {
                detail = 4;
            }
        }
        this.fireResumeEvent(detail);
    }

    private void handleEndSteppingRange(ICDIEndSteppingRange endSteppingRange) {
        this.fireSuspendEvent(0);
    }

    private void handleBreakpointHit(ICDIBreakpointHit breakpointHit) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointTrigger(ICDIWatchpointTrigger wt) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointScope(ICDIWatchpointScope ws) {
        CBreakpoint watchpoint = (CBreakpoint)this.findBreakpoint(ws.getWatchpoint());
        try {
            this.removeBreakpoint(watchpoint);
        }
        catch (DebugException e) {
            CDebugCorePlugin.log(e);
        }
        this.fireSuspendEvent(16);
    }

    private void handleSuspendedBySignal(ICDISignalReceived signal) {
        this.fireSuspendEvent(0);
    }

    private void handleErrorInfo(ICDIErrorInfo info) {
        if (info != null) {
            MultiStatus status = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 10002, "The execution of program is suspended because of error.", null);
            StringTokenizer st = new StringTokenizer(info.getDetailMessage(), "\n\r");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() > 200) {
                    token = token.substring(0, 200);
                }
                status.add((IStatus)new Status(4, status.getPlugin(), 10002, token, null));
            }
            CDebugUtils.error((IStatus)status, this);
        }
    }

    private void handleExitedEvent(ICDIExitedEvent event) {
        this.removeAllThreads();
        this.setCurrentStateId(8);
        this.setCurrentStateInfo(event.getReason());
        this.fireChangeEvent(512);
        try {
            this.terminate();
        }
        catch (DebugException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    private void handleTerminatedEvent(ICDIDestroyedEvent event) {
        this.terminated();
    }

    private void handleDisconnectedEvent(ICDIDisconnectedEvent event) {
        this.setCurrentStateId(9);
        this.setCurrentStateInfo(null);
        this.disconnected();
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
    }

    private void handleRestartedEvent(ICDIRestartedEvent event) {
    }

    private void handleThreadCreatedEvent(ICDICreatedEvent event) {
        ICDIThread cdiThread = (ICDIThread)event.getSource();
        CThread thread = this.findThread(cdiThread);
        if (thread == null) {
            this.createThread(cdiThread);
        }
    }

    private void handleThreadTerminatedEvent(ICDIDestroyedEvent event) {
        ICDIThread cdiThread = (ICDIThread)event.getSource();
        CThread thread = this.findThread(cdiThread);
        if (thread != null) {
            ((AbstractCollection)this.getThreadList()).remove(thread);
            thread.terminated();
        }
    }

    private void handleLocationBreakpointCreatedEvent(final ICDILocationBreakpoint breakpoint) {
        Runnable runnable = new Runnable(){

            public void run() {
                CDebugTarget.this.doHandleLocationBreakpointCreatedEvent(breakpoint);
            }
        };
        CDebugCorePlugin.getDefault().asyncExec(runnable);
    }

    protected void doHandleLocationBreakpointCreatedEvent(ICDILocationBreakpoint cdiBreakpoint) {
        if (cdiBreakpoint.isTemporary() || this.getBreakpoints().containsValue(cdiBreakpoint)) {
            return;
        }
        try {
            if (cdiBreakpoint.getLocation().getFile() != null && cdiBreakpoint.getLocation().getFile().length() > 0) {
                if (this.getSourceLocator() instanceof IAdaptable && ((IAdaptable)this.getSourceLocator()).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = CDebugTarget.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator) != null) {
                    Object sourceElement = ((ICSourceLocator)((IAdaptable)this.getSourceLocator()).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = CDebugTarget.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator)).findSourceElement(cdiBreakpoint.getLocation().getFile());
                    if (sourceElement != null && sourceElement instanceof IFile) {
                        this.createLineBreakpoint((IFile)sourceElement, cdiBreakpoint);
                    } else if (cdiBreakpoint.getLocation().getAddress() > 0L) {
                        this.createAddressBreakpoint(cdiBreakpoint);
                    }
                }
            } else if (cdiBreakpoint.getLocation().getAddress() > 0L) {
                this.createAddressBreakpoint(cdiBreakpoint);
            }
        }
        catch (CDIException e) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void createLineBreakpoint(IFile file, ICDILocationBreakpoint cdiBreakpoint) throws CDIException, CoreException {
        ICLineBreakpoint breakpoint = CDebugModel.createLineBreakpoint((IResource)file, cdiBreakpoint.getLocation().getLineNumber(), cdiBreakpoint.isEnabled(), cdiBreakpoint.getCondition().getIgnoreCount(), cdiBreakpoint.getCondition().getExpression(), false);
        this.getBreakpoints().put(breakpoint, cdiBreakpoint);
        ((CBreakpoint)((Object)breakpoint)).register(true);
    }

    private void createAddressBreakpoint(ICDILocationBreakpoint cdiBreakpoint) throws CDIException, CoreException {
        ICAddressBreakpoint breakpoint = CDebugModel.createAddressBreakpoint((IResource)this.getExecFile(), cdiBreakpoint.getLocation().getAddress(), cdiBreakpoint.isEnabled(), cdiBreakpoint.getCondition().getIgnoreCount(), cdiBreakpoint.getCondition().getExpression(), false);
        this.getBreakpoints().put(breakpoint, cdiBreakpoint);
        ((CBreakpoint)((Object)breakpoint)).register(true);
    }

    private void handleWatchpointCreatedEvent(final ICDIWatchpoint watchpoint) {
        Runnable runnable = new Runnable(){

            public void run() {
                CDebugTarget.this.doHandleWatchpointCreatedEvent(watchpoint);
            }
        };
        CDebugCorePlugin.getDefault().asyncExec(runnable);
    }

    protected void doHandleWatchpointCreatedEvent(ICDIWatchpoint cdiWatchpoint) {
        if (this.getBreakpoints().containsValue(cdiWatchpoint)) {
            return;
        }
        try {
            ICWatchpoint watchpoint = CDebugModel.createWatchpoint((IResource)this.getExecFile().getProject(), cdiWatchpoint.isWriteType(), cdiWatchpoint.isReadType(), cdiWatchpoint.getWatchExpression(), cdiWatchpoint.isEnabled(), cdiWatchpoint.getCondition().getIgnoreCount(), cdiWatchpoint.getCondition().getExpression(), false);
            this.getBreakpoints().put(watchpoint, cdiWatchpoint);
            ((CBreakpoint)((Object)watchpoint)).register(true);
        }
        catch (CDIException e) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void handleBreakpointDestroyedEvent(final ICDIBreakpoint breakpoint) {
        Runnable runnable = new Runnable(){

            public void run() {
                CDebugTarget.this.doHandleBreakpointDestroyedEvent(breakpoint);
            }
        };
        CDebugCorePlugin.getDefault().asyncExec(runnable);
    }

    protected void doHandleBreakpointDestroyedEvent(ICDIBreakpoint cdiBreakpoint) {
        IBreakpoint breakpoint = this.findBreakpoint(cdiBreakpoint);
        if (breakpoint != null) {
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, true);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private void handleBreakpointChangedEvent(final ICDIBreakpoint breakpoint) {
        Runnable runnable = new Runnable(){

            public void run() {
                CDebugTarget.this.doHandleBreakpointChangedEvent(breakpoint);
            }
        };
        CDebugCorePlugin.getDefault().asyncExec(runnable);
    }

    protected void doHandleBreakpointChangedEvent(ICDIBreakpoint cdiBreakpoint) {
        IBreakpoint breakpoint = this.findBreakpoint(cdiBreakpoint);
        if (breakpoint instanceof ICBreakpoint) {
            try {
                Map attributes = breakpoint.getMarker().getAttributes();
                attributes.put("org.eclipse.debug.core.enabled", new Boolean(cdiBreakpoint.isEnabled()));
                attributes.put("org.eclipse.cdt.debug.core.ignoreCount", new Integer(cdiBreakpoint.getCondition().getIgnoreCount()));
                attributes.put("org.eclipse.cdt.debug.core.condition", cdiBreakpoint.getCondition().getExpression());
                breakpoint.getMarker().setAttributes(attributes);
            }
            catch (CDIException e) {
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
    }

    public CThread findThread(ICDIThread cdiThread) {
        ArrayList threads = this.getThreadList();
        int i = 0;
        while (i < threads.size()) {
            CThread t = (CThread)threads.get(i);
            if (t.getCDIThread().equals(cdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public int getCurrentStateId() {
        return this.fCurrentStateId;
    }

    private void setCurrentStateId(int id) {
        this.fCurrentStateId = id;
    }

    public Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    private void setCurrentStateInfo(Object info) {
        this.fCurrentStateInfo = info;
    }

    protected int getSuspendCount() {
        return this.fSuspendCount;
    }

    protected void incrementSuspendCount() {
        ++this.fSuspendCount;
    }

    public void fireSuspendEvent(int detail) {
        this.incrementSuspendCount();
        super.fireSuspendEvent(detail);
    }

    protected void setCurrentThread() {
        ICDIThread currentCDIThread = null;
        try {
            currentCDIThread = this.getCDITarget().getCurrentThread();
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
        Iterator it = ((AbstractList)this.getThreadList()).iterator();
        while (it.hasNext()) {
            CThread thread = (CThread)it.next();
            thread.setCurrent(currentCDIThread != null && thread.getCDIThread().equals(currentCDIThread));
        }
        if (currentCDIThread == null && !this.getThreadList().isEmpty()) {
            ((CThread)this.getThreadList().get(0)).setCurrent(true);
        }
    }

    protected HashMap getBreakpoints() {
        return this.fBreakpoints;
    }

    private void initializeBreakpointMap(HashMap breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    protected ICDIConfiguration getConfiguration() {
        return this.fConfig;
    }

    private void setConfiguration(ICDIConfiguration config) {
        this.fConfig = config;
    }

    private void setLineBreakpoint(ICLineBreakpoint breakpoint) throws DebugException {
        try {
            ICDIBreakpoint cdiBreakpoint = (ICDIBreakpoint)this.getBreakpoints().get(breakpoint);
            if (cdiBreakpoint == null) {
                cdiBreakpoint = this.setLineBreakpoint0(breakpoint);
            }
            ((CBreakpoint)((Object)breakpoint)).incrementInstallCount();
            if (!breakpoint.isEnabled()) {
                cdiBreakpoint.setEnabled(false);
            }
        }
        catch (CoreException ce) {
            this.requestFailed("Operation failed. Reason: ", (Exception)((Object)ce));
        }
        catch (CDIException e) {
            this.requestFailed("Operation failed. Reason: ", e);
        }
    }

    private synchronized ICDIBreakpoint setLineBreakpoint0(ICLineBreakpoint breakpoint) throws CDIException, CoreException {
        ICDIBreakpointManager bm = this.getCDISession().getBreakpointManager();
        ICDILocation location = bm.createLocation(breakpoint.getMarker().getResource().getLocation().lastSegment(), null, breakpoint.getLineNumber());
        ICDICondition condition = bm.createCondition(breakpoint.getIgnoreCount(), breakpoint.getCondition());
        ICDILocationBreakpoint cdiBreakpoint = bm.setLocationBreakpoint(0, location, condition, null);
        this.getBreakpoints().put(breakpoint, cdiBreakpoint);
        return cdiBreakpoint;
    }

    private void setAddressBreakpoint(ICAddressBreakpoint breakpoint) throws DebugException {
        try {
            ICDIBreakpoint cdiBreakpoint = (ICDIBreakpoint)this.getBreakpoints().get(breakpoint);
            if (cdiBreakpoint == null) {
                cdiBreakpoint = this.setAddressBreakpoint0(breakpoint);
            }
            ((CBreakpoint)((Object)breakpoint)).incrementInstallCount();
            if (!breakpoint.isEnabled()) {
                cdiBreakpoint.setEnabled(false);
            }
        }
        catch (CoreException ce) {
            this.requestFailed("Operation failed. Reason: ", (Exception)((Object)ce));
        }
        catch (CDIException e) {
            this.requestFailed("Operation failed. Reason: ", e);
        }
        catch (NumberFormatException e) {
            this.requestFailed("Operation failed. Reason: ", e);
        }
    }

    private synchronized ICDIBreakpoint setAddressBreakpoint0(ICAddressBreakpoint breakpoint) throws CDIException, CoreException {
        ICDIBreakpointManager bm = this.getCDISession().getBreakpointManager();
        ICDILocation location = bm.createLocation(Long.parseLong(breakpoint.getAddress()));
        ICDICondition condition = bm.createCondition(breakpoint.getIgnoreCount(), breakpoint.getCondition());
        ICDILocationBreakpoint cdiBreakpoint = bm.setLocationBreakpoint(0, location, condition, null);
        this.getBreakpoints().put(breakpoint, cdiBreakpoint);
        return cdiBreakpoint;
    }

    private void setWatchpoint(ICWatchpoint watchpoint) throws DebugException {
        try {
            ICDIWatchpoint cdiWatchpoint = (ICDIWatchpoint)this.getBreakpoints().get(watchpoint);
            if (cdiWatchpoint == null) {
                cdiWatchpoint = this.setWatchpoint0(watchpoint);
            }
            ((CBreakpoint)((Object)watchpoint)).incrementInstallCount();
            if (!watchpoint.isEnabled()) {
                cdiWatchpoint.setEnabled(false);
            }
        }
        catch (CoreException ce) {
            this.requestFailed("Operation failed. Reason: ", (Exception)((Object)ce));
        }
        catch (CDIException e) {
            this.requestFailed("Operation failed. Reason: ", e);
        }
    }

    private synchronized ICDIWatchpoint setWatchpoint0(ICWatchpoint watchpoint) throws CDIException, CoreException {
        ICDIBreakpointManager bm = this.getCDISession().getBreakpointManager();
        ICDICondition condition = bm.createCondition(watchpoint.getIgnoreCount(), watchpoint.getCondition());
        int accessType = 0;
        accessType |= watchpoint.isWriteType() ? 1 : 0;
        int n = watchpoint.isReadType() ? 2 : 0;
        String expression = watchpoint.getExpression();
        ICDIWatchpoint cdiWatchpoint = bm.setWatchpoint(0, accessType |= n, expression, condition);
        this.getBreakpoints().put(watchpoint, cdiWatchpoint);
        return cdiWatchpoint;
    }

    private ICDIBreakpoint findCDIBreakpoint(IBreakpoint breakpoint) {
        return (ICDIBreakpoint)this.getBreakpoints().get(breakpoint);
    }

    private IBreakpoint findBreakpoint(ICDIBreakpoint cdiBreakpoint) {
        if (cdiBreakpoint == null) {
            return null;
        }
        Iterator it = this.getBreakpoints().keySet().iterator();
        while (it.hasNext()) {
            IBreakpoint breakpoint = (IBreakpoint)it.next();
            if (!cdiBreakpoint.equals(this.getBreakpoints().get(breakpoint))) continue;
            return breakpoint;
        }
        return null;
    }

    public String evaluateExpressionToString(String expression) throws DebugException {
        try {
            return this.getCDITarget().evaluateExpressionToString(expression);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
            return null;
        }
    }

    public boolean canEvaluate() {
        return this.isAvailable() && this.isSuspended();
    }

    protected IRegisterGroup[] getRegisterGroups() throws DebugException {
        return this.fRegisterGroups.toArray(new IRegisterGroup[this.fRegisterGroups.size()]);
    }

    protected IRegisterGroup[] getRegisterGroups(CStackFrame stackFrame) throws DebugException {
        return this.fRegisterGroups.toArray(new IRegisterGroup[this.fRegisterGroups.size()]);
    }

    protected void createMainRegisterGroup() {
        ICDIRegisterObject[] regObjects = null;
        try {
            regObjects = this.getCDISession().getRegisterManager().getRegisterObjects();
        }
        catch (CDIException e) {
            CDebugCorePlugin.log(e);
        }
        if (regObjects != null) {
            this.fRegisterGroups.add(new CRegisterGroup(this, "Main", regObjects));
        }
    }

    protected void removeAllRegisterGroups() {
        Iterator it = this.fRegisterGroups.iterator();
        while (it.hasNext()) {
            ((CRegisterGroup)((Object)it.next())).dispose();
        }
    }

    public void expressionAdded(IExpression expression) {
    }

    public void expressionChanged(IExpression expression) {
    }

    public void expressionRemoved(IExpression expression) {
        if (expression != null && expression.getDebugTarget().equals(this) && expression instanceof CExpression) {
            ICDIExpressionManager em = this.getCDISession().getExpressionManager();
            try {
                em.destroyExpression(((CExpression)expression).getCDIExpression());
            }
            catch (CDIException cDIException) {
                // empty catch block
            }
        }
    }

    public void setInternalTemporaryBreakpoint(ICDILocation location) throws DebugException {
        try {
            this.getCDISession().getBreakpointManager().setLocationBreakpoint(1, location, null, null);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean canRunToLine(IResource resource, int lineNumber) {
        return this.canResume();
    }

    public void runToLine(IResource resource, int lineNumber) throws DebugException {
        if (!this.canRunToLine(resource, lineNumber)) {
            return;
        }
        this.setBreakpoints();
        ICDILocation location = this.getCDISession().getBreakpointManager().createLocation(resource.getLocation().lastSegment(), null, lineNumber);
        try {
            this.getCDITarget().runUntil(location);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public void setCurrentThread(IThread thread) throws DebugException {
        if (!(this.isSuspended() && this.isAvailable() && thread != null && thread instanceof CThread)) {
            return;
        }
        try {
            CThread oldThread = (CThread)this.getCurrentThread();
            if (!oldThread.equals(thread)) {
                oldThread.setCurrent(false);
                this.getCDITarget().setCurrentThread(((CThread)thread).getCDIThread());
                ((CThread)thread).setCurrent(true);
            }
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    public IThread getCurrentThread() throws DebugException {
        IThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            if (((CThread)threads[i]).isCurrent()) {
                return threads[i];
            }
            ++i;
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        return this.getLaunch().getSourceLocator();
    }

    protected void resetRegisters() {
        Iterator it = this.fRegisterGroups.iterator();
        while (it.hasNext()) {
            ((CRegisterGroup)((Object)it.next())).resetChangeFlags();
        }
    }

    public int getTargetType() {
        return this.fTargetType;
    }

    private void setTargetType(int targetType) {
        this.fTargetType = targetType;
    }

    protected boolean isCoreDumpTarget() {
        return this.getTargetType() == 3;
    }

    protected int getRealSourceMode() {
        ISourceLocator sl = this.getSourceLocator();
        if (sl != null && sl instanceof IAdaptable && ((IAdaptable)sl).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = CDebugTarget.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator) != null && ((IAdaptable)sl).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = CDebugTarget.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator) instanceof CSourceManager) {
            return ((CSourceManager)((IAdaptable)sl).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = CDebugTarget.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator)).getRealMode();
        }
        return 0;
    }

    protected CMemoryManager getMemoryManager() {
        return this.fMemoryManager;
    }

    private void disposeMemoryManager() {
        this.getMemoryManager().dispose();
    }

    public boolean isDebuggerProcessDefault() {
        return this.fIsDebuggerProcessDefault;
    }

    public void setDebuggerProcessDefault(boolean value) {
        this.fIsDebuggerProcessDefault = value;
    }

    public boolean supportsDebuggerProcess() {
        return this.fDebuggerProcess != null;
    }

    public boolean isLittleEndian() {
        ICFile cFile;
        if (this.getExecFile() != null && CoreModel.getDefault().isBinary(this.getExecFile()) && (cFile = CCorePlugin.getDefault().getCoreModel().create(this.getExecFile())) instanceof IBinary) {
            ((IBinary)cFile).isLittleEndian();
        }
        return true;
    }

    public IFile getExecFile() {
        return this.fExecFile;
    }

    private void setExecFile(IFile file) {
        this.fExecFile = file;
    }

    public IGlobalVariable[] getGlobals() {
        ICFile cFile;
        ArrayList list = new ArrayList();
        if (this.getExecFile() != null && CoreModel.getDefault().isBinary(this.getExecFile()) && (cFile = CCorePlugin.getDefault().getCoreModel().create(this.getExecFile())) instanceof IBinary) {
            list.addAll(this.getCFileGlobals(cFile));
        }
        return list.toArray(new IGlobalVariable[list.size()]);
    }

    private List getCFileGlobals(ICFile file) {
        ArrayList<IGlobalVariable> list = new ArrayList<IGlobalVariable>();
        ICElement[] elements = file.getChildren();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IVariable) {
                list.add(this.createGlobalVariable((IVariable)elements[i]));
            } else if (elements[i] instanceof ICFile) {
                list.addAll(this.getCFileGlobals((ICFile)elements[i]));
            }
            ++i;
        }
        return list;
    }

    private IGlobalVariable createGlobalVariable(final IVariable var) {
        return new IGlobalVariable(){

            public String getName() {
                return var.getElementName();
            }

            public IPath getPath() {
                IPath path = null;
                if (var.getParent() != null && var.getParent() instanceof ICFile && !(var.getParent() instanceof IBinary) && ((ICFile)var.getParent()).getFile() != null) {
                    path = ((ICFile)var.getParent()).getFile().getLocation();
                }
                return path;
            }
        };
    }

    protected void setDisassemblyManager(DisassemblyManager dm) {
        this.fDisassemblyManager = dm;
    }

    protected DisassemblyManager getDisassemblyManager() {
        return this.fDisassemblyManager;
    }

    protected void setSharedLibraryManager(CSharedLibraryManager libman) {
        this.fSharedLibraryManager = libman;
    }

    protected CSharedLibraryManager getSharedLibraryManager() {
        return this.fSharedLibraryManager;
    }

    protected void disposeSharedLibraryManager() {
        this.fSharedLibraryManager.dispose();
    }

    protected void setSignalManager(CSignalManager sm) {
        this.fSignalManager = sm;
    }

    protected CSignalManager getSignalManager() {
        return this.fSignalManager;
    }

    protected void disposeSignalManager() {
        this.fSignalManager.dispose();
    }

    public long getBreakpointAddress(IBreakpoint breakpoint) {
        ICDIBreakpoint cdiBreakpoint = this.findCDIBreakpoint(breakpoint);
        if (cdiBreakpoint != null && cdiBreakpoint instanceof ICDILocationBreakpoint) {
            try {
                ICDILocation location = ((ICDILocationBreakpoint)cdiBreakpoint).getLocation();
                if (location != null) {
                    return location.getAddress();
                }
            }
            catch (CDIException cDIException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public boolean canRunToAddress(long address) {
        return this.canResume();
    }

    public void runToAddress(long address) throws DebugException {
        if (!this.canRunToAddress(address)) {
            return;
        }
        this.setBreakpoints();
        ICDILocation location = this.getCDISession().getBreakpointManager().createLocation(address);
        try {
            this.getCDITarget().runUntil(location);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    private boolean getRetryBreakpoints() {
        return this.fSetBreakpoints;
    }

    public void setRetryBreakpoints(boolean retry) {
        this.fSetBreakpoints = retry;
    }

    public boolean canResumeWithoutSignal() {
        return this.isSuspended() && this.getCurrentStateInfo() instanceof ICDISignalReceived;
    }

    public void resumeWithoutSignal() throws DebugException {
        try {
            this.getCDITarget().signal();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public boolean canJumpToLine(IResource resource, int lineNumber) {
        return this.canResume();
    }

    public void jumpToLine(IResource resource, int lineNumber) throws DebugException {
        if (!this.canJumpToLine(resource, lineNumber)) {
            return;
        }
        this.setBreakpoints();
        ICDILocation location = this.getCDISession().getBreakpointManager().createLocation(resource.getLocation().lastSegment(), null, lineNumber);
        try {
            this.getCDITarget().jump(location);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public boolean canJumpToAddress(long address) {
        return this.canResume();
    }

    public void jumpToAddress(long address) throws DebugException {
        if (!this.canJumpToAddress(address)) {
            return;
        }
        this.setBreakpoints();
        ICDILocation location = this.getCDISession().getBreakpointManager().createLocation(address);
        try {
            this.getCDITarget().jump(location);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

