/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CValue;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public abstract class CModificationVariable
extends CVariable {
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$model$CDebugTarget;

    public CModificationVariable(CDebugElement parent, ICDIVariable cdiVariable) {
        super(parent, cdiVariable);
    }

    public boolean supportsValueModification() {
        CDebugTarget target = (CDebugTarget)this.getDebugTarget().getAdapter(class$org$eclipse$cdt$debug$internal$core$model$CDebugTarget == null ? (class$org$eclipse$cdt$debug$internal$core$model$CDebugTarget = CModificationVariable.class$("org.eclipse.cdt.debug.internal.core.model.CDebugTarget")) : class$org$eclipse$cdt$debug$internal$core$model$CDebugTarget);
        if (target == null || target.isCoreDumpTarget()) {
            return false;
        }
        try {
            IValue value = this.getValue();
            if (value != null && value instanceof ICValue) {
                switch (((ICValue)value).getType()) {
                    case 4: {
                        return true;
                    }
                }
                return !value.hasVariables();
            }
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return false;
    }

    public boolean verifyValue(String expression) {
        return true;
    }

    public boolean verifyValue(IValue value) {
        return value.getDebugTarget().equals(this.getDebugTarget());
    }

    public final void setValue(String expression) throws DebugException {
        String newExpression = this.processExpression(expression);
        ICDIVariable cdiVariable = this.getCDIVariable();
        if (cdiVariable == null) {
            this.logError("Error in IValueModification#setValue: no cdi variable.");
            this.requestFailed("Unable to set value.", null);
            return;
        }
        try {
            cdiVariable.setValue(newExpression);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected void setValue(ICDIValue value) throws DebugException {
        ICDIVariable cdiVariable = this.getCDIVariable();
        if (cdiVariable == null) {
            this.logError("Error in IValueModification#setValue: no cdi variable.");
            this.requestFailed("Unable to set value.", null);
            return;
        }
        try {
            cdiVariable.setValue(value);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    private String processExpression(String oldExpression) throws DebugException {
        CValue value = (CValue)this.getValue();
        if (value == null) {
            this.logError("Error in IValueModification#setValue: no value.");
            this.requestFailed("Unable to set value.", null);
            return null;
        }
        if (value.getType() == 8 && this.getFormat() == 0) {
            char[] chars = oldExpression.toCharArray();
            if (chars.length != 1) {
                this.requestFailed(MessageFormat.format("Invalid value: ''{0}''.", oldExpression), null);
                return null;
            }
            return Short.toString((short)chars[0]);
        }
        return oldExpression;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

