/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterObject;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegister;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;

public class CRegisterGroup
extends CDebugElement
implements IRegisterGroup {
    private String fName;
    private ICDIRegisterObject[] fRegisterObjects;
    private List fRegisters;

    public CRegisterGroup(CDebugTarget target, String name, ICDIRegisterObject[] regObjects) {
        super(target);
        this.fName = name;
        this.fRegisterObjects = regObjects;
        this.fRegisters = new ArrayList();
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public IRegister[] getRegisters() throws DebugException {
        List list = this.getRegisters0();
        return list.toArray(new IRegister[list.size()]);
    }

    public boolean hasRegisters() throws DebugException {
        return this.fRegisterObjects.length > 0;
    }

    private List getRegisters0() throws DebugException {
        if (this.fRegisters == null || this.fRegisters.size() == 0) {
            ICDIRegister[] regs = this.getCDIRegisters();
            this.fRegisters = new ArrayList(regs.length);
            int i = 0;
            while (i < regs.length) {
                this.fRegisters.add(new CRegister(this, regs[i]));
                ++i;
            }
        }
        return this.fRegisters;
    }

    protected void dispose() {
        Iterator it = this.fRegisters.iterator();
        while (it.hasNext()) {
            ((CRegister)it.next()).dispose();
        }
        this.fRegisters.clear();
    }

    private ICDIRegister[] getCDIRegisters() throws DebugException {
        ICDIRegister[] results = new ICDIRegister[this.fRegisterObjects.length];
        try {
            int i = 0;
            while (i < this.fRegisterObjects.length) {
                results[i] = ((CDebugTarget)this.getDebugTarget()).getCDISession().getRegisterManager().createRegister(this.fRegisterObjects[i]);
                ++i;
            }
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
        return results;
    }

    protected void resetChangeFlags() {
        if (this.fRegisters == null) {
            return;
        }
        try {
            Iterator it = this.fRegisters.iterator();
            while (it.hasNext()) {
                ((CVariable)it.next()).setChanged(false);
            }
        }
        catch (DebugException e) {
            CDebugCorePlugin.log(e);
        }
    }
}

