/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.CDebugUtils;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CProjectSourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CSourceLocator
implements ICSourceLocator,
IPersistableSourceLocator {
    private static final String ELEMENT_NAME = "cSourceLocator";
    private static final String CHILD_NAME = "cSourceLocation";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MEMENTO = "memento";
    private ICSourceLocation[] fSourceLocations;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$model$IStackFrameInfo;

    public CSourceLocator() {
        this.setSourceLocations(new ICSourceLocation[0]);
    }

    public CSourceLocator(IProject project) {
        this.fSourceLocations = CSourceLocator.getDefaultSourceLocations(project);
    }

    public CSourceLocator(ICSourceLocation[] locations) {
        this.fSourceLocations = locations;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        if (stackFrame != null && stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$model$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$model$IStackFrameInfo = CSourceLocator.class$("org.eclipse.cdt.debug.core.model.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$model$IStackFrameInfo) != null) {
            return this.getInput((IStackFrameInfo)stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$model$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$model$IStackFrameInfo = CSourceLocator.class$("org.eclipse.cdt.debug.core.model.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$model$IStackFrameInfo));
        }
        return null;
    }

    public int getLineNumber(IStackFrame frame) {
        IStackFrameInfo info = (IStackFrameInfo)frame.getAdapter(class$org$eclipse$cdt$debug$core$model$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$model$IStackFrameInfo = CSourceLocator.class$("org.eclipse.cdt.debug.core.model.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$model$IStackFrameInfo);
        return info != null ? info.getFrameLineNumber() : 0;
    }

    protected Object getInput(IStackFrameInfo info) {
        String fileName;
        Object result = null;
        if (info != null && (fileName = info.getFile()) != null && fileName.length() > 0 && (result = this.findFileByAbsolutePath(fileName)) == null) {
            ICSourceLocation[] locations = this.getSourceLocations();
            int i = 0;
            while (i < locations.length) {
                try {
                    result = locations[i].findSourceElement(fileName);
                }
                catch (CoreException e) {
                    // empty catch block
                }
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public boolean contains(IResource resource) {
        ICSourceLocation[] locations = this.getSourceLocations();
        int i = 0;
        while (i < locations.length) {
            if (resource instanceof IProject && locations[i] instanceof CProjectSourceLocation && ((CProjectSourceLocation)locations[i]).getProject().equals((Object)resource)) {
                return true;
            }
            if (resource instanceof IFile) {
                try {
                    if (locations[i].findSourceElement(resource.getLocation().toOSString()) != null) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return false;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.fSourceLocations;
    }

    public void setSourceLocations(ICSourceLocation[] locations) {
        this.fSourceLocations = locations;
    }

    public static ICSourceLocation[] getDefaultSourceLocations(IProject project) {
        ArrayList<CProjectSourceLocation> list = new ArrayList<CProjectSourceLocation>();
        if (project != null && project.exists()) {
            list.add(new CProjectSourceLocation(project));
            CSourceLocator.addReferencedSourceLocations(list, project);
        }
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    private static void addReferencedSourceLocations(List list, IProject project) {
        if (project != null) {
            try {
                IProject[] projects = project.getReferencedProjects();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i].exists()) {
                        list.add(new CProjectSourceLocation(projects[i]));
                        CSourceLocator.addReferencedSourceLocations(list, projects[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private Object findFileByAbsolutePath(String fileName) {
        Path path = new Path(fileName);
        if (path.isAbsolute() && path.toFile().exists()) {
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (f != null) {
                return f;
            }
            return new FileStorage((IPath)path);
        }
        return null;
    }

    public Object findSourceElement(String fileName) {
        Object result = null;
        if (fileName != null && fileName.length() > 0 && (result = this.findFileByAbsolutePath(fileName)) == null) {
            ICSourceLocation[] locations = this.getSourceLocations();
            int i = 0;
            while (i < locations.length) {
                try {
                    result = locations[i].findSourceElement(fileName);
                }
                catch (CoreException e) {
                    // empty catch block
                }
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public String getMemento() throws CoreException {
        DocumentImpl doc = new DocumentImpl();
        Element node = doc.createElement(ELEMENT_NAME);
        doc.appendChild(node);
        ICSourceLocation[] locations = this.getSourceLocations();
        int i = 0;
        while (i < locations.length) {
            Element child = doc.createElement(CHILD_NAME);
            child.setAttribute(ATTR_CLASS, locations[i].getClass().getName());
            child.setAttribute(ATTR_MEMENTO, locations[i].getMemento());
            node.appendChild(child);
            ++i;
        }
        try {
            return CDebugUtils.serializeDocument((Document)doc, " ");
        }
        catch (IOException e) {
            this.abort("Unable to create memento for C/C++ source locator.", e);
            return null;
        }
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        IProject project = this.getProject(configuration);
        if (project != null) {
            this.setSourceLocations(CSourceLocator.getDefaultSourceLocations(project));
        } else {
            this.setSourceLocations(new ICSourceLocation[0]);
        }
    }

    public void initializeFromMemento(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            if (!root.getNodeName().equalsIgnoreCase(ELEMENT_NAME)) {
                this.abort("Unable to restore C/C++ source locator - invalid format.", null);
            }
            ArrayList<ICSourceLocation> sourceLocations = new ArrayList<ICSourceLocation>();
            ClassLoader classLoader = CDebugCorePlugin.getDefault().getDescriptor().getPluginClassLoader();
            NodeList list = root.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1) {
                    Element entry = (Element)node;
                    if (entry.getNodeName().equalsIgnoreCase(CHILD_NAME)) {
                        String className = entry.getAttribute(ATTR_CLASS);
                        String data = entry.getAttribute(ATTR_MEMENTO);
                        if (this.isEmpty(className)) {
                            this.abort("Unable to restore C/C++ source locator - invalid format.", null);
                        }
                        Class<?> clazz = null;
                        try {
                            clazz = classLoader.loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            this.abort(MessageFormat.format("Unable to restore source location - class not found {0}", className), e);
                        }
                        ICSourceLocation location = null;
                        try {
                            location = (ICSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException e) {
                            this.abort("Unable to restore source location.", e);
                        }
                        catch (InstantiationException e) {
                            this.abort("Unable to restore source location.", e);
                        }
                        location.initializeFrom(data);
                        sourceLocations.add(location);
                    } else {
                        this.abort("Unable to restore C/C++ source locator - invalid format.", null);
                    }
                }
                ++i;
            }
            this.setSourceLocations(sourceLocations.toArray(new ICSourceLocation[sourceLocations.size()]));
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort("Exception occurred initializing source locator.", ex);
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private IProject getProject(ILaunchConfiguration configuration) {
        IProject project = null;
        try {
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (!this.isEmpty(projectName)) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return project;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

