/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.ui.editors.EditorInputDelegate;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.wizards.AddDirectorySourceLocationWizard;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CDebugEditor
extends CEditor {
    public static final String EDITOR_ID = CDebugUIPlugin.getUniqueIdentifier() + ".editor.CDebugEditor";
    private AttachSourceForm fAttachSourceForm = null;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator;

    public CDebugEditor() {
        this.setDocumentProvider((IDocumentProvider)CDebugUIPlugin.getDefault().getDocumentProvider());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IEditorInput newInput = input;
        if (input instanceof EditorInputDelegate && ((EditorInputDelegate)input).getDelegate() != null) {
            newInput = ((EditorInputDelegate)input).getDelegate();
        }
        super.doSetInput(newInput);
    }

    protected void attachSourceLocation() {
        FileNotFoundElement element;
        if (this.getEditorInput() != null && this.getEditorInput().getAdapter(class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement == null ? (class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement = CDebugEditor.class$("org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement")) : class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement) != null && (element = (FileNotFoundElement)this.getEditorInput().getAdapter(class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement == null ? (class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement = CDebugEditor.class$("org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement")) : class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement)).getLaunch() != null && element.getLaunch().getSourceLocator() instanceof IAdaptable) {
            ILaunch launch = element.getLaunch();
            ICSourceLocator locator = (ICSourceLocator)((IAdaptable)element.getLaunch().getSourceLocator()).getAdapter(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator = CDebugEditor.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocator);
            if (locator != null) {
                IPath path = element.getFullPath();
                Wizard wizard = null;
                if (path.isAbsolute()) {
                    path = path.removeLastSegments(1);
                    wizard = new AddDirectorySourceLocationWizard(path);
                } else {
                    wizard = new AddSourceLocationWizard(locator.getSourceLocations());
                }
                WizardDialog dialog = new WizardDialog(CDebugUIPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    ICSourceLocation[] locations = locator.getSourceLocations();
                    ArrayList<ICSourceLocation> list = new ArrayList<ICSourceLocation>(Arrays.asList(locations));
                    list.add(wizard.getSourceLocation());
                    locator.setSourceLocations(list.toArray(new ICSourceLocation[list.size()]));
                    if (locator instanceof IPersistableSourceLocator) {
                        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                        this.saveChanges(configuration, (IPersistableSourceLocator)launch.getSourceLocator());
                    }
                    Object newElement = locator.getSourceElement(element.getStackFrame());
                    FileEditorInput newInput = null;
                    if (newElement instanceof IFile) {
                        newInput = new FileEditorInput((IFile)newElement);
                    } else if (newElement instanceof FileStorage) {
                        newInput = new ExternalEditorInput((IStorage)newElement);
                    }
                    ((EditorInputDelegate)this.getEditorInput()).setDelegate((IEditorInput)newInput);
                    this.resetInput(element.getStackFrame());
                }
            }
        }
    }

    private void resetInput(IStackFrame frame) {
        this.setInput(this.getEditorInput());
        IViewPart view = CDebugUIPlugin.getActivePage().findView("org.eclipse.debug.ui.DebugView");
        if (view instanceof IDebugView) {
            ((IDebugView)view).getViewer().setSelection((ISelection)new StructuredSelection((Object)frame));
        }
    }

    protected void saveChanges(ILaunchConfiguration configuration, IPersistableSourceLocator locator) {
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.copy(configuration.getName());
            copy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, locator.getMemento());
            copy.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), (IStatus)null);
        }
    }

    protected Control createStatusControl(Composite parent, IStatus status) {
        this.fAttachSourceForm = new AttachSourceForm(parent, this.getEditorInput());
        return this.fAttachSourceForm.getControl();
    }

    public void updatePartControl(IEditorInput input) {
        if (this.fAttachSourceForm != null) {
            if (this.fAttachSourceForm.getInput() != null && !this.fAttachSourceForm.getInput().equals(input)) {
                this.fAttachSourceForm = null;
                super.updatePartControl(input);
            }
        } else {
            super.updatePartControl(input);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class AttachSourceForm
    implements IPropertyChangeListener {
        private static final int HORIZONTAL_SCROLL_INCREMENT = 10;
        private static final int VERTICAL_SCROLL_INCREMENT = 10;
        private Font fFont;
        private ScrolledComposite fScrolledComposite;
        private Color fBackgroundColor;
        private Color fForegroundColor;
        private Color fSeparatorColor;
        private List fHeaderLabels = new ArrayList();
        private List fBannerLabels = new ArrayList();
        private Label fInputLabel;
        private Button fAttachButton = null;
        private IPropertyChangeListener fPropertyChangeListener;
        private IEditorInput fInput = null;
        static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement;

        public AttachSourceForm(Composite parent, IEditorInput input) {
            Display display = parent.getDisplay();
            this.fBackgroundColor = display.getSystemColor(25);
            this.fForegroundColor = display.getSystemColor(24);
            this.fSeparatorColor = new Color((Device)display, 152, 170, 203);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            this.fScrolledComposite = new ScrolledComposite(parent, 768);
            this.fScrolledComposite.setAlwaysShowScrollBars(false);
            this.fScrolledComposite.setExpandHorizontal(true);
            this.fScrolledComposite.setExpandVertical(true);
            this.fScrolledComposite.addDisposeListener(new DisposeListener(this){
                private final /* synthetic */ AttachSourceForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.this$1);
                    this.this$1.setScrolledComposite(null);
                    this.this$1.getSeparatorColor().dispose();
                    this.this$1.setSeparatorColor(null);
                    this.this$1.getBannerLabels().clear();
                    this.this$1.getHeaderLabels().clear();
                    if (this.this$1.getFont() != null) {
                        this.this$1.getFont().dispose();
                        this.this$1.setFont(null);
                    }
                }
            });
            this.fScrolledComposite.addControlListener(new ControlListener(this){
                private final /* synthetic */ AttachSourceForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    Rectangle clientArea = this.this$1.getScrolledComposite().getClientArea();
                    ScrollBar verticalBar = this.this$1.getScrolledComposite().getVerticalBar();
                    verticalBar.setIncrement(10);
                    verticalBar.setPageIncrement(clientArea.height - verticalBar.getIncrement());
                    ScrollBar horizontalBar = this.this$1.getScrolledComposite().getHorizontalBar();
                    horizontalBar.setIncrement(10);
                    horizontalBar.setPageIncrement(clientArea.width - horizontalBar.getIncrement());
                }
            });
            Composite composite = this.createComposite((Composite)this.fScrolledComposite);
            composite.setLayout((Layout)new GridLayout());
            this.createTitleLabel(composite, "C/C++ File Editor");
            this.createLabel(composite, null);
            this.createLabel(composite, null);
            this.createHeadingLabel(composite, "Source not found");
            Composite separator = this.createCompositeSeparator(composite);
            GridData data = new GridData(768);
            data.heightHint = 2;
            separator.setLayoutData((Object)data);
            this.fInputLabel = this.createLabel(composite, "");
            this.createLabel(composite, "You can attach a new source location by pressing the button below:");
            this.createLabel(composite, null);
            this.fAttachButton = this.createButton(composite, "&Attach Source...");
            this.fAttachButton.addSelectionListener(new SelectionListener(this){
                private final /* synthetic */ AttachSourceForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    AttachSourceForm.access$000(this.this$1).attachSourceLocation();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            separator = this.createCompositeSeparator(composite);
            data = new GridData(768);
            data.heightHint = 2;
            separator.setLayoutData((Object)data);
            this.fScrolledComposite.setContent((Control)composite);
            this.fScrolledComposite.setMinSize(composite.computeSize(-1, -1));
            if (CDebugEditor.this.getEditorInput() != null) {
                this.setInputLabelText(CDebugEditor.this.getEditorInput());
            }
            this.fInput = input;
        }

        private Composite createComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(this.fBackgroundColor);
            return composite;
        }

        private Label createLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            return label;
        }

        private Label createTitleLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getHeaderFont());
            this.fHeaderLabels.add(label);
            return label;
        }

        private Label createHeadingLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getBannerFont());
            this.fBannerLabels.add(label);
            return label;
        }

        private Composite createCompositeSeparator(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(this.fSeparatorColor);
            return composite;
        }

        private Button createButton(Composite parent, String text) {
            Button button = new Button(parent, 0x800000);
            button.setBackground(this.fBackgroundColor);
            button.setForeground(this.fForegroundColor);
            if (text != null) {
                button.setText(text);
            }
            return button;
        }

        public void propertyChange(PropertyChangeEvent event) {
            Iterator iterator = this.fBannerLabels.iterator();
            while (iterator.hasNext()) {
                Label label = (Label)iterator.next();
                label.setFont(JFaceResources.getBannerFont());
            }
            Iterator iterator2 = this.fHeaderLabels.iterator();
            while (iterator2.hasNext()) {
                Label label = (Label)iterator2.next();
                label.setFont(JFaceResources.getHeaderFont());
            }
            Control control = this.fScrolledComposite.getContent();
            this.fScrolledComposite.setMinSize(control.computeSize(-1, -1));
            this.fScrolledComposite.setContent(control);
            this.fScrolledComposite.layout(true);
            this.fScrolledComposite.redraw();
        }

        private void setInputLabelText(IEditorInput input) {
            FileNotFoundElement element = (FileNotFoundElement)input.getAdapter(class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement == null ? (class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement = AttachSourceForm.class$("org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement")) : class$org$eclipse$cdt$debug$internal$ui$editors$FileNotFoundElement);
            if (element != null) {
                IPath path = element.getFullPath();
                String message = "";
                message = path.isAbsolute() ? MessageFormat.format("The file ''{0}'' does not exist.", element.getFullPath().toOSString()) : MessageFormat.format("The file ''{0}'' not found.", element.getFullPath().toOSString());
                this.fInputLabel.setText(message);
            }
        }

        protected ScrolledComposite getScrolledComposite() {
            return this.fScrolledComposite;
        }

        protected void setScrolledComposite(ScrolledComposite scrolledComposite) {
            this.fScrolledComposite = scrolledComposite;
        }

        protected Color getSeparatorColor() {
            return this.fSeparatorColor;
        }

        protected void setSeparatorColor(Color separatorColor) {
            this.fSeparatorColor = separatorColor;
        }

        protected List getBannerLabels() {
            return this.fBannerLabels;
        }

        protected void setBannerLabels(List bannerLabels) {
            this.fBannerLabels = bannerLabels;
        }

        protected List getHeaderLabels() {
            return this.fHeaderLabels;
        }

        protected void setHeaderLabels(List headerLabels) {
            this.fHeaderLabels = headerLabels;
        }

        protected Font getFont() {
            return this.fFont;
        }

        protected void setFont(Font font) {
            this.fFont = font;
        }

        public Control getControl() {
            return this.fScrolledComposite;
        }

        public IEditorInput getInput() {
            return this.fInput;
        }

        static /* synthetic */ CDebugEditor access$000(AttachSourceForm x0) {
            return x0.CDebugEditor.this;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

