/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgument;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;

public class StackFrame
extends CObject
implements ICDIStackFrame {
    MIFrame frame;
    Thread cthread;

    public StackFrame(Thread thread, MIFrame f) {
        super(thread.getTarget());
        this.cthread = thread;
        this.frame = f;
    }

    MIFrame getMIFrame() {
        return this.frame;
    }

    public ICDIThread getThread() {
        return this.cthread;
    }

    public ICDIArgument[] getArguments() throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = (VariableManager)session.getVariableManager();
        ICDIArgumentObject[] argObjs = mgr.getArgumentObjects(this);
        ICDIArgument[] args = new ICDIArgument[argObjs.length];
        int i = 0;
        while (i < args.length) {
            args[i] = mgr.createArgument(argObjs[i]);
            ++i;
        }
        return args;
    }

    public ICDIVariable[] getLocalVariables() throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = (VariableManager)session.getVariableManager();
        ICDIVariableObject[] varObjs = mgr.getVariableObjects(this);
        ICDIVariable[] vars = new ICDIVariable[varObjs.length];
        int i = 0;
        while (i < vars.length) {
            vars[i] = mgr.createVariable(varObjs[i]);
            ++i;
        }
        return vars;
    }

    public ICDILocation getLocation() {
        if (this.frame != null) {
            return new Location(this.frame.getFile(), this.frame.getFunction(), this.frame.getLine(), this.frame.getAddress());
        }
        return new Location("", "", 0, 0L);
    }

    public int getLevel() {
        if (this.frame != null) {
            return this.frame.getLevel();
        }
        return 0;
    }

    public boolean equals(ICDIStackFrame stackframe) {
        if (stackframe instanceof StackFrame) {
            StackFrame stack = (StackFrame)stackframe;
            return this.cthread != null && this.cthread.equals(stack.getThread()) && this.frame != null && this.frame.getLevel() == stack.getMIFrame().getLevel() && this.frame.getFile().equals(stack.getMIFrame().getFile()) && this.frame.getFunction().equals(stack.getMIFrame().getFunction());
        }
        return super.equals(stackframe);
    }
}

