/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackInfoDepth;
import org.eclipse.cdt.debug.mi.core.command.MIStackListFrames;
import org.eclipse.cdt.debug.mi.core.command.MIStackSelectFrame;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackInfoDepthInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListFramesInfo;

public class Thread
extends CObject
implements ICDIThread {
    static ICDIStackFrame[] noStack = new ICDIStackFrame[0];
    int id;
    ICDIStackFrame currentFrame;
    int stackdepth = 0;

    public Thread(ICDITarget target, int threadId) {
        super(target);
        this.id = threadId;
    }

    int getId() {
        return this.id;
    }

    public void clearState() {
        this.stackdepth = 0;
        this.currentFrame = null;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public ICDIStackFrame getCurrentStackFrame() throws CDIException {
        ICDIStackFrame[] frames;
        if (this.currentFrame == null && (frames = this.getStackFrames(0, 0)).length > 0) {
            this.currentFrame = frames[0];
        }
        return this.currentFrame;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIStackFrame[] getStackFrames() throws CDIException {
        ICDIStackFrame[] stacks;
        block10: {
            stacks = noStack;
            Session session = (Session)this.getTarget().getSession();
            Target currentTarget = (Target)session.getCurrentTarget();
            ICDIThread currentThread = currentTarget.getCurrentThread();
            currentTarget.setCurrentThread(this, false);
            try {
                Object var12_14;
                try {
                    MISession mi = session.getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    MIStackListFrames frames = factory.createMIStackListFrames();
                    mi.postCommand(frames);
                    MIStackListFramesInfo info = frames.getMIStackListFramesInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    MIFrame[] miFrames = info.getMIFrames();
                    stacks = new StackFrame[miFrames.length];
                    int i = 0;
                    while (i < stacks.length) {
                        stacks[i] = new StackFrame(this, miFrames[i]);
                        ++i;
                    }
                }
                catch (MIException e) {
                    var12_14 = null;
                    currentTarget.setCurrentThread(currentThread, false);
                    break block10;
                }
                catch (CDIException e) {
                    var12_14 = null;
                    currentTarget.setCurrentThread(currentThread, false);
                    break block10;
                }
                var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                currentTarget.setCurrentThread(currentThread, false);
                throw throwable;
            }
            currentTarget.setCurrentThread(currentThread, false);
        }
        if (this.currentFrame == null) {
            int i = 0;
            while (i < stacks.length) {
                if (stacks[i].getLevel() == 0) {
                    this.currentFrame = stacks[i];
                }
                ++i;
            }
        }
        return stacks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getStackFrameCount() throws CDIException {
        if (this.stackdepth != 0) return this.stackdepth;
        Session session = (Session)this.getTarget().getSession();
        Target currentTarget = (Target)session.getCurrentTarget();
        ICDIThread currentThread = currentTarget.getCurrentThread();
        currentTarget.setCurrentThread(this, false);
        try {
            try {
                MISession mi = session.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIStackInfoDepth depth = factory.createMIStackInfoDepth();
                mi.postCommand(depth);
                MIStackInfoDepthInfo info = depth.getMIStackInfoDepthInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                this.stackdepth = info.getDepth();
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            currentTarget.setCurrentThread(currentThread, false);
            throw throwable;
        }
        currentTarget.setCurrentThread(currentThread, false);
        return this.stackdepth;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIStackFrame[] getStackFrames(int low, int high) throws CDIException {
        ICDIStackFrame[] stacks;
        block10: {
            stacks = noStack;
            Session session = (Session)this.getTarget().getSession();
            Target currentTarget = (Target)session.getCurrentTarget();
            ICDIThread currentThread = currentTarget.getCurrentThread();
            currentTarget.setCurrentThread(this, false);
            try {
                Object var14_16;
                try {
                    MISession mi = session.getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    MIStackListFrames frames = factory.createMIStackListFrames(low, high);
                    mi.postCommand(frames);
                    MIStackListFramesInfo info = frames.getMIStackListFramesInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    MIFrame[] miFrames = info.getMIFrames();
                    stacks = new StackFrame[miFrames.length];
                    int i = 0;
                    while (i < stacks.length) {
                        stacks[i] = new StackFrame(this, miFrames[i]);
                        ++i;
                    }
                }
                catch (MIException e) {
                    var14_16 = null;
                    currentTarget.setCurrentThread(currentThread, false);
                    break block10;
                }
                catch (CDIException e) {
                    var14_16 = null;
                    currentTarget.setCurrentThread(currentThread, false);
                    break block10;
                }
                var14_16 = null;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                currentTarget.setCurrentThread(currentThread, false);
                throw throwable;
            }
            currentTarget.setCurrentThread(currentThread, false);
        }
        if (this.currentFrame == null) {
            int i = 0;
            while (i < stacks.length) {
                if (stacks[i].getLevel() == 0) {
                    this.currentFrame = stacks[i];
                }
                ++i;
            }
        }
        return stacks;
    }

    public void setCurrentStackFrame(ICDIStackFrame stackframe) throws CDIException {
        this.setCurrentStackFrame(stackframe, true);
    }

    public void setCurrentStackFrame(ICDIStackFrame stackframe, boolean doUpdate) throws CDIException {
        ICDIStackFrame current;
        int frameNum = 0;
        if (stackframe != null) {
            frameNum = stackframe.getLevel();
        }
        if ((current = this.getCurrentStackFrame()) != null && current.getLevel() == frameNum) {
            return;
        }
        try {
            Session session = (Session)this.getTarget().getSession();
            MISession mi = session.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIStackSelectFrame frame = factory.createMIStackSelectFrame(frameNum);
            ((Target)this.getTarget()).setCurrentThread(this, doUpdate);
            mi.postCommand(frame);
            MIInfo info = frame.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            this.currentFrame = stackframe;
            if (doUpdate) {
                RegisterManager regMgr = (RegisterManager)session.getRegisterManager();
                regMgr.update();
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean isSuspended() {
        return this.getTarget().isSuspended();
    }

    public void resume() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().resume();
    }

    public void stepInto() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepInto();
    }

    public void stepIntoInstruction() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepIntoInstruction();
    }

    public void stepOver() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepOver();
    }

    public void stepOverInstruction() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepOverInstruction();
    }

    public void stepReturn() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepReturn();
    }

    public void stepReturn(boolean execute) throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().stepReturn(execute);
    }

    public void runUntil(ICDILocation location) throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().runUntil(location);
    }

    public void suspend() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().suspend();
    }

    public void jump(ICDILocation location) throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().jump(location);
    }

    public void signal() throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().signal();
    }

    public void signal(ICDISignal signal) throws CDIException {
        this.getTarget().setCurrentThread((ICDIThread)this);
        this.getTarget().signal(signal);
    }

    public boolean equals(ICDIThread thread) {
        if (thread instanceof Thread) {
            Thread cthread = (Thread)thread;
            return this.id == cthread.getId();
        }
        return super.equals(thread);
    }
}

