/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusTool;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.internal.ui.wizards.swt.MGridLayout;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CLaunchingPropertyPage
extends PropertyPage {
    private static final String PAGE_NAME = "CLaunchingPropertyPage";
    private static final String ARGUMENTS = "CLaunchingPropertyPage.arguments";
    private static final String WORKINGDIR = "CLaunchingPropertyPage.workingdir";
    private static final String NO_CPROJECT = "CLaunchingPropertyPage.nocproject.label";
    private static final String ERROR_WORKINGDIR_NOTEXISTS = "CLaunchingPropertyPage.error.WorkingDirNotExists";
    private StringDialogField fArgumentField;
    protected StringButtonDialogField fWorkingDirField;
    private StatusInfo fWorkingDirStatus;
    private QualifiedName fArgumentsPropertyName;
    private QualifiedName fWorkingDirPropertyName;
    private Shell fShell;

    public CLaunchingPropertyPage() {
        LaunchingDialogFieldsAdapter adapter = new LaunchingDialogFieldsAdapter();
        this.fArgumentField = new StringDialogField();
        this.fArgumentField.setLabelText(CUIPlugin.getResourceString("CLaunchingPropertyPage.arguments.label"));
        this.fArgumentField.setDialogFieldListener(adapter);
        this.fWorkingDirField = new StringButtonDialogField(adapter);
        this.fWorkingDirField.setLabelText(CUIPlugin.getResourceString("CLaunchingPropertyPage.workingdir.label"));
        this.fWorkingDirField.setButtonLabel(CUIPlugin.getResourceString("CLaunchingPropertyPage.workingdir.browse"));
        this.fWorkingDirField.setDialogFieldListener(adapter);
        this.fWorkingDirStatus = new StatusInfo();
        this.fArgumentsPropertyName = new QualifiedName("org.eclipse.cdt.ui", "arguments");
        this.fWorkingDirPropertyName = new QualifiedName("org.eclipse.cdt.ui", "workingdir");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.fShell = parent.getShell();
        MGridLayout layout = new MGridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.minimumWidth = 400;
        layout.minimumHeight = 350;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        boolean isCProject = false;
        try {
            IFile file = this.getInputFile();
            isCProject = file.getProject().hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        if (isCProject) {
            this.fArgumentField.doFillIntoGrid(composite, 3);
            this.fWorkingDirField.doFillIntoGrid(composite, 3);
            this.initialize();
        } else {
            DialogField labelField = new DialogField();
            labelField.setLabelText(CUIPlugin.getResourceString(NO_CPROJECT));
            labelField.doFillIntoGrid(composite, 3);
        }
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.cdt.ui.new_launch_property_page_context");
        return composite;
    }

    private void initialize() {
        IFile file = this.getInputFile();
        if (file != null) {
            try {
                String workingdir;
                String arguments = file.getPersistentProperty(this.fArgumentsPropertyName);
                if (arguments != null) {
                    this.fArgumentField.setText(arguments);
                }
                if ((workingdir = file.getPersistentProperty(this.fWorkingDirPropertyName)) != null) {
                    this.fWorkingDirField.setText(workingdir);
                } else {
                    this.fWorkingDirField.setText(file.getParent().getLocation().toOSString());
                }
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e.getStatus());
            }
        }
    }

    public boolean performOk() {
        IFile file = this.getInputFile();
        if (file != null) {
            try {
                file.setPersistentProperty(this.fArgumentsPropertyName, this.fArgumentField.getText());
                file.setPersistentProperty(this.fWorkingDirPropertyName, this.fWorkingDirField.getText());
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.fShell, (String)"Error", null, (IStatus)e.getStatus());
                CUIPlugin.getDefault().log(e.getStatus());
                return false;
            }
        }
        return true;
    }

    protected void performDefaults() {
        this.initialize();
        super.performDefaults();
    }

    protected void doFieldChanged(DialogField field) {
        if (field == this.fWorkingDirField) {
            this.updateWorkingDirStatus();
        }
        this.projectStatusChanged(this.fWorkingDirStatus);
    }

    private void updateWorkingDirStatus() {
        Path path;
        String str = this.fWorkingDirField.getText();
        if (!"".equals(str) && !(path = new Path(str)).toFile().isDirectory()) {
            this.fWorkingDirStatus.setError(CUIPlugin.getResourceString(ERROR_WORKINGDIR_NOTEXISTS));
            return;
        }
        this.fWorkingDirStatus.setOK();
    }

    private IFile getInputFile() {
        return (IFile)this.getElement();
    }

    protected String chooseFolder(String initPath) {
        DirectoryDialog dialog = new DirectoryDialog(this.fShell, 0);
        dialog.setFilterPath(initPath);
        String res = dialog.open();
        return res;
    }

    public void projectStatusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusTool.applyToStatusLine((DialogPage)this, status);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fShell != null) {
            this.fArgumentField.postSetFocusOnDialogField(this.fShell.getDisplay());
        }
    }

    private class LaunchingDialogFieldsAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private LaunchingDialogFieldsAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            String oldValue = CLaunchingPropertyPage.this.fWorkingDirField.getText();
            String newValue = CLaunchingPropertyPage.this.chooseFolder(oldValue);
            if (newValue != null) {
                CLaunchingPropertyPage.this.fWorkingDirField.setText(newValue);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            CLaunchingPropertyPage.this.doFieldChanged(field);
        }
    }
}

