/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.text.HTMLPrinter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class CAnnotationHover
implements IAnnotationHover {
    protected int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                if (line == markerLine) {
                    return 1;
                }
                if (markerLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                    return 2;
                }
            }
            catch (BadLocationException x) {
                // empty catch block
            }
        }
        return 0;
    }

    protected List select(List exactMatch, List including) {
        return exactMatch;
    }

    protected List getMarkersForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<IMarker> exact = new ArrayList<IMarker>();
        ArrayList<IMarker> including = new ArrayList<IMarker>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!(o instanceof MarkerAnnotation)) continue;
            MarkerAnnotation a = (MarkerAnnotation)o;
            switch (this.compareRulerLine(model.getPosition((Annotation)a), document, line)) {
                case 1: {
                    exact.add(a.getMarker());
                    break;
                }
                case 2: {
                    including.add(a.getMarker());
                }
            }
        }
        return this.select(exact, including);
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List markers = this.getMarkersForLine(sourceViewer, lineNumber);
        if (markers != null) {
            if (markers.size() == 1) {
                IMarker marker = (IMarker)markers.get(0);
                String message = marker.getAttribute("message", (String)null);
                if (message != null && message.trim().length() > 0) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                Iterator e = markers.iterator();
                while (e.hasNext()) {
                    IMarker marker = (IMarker)e.next();
                    String message = marker.getAttribute("message", (String)null);
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    private int getHoverWidth(Display display) {
        Rectangle displayBounds = display.getBounds();
        int hoverWidth = displayBounds.width - (display.getCursorLocation().x - displayBounds.x);
        if ((hoverWidth -= 12) < 200) {
            hoverWidth = 200;
        }
        return hoverWidth;
    }

    private String formatSingleMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private String formatMultipleMessages(List messages) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent("Multiple markers at this line"));
        HTMLPrinter.startBulletList(buffer);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            HTMLPrinter.addBullet(buffer, HTMLPrinter.convertToHTMLContent((String)e.next()));
        }
        HTMLPrinter.endBulletList(buffer);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }
}

