/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.internal.errorparsers.GASErrorParser;
import org.eclipse.cdt.internal.errorparsers.GCCErrorParser;
import org.eclipse.cdt.internal.errorparsers.GLDErrorParser;
import org.eclipse.cdt.internal.errorparsers.MakeErrorParser;
import org.eclipse.cdt.internal.errorparsers.VCErrorParser;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ErrorParserManager
extends OutputStream {
    private int nOpens;
    private static String PREF_ERROR_PARSER = "errorOutputParser";
    private IProject fProject;
    private IMarkerGenerator fMarkerGenerator;
    private Map fFilesInProject;
    private List fNameConflicts;
    private ArrayList fErrorParsers;
    private ArrayList fErrors;
    private Vector fDirectoryStack;
    private IPath fBaseDirectory;
    private String previousLine;
    private OutputStream outputStream;
    private StringBuffer currentLine = new StringBuffer();

    public ErrorParserManager(ACBuilder builder) {
        this(builder.getProject(), builder);
    }

    public ErrorParserManager(IProject project, IMarkerGenerator markerGenerator) {
        this.fProject = project;
        this.fErrorParsers = new ArrayList();
        this.fMarkerGenerator = markerGenerator;
        this.readPreferences();
        this.initParser();
    }

    private void initParser() {
        this.fFilesInProject = new HashMap();
        this.fNameConflicts = new ArrayList();
        this.fDirectoryStack = new Vector();
        this.fErrors = new ArrayList();
        this.fFilesInProject.clear();
        this.fNameConflicts.clear();
        ArrayList collectedFiles = new ArrayList();
        this.fBaseDirectory = this.fProject.getLocation();
        this.collectFiles((IContainer)this.fProject, collectedFiles);
        int i = 0;
        while (i < collectedFiles.size()) {
            IFile curr = (IFile)collectedFiles.get(i);
            IFile existing = this.fFilesInProject.put(curr.getName(), curr);
            if (existing != null) {
                this.fNameConflicts.add(curr.getName());
            }
            ++i;
        }
    }

    public IPath getWorkingDirectory() {
        if (this.fDirectoryStack.size() != 0) {
            return (IPath)this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectory;
    }

    public void pushDirectory(IPath dir) {
        if (dir != null) {
            IPath pwd = null;
            if (this.fBaseDirectory.isPrefixOf(dir)) {
                int segments = this.fBaseDirectory.matchingFirstSegments(dir);
                pwd = dir.removeFirstSegments(segments);
            } else {
                pwd = dir;
            }
            this.fDirectoryStack.addElement(pwd);
        }
    }

    public IPath popDirectory() {
        int i = this.fDirectoryStack.size();
        if (i != 0) {
            IPath dir = (IPath)this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(i - 1);
            return dir;
        }
        return new Path("");
    }

    public int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    protected void addParser(IErrorParser parser) {
        this.fErrorParsers.add(parser);
    }

    private void readPreferences() {
        this.fErrorParsers.clear();
        String parserNames = CCorePlugin.getDefault().getPluginPreferences().getString(PREF_ERROR_PARSER);
        if (parserNames != null && parserNames.length() > 0) {
            StringTokenizer tok = new StringTokenizer(parserNames, ";");
            while (tok.hasMoreElements()) {
                String clName = tok.nextToken();
                try {
                    IErrorParser parser = (IErrorParser)Class.forName(clName).newInstance();
                    this.fErrorParsers.add(parser);
                }
                catch (ClassNotFoundException e) {
                    CCorePlugin.log(e);
                }
                catch (InstantiationException e) {
                    CCorePlugin.log(e);
                }
                catch (IllegalAccessException e) {
                    CCorePlugin.log(e);
                }
                catch (ClassCastException e) {
                    CCorePlugin.log(e);
                }
            }
        }
        if (this.fErrorParsers.size() == 0) {
            this.initErrorParsersArray(this.fErrorParsers);
        }
        this.savePreferences();
    }

    private void initErrorParsersArray(List errorParsers) {
        errorParsers.add(new VCErrorParser());
        errorParsers.add(new GCCErrorParser());
        errorParsers.add(new GLDErrorParser());
        errorParsers.add(new GASErrorParser());
        errorParsers.add(new MakeErrorParser());
    }

    private void savePreferences() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.fErrorParsers.size()) {
            buf.append(this.fErrorParsers.get(i).getClass().getName());
            buf.append(';');
            ++i;
        }
        CCorePlugin.getDefault().getPluginPreferences().setValue(PREF_ERROR_PARSER, buf.toString());
    }

    protected void collectFiles(IContainer parent, List result) {
        try {
            IResource[] resources = parent.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    result.add(resource);
                } else if (resource instanceof IContainer) {
                    this.collectFiles((IContainer)resource, result);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    private void processLine(String line) {
        int top;
        int i = top = this.fErrorParsers.size() - 1;
        do {
            IErrorParser curr;
            if (!(curr = (IErrorParser)this.fErrorParsers.get(i)).processLine(line, this)) continue;
            if (i != top) {
                Object used = this.fErrorParsers.remove(i);
                this.fErrorParsers.add(used);
                this.savePreferences();
            }
            return;
        } while (--i >= 0);
    }

    public IFile findFileName(String fileName) {
        Path path = new Path(fileName);
        return (IFile)this.fFilesInProject.get(path.lastSegment());
    }

    public boolean isConflictingName(String fileName) {
        Path path = new Path(fileName);
        return this.fNameConflicts.contains(path.lastSegment());
    }

    public IFile findFilePath(String filePath) {
        IPath path = null;
        Path fp = new Path(filePath);
        if (fp.isAbsolute()) {
            if (this.fBaseDirectory.isPrefixOf((IPath)fp)) {
                int segments = this.fBaseDirectory.matchingFirstSegments((IPath)fp);
                path = fp.removeFirstSegments(segments);
            } else {
                path = fp;
            }
        } else {
            path = this.getWorkingDirectory().append(filePath);
        }
        IFile file = null;
        try {
            file = path.isAbsolute() ? this.fProject.getWorkspace().getRoot().getFileForLocation(path) : this.fProject.getFile(path);
        }
        catch (Exception e) {
            // empty catch block
        }
        return file != null && file.exists() ? file : null;
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName) {
        Problem problem = new Problem(file, lineNumber, desc, severity, varName);
        this.fErrors.add(problem);
    }

    public String getPreviousLine() {
        return new String(this.previousLine == null ? "" : this.previousLine);
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public OutputStream getOutputStream() {
        ++this.nOpens;
        return this;
    }

    public void close() throws IOException {
        if (this.nOpens > 0 && --this.nOpens == 0) {
            this.fDirectoryStack.removeAllElements();
            this.fBaseDirectory = null;
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            this.checkLine(true);
        }
    }

    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public synchronized void write(int b) throws IOException {
        this.currentLine.append((char)b);
        this.checkLine(false);
        if (this.outputStream != null) {
            this.outputStream.write(b);
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.currentLine.append(new String(b, 0, len));
        this.checkLine(false);
        if (this.outputStream != null) {
            this.outputStream.write(b, off, len);
        }
    }

    private void checkLine(boolean flush) {
        String buffer = this.currentLine.toString();
        int i = 0;
        while ((i = buffer.indexOf(10)) != -1) {
            String line = buffer.substring(0, i).trim();
            this.processLine(line);
            this.previousLine = line;
            buffer = buffer.substring(i + 1);
        }
        this.currentLine.setLength(0);
        if (flush) {
            if (buffer.length() > 0) {
                this.processLine(buffer);
                this.previousLine = buffer;
            }
        } else {
            this.currentLine.append(buffer);
        }
    }

    public boolean reportProblems() {
        boolean reset = false;
        if (this.nOpens == 0) {
            Iterator iter = ((AbstractList)this.fErrors).iterator();
            while (iter.hasNext()) {
                Problem problem = (Problem)iter.next();
                if (problem.severity == 3) {
                    reset = true;
                }
                if (problem.file == null) {
                    this.fMarkerGenerator.addMarker((IResource)this.fProject, problem.lineNumber, problem.description, problem.severity, problem.variableName);
                    continue;
                }
                this.fMarkerGenerator.addMarker(problem.file, problem.lineNumber, problem.description, problem.severity, problem.variableName);
            }
            this.fErrors.clear();
        }
        return reset;
    }

    protected class Problem {
        protected IResource file;
        protected int lineNumber;
        protected String description;
        protected int severity;
        protected String variableName;

        public Problem(IResource file, int lineNumber, String desciption, int severity, String variableName) {
            this.file = file;
            this.lineNumber = lineNumber;
            this.description = desciption;
            this.severity = severity;
            this.variableName = variableName;
        }
    }
}

