/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder.model;

import org.eclipse.cdt.core.builder.model.ICBuildVariable;
import org.eclipse.cdt.core.builder.model.ICBuildVariableResolver;

public class CBuildVariable
implements ICBuildVariable {
    private String fFixed;
    private String fVariable;
    private ICBuildVariableResolver fResolver;

    public CBuildVariable(String name, String fixed, String resolved) {
        this(name, fixed, new StringResolver(resolved));
    }

    public CBuildVariable(String name, String fixed, ICBuildVariableResolver resolver) {
        this.fVariable = name;
        this.fFixed = fixed;
        this.fResolver = resolver;
    }

    public CBuildVariable(String name, ICBuildVariable base) {
        this.fVariable = name;
        this.fFixed = base.getFixed();
        this.fResolver = base.getResolver();
    }

    public String getVariable() {
        return this.fVariable;
    }

    public String getFixed() {
        return this.fFixed;
    }

    public ICBuildVariableResolver getResolver() {
        return this.fResolver;
    }

    public String getValue() {
        return this.fResolver.resolveValue(this);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.fVariable.hashCode();
        result = result * 37 + this.fFixed.hashCode();
        return result;
    }

    public String toString() {
        return "[" + this.fVariable + "]" + this.fFixed;
    }

    private static class StringResolver
    implements ICBuildVariableResolver {
        private String fValue;

        public StringResolver(String value) {
            this.fValue = value;
        }

        public String resolveValue(ICBuildVariable var) {
            return this.fValue + var.getFixed();
        }
    }
}

