/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.builder.util.IFilesystem;
import org.eclipse.cdt.internal.core.ProcessClosure;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class CCygwinFilesystem
implements IFilesystem {
    private static String CONVERT_CMD = "cygpath";
    private static String CONVERT_TO_UNIX = "-u";
    private static String CONVERT_TO_NATIVE = "-w";
    private String fHome = this.getNativePath("/") + "/";

    private String convertPath(String path, String cmdFlags) {
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        String[] cmds = new String[]{CONVERT_CMD, cmdFlags, path};
        String newPath = path;
        try {
            ProcessFactory pf = ProcessFactory.getFactory();
            Process pid = pf.exec(cmds);
            ProcessClosure pc = new ProcessClosure(pid, stdout, stderr);
            pc.runBlocking();
            newPath = stdout.toString().trim();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newPath.replace('\\', '\\');
    }

    public String getRoot() {
        return this.fHome;
    }

    public String getNativePath(String path) {
        return this.convertPath(path, CONVERT_TO_NATIVE);
    }

    public String getNativePath(File path) {
        return this.getNativePath(path.toString());
    }

    public String getUnixPath(String path) {
        path = this.convertPath(path, CONVERT_TO_UNIX);
        String subString = new String("");
        int len = 0;
        int begin = 0;
        while ((len = path.indexOf(" ")) >= 0) {
            subString = subString + path.substring(begin, len);
            subString = subString + "\\ ";
            path = path.substring(len + 1);
        }
        subString = subString + path;
        return subString;
    }

    public String getUnixPath(File path) {
        return this.getUnixPath(path.toString());
    }
}

