/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.eclipse.cdt.core.builder.util.CCygwinFilesystem;
import org.eclipse.cdt.core.builder.util.CUnixFilesystem;
import org.eclipse.cdt.core.builder.util.IFilesystem;
import org.eclipse.core.internal.runtime.Assert;

public class Filesystem {
    private static IFilesystem fInstance = File.separatorChar == "/".charAt(0) ? new CUnixFilesystem() : new CCygwinFilesystem();

    private static IFilesystem getInstance() {
        if (fInstance == null) {
            throw new FileSystemException("Problems encountered while searching for your file system.");
        }
        return fInstance;
    }

    public static boolean isValid() {
        return fInstance != null;
    }

    private Filesystem() {
    }

    public static String getRoot() {
        return Filesystem.getInstance().getRoot();
    }

    public static String getNativePath(String path) {
        return Filesystem.getInstance().getNativePath(path);
    }

    public static String getNativePath(File path) {
        return Filesystem.getInstance().getNativePath(path);
    }

    public static String getUnixPath(String path) {
        return Filesystem.getInstance().getUnixPath(path);
    }

    public static String getUnixPath(File path) {
        return Filesystem.getInstance().getUnixPath(path);
    }

    public static boolean copyFile(File sourceFile, File destFile, boolean replaceIfExists) {
        Assert.isNotNull((Object)sourceFile);
        Assert.isNotNull((Object)destFile);
        if (!sourceFile.exists()) {
            return false;
        }
        if (sourceFile.equals(destFile)) {
            return false;
        }
        if (replaceIfExists && destFile.exists()) {
            destFile.delete();
        }
        if (destFile.exists()) {
            return false;
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        byte[] buf = new byte[1024];
        int i = 0;
        try {
            fis = new FileInputStream(sourceFile);
            fos = new FileOutputStream(destFile);
            while (-1 != (i = fis.read(buf))) {
                fos.write(buf, 0, i);
            }
            fos.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (destFile.exists()) {
                destFile.delete();
            }
            return false;
        }
        return true;
    }

    public static class FileSystemException
    extends Error {
        FileSystemException(String s) {
            super(s);
        }
    }
}

