/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICFile;
import org.eclipse.cdt.internal.core.model.BinaryRunner;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ArchiveContainer
extends Parent
implements IArchiveContainer {
    CProject cProject;

    public ArchiveContainer(CProject cProject) {
        super(cProject, null, "lib", 30);
        this.cProject = cProject;
        IProject project = cProject.getProject();
        IFolder folder = project.getFolder("Virtual.lib");
        this.setUnderlyingResource((IResource)folder);
    }

    public IArchive[] getArchives() {
        ICElement[] e = this.getChildren(true);
        IArchive[] a = new IArchive[e.length];
        System.arraycopy(e, 0, a, 0, e.length);
        return a;
    }

    public boolean hasChildren() {
        return this.getChildren(true).length > 0;
    }

    public ICElement[] getChildren() {
        return this.getChildren(false);
    }

    public ICElement[] getChildren(boolean sync) {
        if (!this.cProject.hasStartBinaryRunner()) {
            this.cProject.setStartBinaryRunner(true);
            BinaryRunner runner = new BinaryRunner(this.cProject);
            Thread thread = new Thread((Runnable)runner, "Archive Runner");
            thread.setDaemon(true);
            thread.start();
            if (sync) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return super.getChildren();
    }

    void addChildIfLib(IFile file) {
        ICFile celement;
        CModelManager factory = CModelManager.getDefault();
        if (factory.isArchive(file) && (celement = factory.create(file)) != null && celement instanceof IArchive) {
            this.addChild(celement);
        }
    }

    public CElementInfo createElementInfo() {
        return new CElementInfo(this);
    }
}

