/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.BinaryInfo;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CFileInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

class ArchiveInfo
extends CFileInfo {
    IBinaryParser.IBinaryArchive archive;

    public ArchiveInfo(CElement element) {
        super(element);
    }

    public ICElement[] getChildren() {
        if (this.hasChanged()) {
            this.removeChildren();
            IResource res = null;
            try {
                res = this.getElement().getResource();
            }
            catch (CModelException e) {
                // empty catch block
            }
            IBinaryParser.IBinaryArchive ar = this.getBinaryArchive();
            IBinaryParser.IBinaryObject[] objects = ar.getObjects();
            int i = 0;
            while (i < objects.length) {
                final IBinaryParser.IBinaryObject obj = objects[i];
                Binary binary = new Binary(this.getElement(), res.getLocation().append(obj.getName())){

                    public CElementInfo createElementInfo() {
                        return new BinaryInfo(this, this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            IBinaryParser.IBinaryObject getBinaryObject() {
                                return 1.access$000(this.this$1);
                            }
                        };
                    }

                    static /* synthetic */ IBinaryParser.IBinaryObject access$000(1 x0) {
                        return x0.obj;
                    }
                };
                BinaryInfo info = (BinaryInfo)binary.getElementInfo();
                info.loadChildren();
                this.addChild(binary);
                ++i;
            }
        }
        return super.getChildren();
    }

    public boolean isArchive() {
        return true;
    }

    IBinaryParser.IBinaryArchive getBinaryArchive() {
        if (this.archive == null) {
            IProject project = this.getElement().getCProject().getProject();
            IBinaryParser parser = CModelManager.getDefault().getBinaryParser(project);
            if (parser != null) {
                try {
                    IPath path = this.getElement().getUnderlyingResource().getLocation();
                    IBinaryParser.IBinaryFile bfile = parser.getBinary(path);
                    if (bfile instanceof IBinaryParser.IBinaryArchive) {
                        this.archive = (IBinaryParser.IBinaryArchive)bfile;
                    }
                }
                catch (CModelException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return this.archive;
    }
}

