/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CFileInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

class BinaryInfo
extends CFileInfo {
    IBinaryParser.IBinaryObject binary;
    Map hash;

    public BinaryInfo(CElement element) {
        super(element);
    }

    public boolean isBinary() {
        return true;
    }

    public ICElement[] getChildren() {
        if (this.hasChanged()) {
            this.loadChildren();
        }
        return super.getChildren();
    }

    public String getCPU() {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        if (bin != null) {
            return bin.getCPU();
        }
        return "";
    }

    public boolean isSharedLib() {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        if (bin != null) {
            return bin.getType() == 4;
        }
        return false;
    }

    public boolean isExecutable() {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        if (bin != null) {
            return bin.getType() == 2;
        }
        return false;
    }

    public boolean isObject() {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        if (bin != null) {
            return bin.getType() == 1;
        }
        return false;
    }

    public boolean isCore() {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        if (bin != null) {
            return bin.getType() == 16;
        }
        return false;
    }

    public boolean hasDebug() {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        if (bin != null) {
            return bin.hasDebug();
        }
        return false;
    }

    public String[] getNeededSharedLibs() {
        if (this.isExecutable()) {
            IBinaryParser.IBinaryExecutable exec = (IBinaryParser.IBinaryExecutable)this.getBinaryObject();
            return exec.getNeededSharedLibs();
        }
        return new String[0];
    }

    public long getText() {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        if (bin != null) {
            return bin.getText();
        }
        return 0L;
    }

    public long getData() {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        if (bin != null) {
            return bin.getData();
        }
        return 0L;
    }

    public long getBSS() {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        if (bin != null) {
            return bin.getBSS();
        }
        return 0L;
    }

    public String getSoname() {
        if (this.isSharedLib()) {
            IBinaryParser.IBinaryShared shared = (IBinaryParser.IBinaryShared)this.getBinaryObject();
            return shared.getSoName();
        }
        return "";
    }

    public boolean isLittleEndian() {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        if (bin != null) {
            return bin.isLittleEndian();
        }
        return false;
    }

    void loadChildren() {
        if (this.hash == null) {
            this.hash = new HashMap();
        }
        this.hash.clear();
        this.removeChildren();
        this.setIsStructureKnown(true);
        IBinaryParser.IBinaryObject bin = this.getBinaryObject();
        IBinaryParser.ISymbol[] symbols = bin.getSymbols();
        int i = 0;
        while (i < symbols.length) {
            switch (symbols[i].getType()) {
                case 1: {
                    this.addFunction(symbols[i]);
                    break;
                }
                case 2: {
                    this.addVariable(symbols[i]);
                }
            }
            ++i;
        }
    }

    IBinaryParser.IBinaryObject getBinaryObject() {
        if (this.binary == null) {
            IProject project = this.getElement().getCProject().getProject();
            IBinaryParser parser = CModelManager.getDefault().getBinaryParser(project);
            if (parser != null) {
                try {
                    IPath path = this.getElement().getUnderlyingResource().getLocation();
                    IBinaryParser.IBinaryFile bfile = parser.getBinary(path);
                    if (bfile instanceof IBinaryParser.IBinaryObject) {
                        this.binary = (IBinaryParser.IBinaryObject)bfile;
                    }
                }
                catch (CModelException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return this.binary;
    }

    private void addFunction(IBinaryParser.ISymbol symbol) {
        CElement parent = this.getElement();
        String filename = symbol.getFilename();
        Function function = null;
        if (filename != null && !filename.equals("??")) {
            TranslationUnit tu = null;
            Path path = new Path(filename);
            if (this.hash.containsKey(path)) {
                tu = (TranslationUnit)this.hash.get(path);
            } else {
                tu = new TranslationUnit(parent, (IPath)path){
                    ArrayList array = new ArrayList(5);

                    public void addChild(ICElement e) {
                        this.array.add(e);
                        this.array.trimToSize();
                    }

                    public ICElement[] getChildren() {
                        return this.array.toArray(new ICElement[0]);
                    }
                };
                this.hash.put(path, tu);
                this.addChild(tu);
            }
            function = new Function(tu, symbol.getName());
            tu.addChild(function);
        } else {
            function = new Function(parent, symbol.getName());
            this.addChild(function);
        }
    }

    private void addVariable(IBinaryParser.ISymbol symbol) {
        String filename = symbol.getFilename();
        CElement parent = this.getElement();
        Variable variable = null;
        if (filename != null && !filename.equals("??")) {
            TranslationUnit tu = null;
            Path path = new Path(filename);
            if (this.hash.containsKey(path)) {
                tu = (TranslationUnit)this.hash.get(path);
            } else {
                tu = new TranslationUnit((ICElement)parent, (IPath)path);
                this.hash.put(path, tu);
                this.addChild(tu);
            }
            variable = new Variable(tu, symbol.getName());
            tu.addChild(variable);
        } else {
            variable = new Variable(parent, symbol.getName());
            this.addChild(variable);
        }
    }
}

