/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICFile;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CFileInfo;
import org.eclipse.cdt.internal.core.model.CResource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class CFile
extends CResource
implements ICFile {
    IPath location;

    public CFile(ICElement parent, IFile file) {
        this(parent, (IResource)file, file.getLocation(), file.getName());
    }

    public CFile(ICElement parent, IFile file, String name) {
        this(parent, (IResource)file, file.getLocation(), name);
    }

    public CFile(ICElement parent, IPath location) {
        this(parent, (IResource)ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location), location, location.lastSegment());
    }

    public CFile(ICElement parent, IResource res, IPath location, String name) {
        super(parent, res, name, 13);
        this.location = location;
    }

    public IPath getLocation() {
        return this.location;
    }

    public void setLocation(IPath location) {
        this.location = location;
    }

    public IFile getFile() {
        try {
            return (IFile)this.getUnderlyingResource();
        }
        catch (CModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isBinary() {
        return this.getCFileInfo().isBinary();
    }

    public boolean isArchive() {
        return this.getCFileInfo().isArchive();
    }

    public boolean isTranslationUnit() {
        return this.getCFileInfo().isTranslationUnit();
    }

    protected CFileInfo getCFileInfo() {
        return (CFileInfo)this.getElementInfo();
    }

    protected CElementInfo createElementInfo() {
        return new CFileInfo(this);
    }
}

