/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.Field;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.Include;
import org.eclipse.cdt.internal.core.model.Macro;
import org.eclipse.cdt.internal.core.model.Method;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.Structure;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.cdt.internal.parser.IStructurizerCallback;

public class ModelBuilder
implements IStructurizerCallback {
    private TranslationUnit fCurrFile;
    private CElement fCurrElement;

    public ModelBuilder(TranslationUnit file) {
        this.fCurrFile = file;
        this.fCurrElement = file;
    }

    private final int fixLength(int startPos, int endPos) {
        if (endPos < startPos) {
            return 0;
        }
        return endPos - startPos + 1;
    }

    public void includeDecl(String name, int startPos, int endPos, int startLine, int endLine) {
        Include elem = new Include(this.fCurrFile, name);
        elem.setPos(startPos, this.fixLength(startPos, endPos));
        elem.setIdPos(startPos, this.fixLength(startPos, endPos));
        elem.setLines(startLine, endLine);
        this.fCurrFile.addChild(elem);
    }

    public void defineDecl(String name, int startPos, int endPos, int startLine, int endLine) {
        Macro elem = new Macro(this.fCurrFile, name);
        elem.setPos(startPos, this.fixLength(startPos, endPos));
        elem.setIdPos(startPos, this.fixLength(startPos, endPos));
        elem.setLines(startLine, endLine);
        this.fCurrFile.addChild(elem);
    }

    public void functionDeclBegin(String name, int nameStartPos, int nameEndPos, int declStartPos, int startPos, int type, int modifiers) {
        SourceManipulation elem = this.fCurrElement instanceof IStructure ? new Method(this.fCurrElement, name) : (type == 70 ? new FunctionDeclaration(this.fCurrElement, name) : new Function(this.fCurrElement, name));
        elem.setPos(declStartPos, 0);
        elem.setIdPos(nameStartPos, this.fixLength(nameStartPos, nameEndPos));
        elem.setLines(startPos, -1);
        this.fCurrElement.addChild(elem);
        this.fCurrElement = elem;
    }

    public void functionDeclEnd(int declEndPos, int endLine, boolean prototype) {
        if (prototype && this.fCurrElement.getParent() instanceof Parent) {
            CElement oldElem = this.fCurrElement;
            FunctionDeclaration elem = new FunctionDeclaration(this.fCurrElement.getParent(), this.fCurrElement.getElementName());
            elem.setPos(oldElem.getStartPos(), 0);
            elem.setIdPos(oldElem.getIdStartPos(), oldElem.getIdLength());
            elem.setLines(oldElem.getStartLine(), -1);
            ((Parent)this.fCurrElement.getParent()).addChild(elem);
            ((Parent)this.fCurrElement.getParent()).removeChild(oldElem);
            this.fCurrElement = elem;
        }
        int declStartPos = this.fCurrElement.getStartPos();
        this.fCurrElement.setPos(declStartPos, this.fixLength(declStartPos, declEndPos));
        int startLine = this.fCurrElement.getStartLine();
        this.fCurrElement.setLines(startLine, endLine);
        this.fCurrElement = (CElement)this.fCurrElement.getParent();
    }

    public void fieldDecl(String name, int nameStartPos, int nameEndPos, int declStartPos, int declEndPos, int startLine, int endLine, int modifiers) {
        SourceManipulation elem = this.fCurrElement instanceof IStructure ? new Field(this.fCurrElement, name) : new Variable(this.fCurrElement, name);
        elem.setPos(declStartPos, this.fixLength(declStartPos, declEndPos));
        elem.setIdPos(nameStartPos, this.fixLength(nameStartPos, nameEndPos));
        elem.setLines(startLine, endLine);
        this.fCurrElement.addChild(elem);
    }

    public void structDeclBegin(String name, int kind, int nameStartPos, int nameEndPos, int declStartPos, int startLine, int modifiers) {
        if (this.isAnonymousStructure(name)) {
            name = new String("[anonymous]");
        }
        Structure elem = new Structure((ICElement)this.fCurrElement, kind, name);
        elem.setPos(declStartPos, 0);
        elem.setIdPos(nameStartPos, this.fixLength(nameStartPos, nameEndPos));
        elem.setLines(startLine, -1);
        this.fCurrElement.addChild(elem);
        this.fCurrElement = elem;
    }

    public void structDeclEnd(int declEndPos, int endLine) {
        int declStartPos = this.fCurrElement.getStartPos();
        this.fCurrElement.setPos(declStartPos, this.fixLength(declStartPos, declEndPos));
        int startLine = this.fCurrElement.getStartLine();
        this.fCurrElement.setLines(startLine, endLine);
        this.fCurrElement = (CElement)this.fCurrElement.getParent();
    }

    public void superDecl(String name) {
        if (this.fCurrElement instanceof IStructure) {
            ((Structure)this.fCurrElement).addSuperClass(name);
        }
    }

    public void reportError(Throwable throwable) {
    }

    private boolean assertCurrElement(int[] acceptedTypes) {
        boolean isOk = false;
        int currType = this.fCurrElement.getElementType();
        int i = 0;
        while (i < acceptedTypes.length) {
            if (currType == acceptedTypes[i]) {
                isOk = true;
            }
            ++i;
        }
        if (!isOk) {
            StringBuffer buf = new StringBuffer();
            buf.append("ModelBuilder: type check failed, is: ");
            buf.append(CElement.getTypeString(currType));
            buf.append(", should be [ ");
            int i2 = 0;
            while (i2 < acceptedTypes.length) {
                buf.append(CElement.getTypeString(acceptedTypes[i2]));
                buf.append(" ");
                ++i2;
            }
            buf.append("]");
        }
        return isOk;
    }

    private boolean isAnonymousStructure(String name) {
        return !Character.isJavaIdentifierStart(name.charAt(0));
    }
}

