/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.ParserSymbolTableException;

public class Declaration {
    public static final int typeMask = 31;
    public static final int isAuto = 32;
    public static final int isRegister = 64;
    public static final int isStatic = 128;
    public static final int isExtern = 256;
    public static final int isMutable = 512;
    public static final int isInline = 1024;
    public static final int isVirtual = 2048;
    public static final int isExplicit = 4096;
    public static final int isTypedef = 8192;
    public static final int isFriend = 16384;
    public static final int isConst = 32768;
    public static final int isVolatile = 65536;
    public static final int isUnsigned = 131072;
    public static final int isShort = 262144;
    public static final int isLong = 524288;
    public static final int t_type = 0;
    public static final int t_namespace = 1;
    public static final int t_class = 2;
    public static final int t_struct = 3;
    public static final int t_union = 4;
    public static final int t_enum = 5;
    public static final int t_function = 6;
    public static final int t_char = 7;
    public static final int t_wchar_t = 8;
    public static final int t_bool = 9;
    public static final int t_int = 10;
    public static final int t_float = 11;
    public static final int t_double = 12;
    public static final int t_void = 13;
    public static final int t_enumerator = 14;
    private int _typeInfo;
    private String _name;
    private Object _object;
    private Declaration _typeDeclaration;
    protected Declaration _containingScope;
    protected LinkedList _parentScopes;
    protected LinkedList _usingDirectives;
    protected Map _containedDeclarations;
    protected int _depth;

    public Declaration() {
    }

    public Declaration(String name) {
        this._name = name;
    }

    public Declaration(String name, Object obj) {
        this._name = name;
        this._object = obj;
    }

    public void setAuto(boolean b) {
        this.setBit(b, 32);
    }

    public boolean isAuto() {
        return this.checkBit(32);
    }

    public void setRegister(boolean b) {
        this.setBit(b, 64);
    }

    public boolean isRegister() {
        return this.checkBit(64);
    }

    public void setStatic(boolean b) {
        this.setBit(b, 128);
    }

    public boolean isStatic() {
        return this.checkBit(128);
    }

    public void setExtern(boolean b) {
        this.setBit(b, 256);
    }

    public boolean isExtern() {
        return this.checkBit(256);
    }

    public void setMutable(boolean b) {
        this.setBit(b, 512);
    }

    public boolean isMutable() {
        return this.checkBit(512);
    }

    public void setInline(boolean b) {
        this.setBit(b, 1024);
    }

    public boolean isInline() {
        return this.checkBit(1024);
    }

    public void setVirtual(boolean b) {
        this.setBit(b, 2048);
    }

    public boolean isVirtual() {
        return this.checkBit(2048);
    }

    public void setExplicit(boolean b) {
        this.setBit(b, 4096);
    }

    public boolean isExplicit() {
        return this.checkBit(4096);
    }

    public void setTypedef(boolean b) {
        this.setBit(b, 8192);
    }

    public boolean isTypedef() {
        return this.checkBit(8192);
    }

    public void setFriend(boolean b) {
        this.setBit(b, 16384);
    }

    public boolean isFriend() {
        return this.checkBit(16384);
    }

    public void setConst(boolean b) {
        this.setBit(b, 32768);
    }

    public boolean isConst() {
        return this.checkBit(32768);
    }

    public void setVolatile(boolean b) {
        this.setBit(b, 65536);
    }

    public boolean isVolatile() {
        return this.checkBit(65536);
    }

    public void setUnsigned(boolean b) {
        this.setBit(b, 131072);
    }

    public boolean isUnsigned() {
        return this.checkBit(131072);
    }

    public void setShort(boolean b) {
        this.setBit(b, 262144);
    }

    public boolean isShort() {
        return this.checkBit(262144);
    }

    public void setLong(boolean b) {
        this.setBit(b, 524288);
    }

    public boolean isLong() {
        return this.checkBit(524288);
    }

    public void setType(int t) throws ParserSymbolTableException {
        if (t > 31) {
            throw new ParserSymbolTableException(1);
        }
        this._typeInfo = this._typeInfo & 0xFFFFFFE0 | t;
    }

    public int getType() {
        return this._typeInfo & 0x1F;
    }

    public boolean isType(int type) {
        return this.isType(type, 0);
    }

    public boolean isType(int type, int upperType) {
        if (type == -1) {
            return true;
        }
        if (upperType == 0) {
            return this.getType() == type;
        }
        return this.getType() >= type && this.getType() <= upperType;
    }

    public Declaration getTypeDeclaration() {
        return this._typeDeclaration;
    }

    public void setTypeDeclaration(Declaration type) {
        try {
            this.setType(0);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            // empty catch block
        }
        this._typeDeclaration = type;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Object getObject() {
        return this._object;
    }

    public void setObject(Object obj) {
        this._object = obj;
    }

    public Declaration getContainingScope() {
        return this._containingScope;
    }

    protected void setContainingScope(Declaration scope) {
        this._containingScope = scope;
        this._depth = scope._depth + 1;
    }

    public void addParent(Declaration parent) {
        this.addParent(parent, false);
    }

    public void addParent(Declaration parent, boolean virtual) {
        if (this._parentScopes == null) {
            this._parentScopes = new LinkedList();
        }
        this._parentScopes.add(new ParentWrapper(parent, virtual));
    }

    public Map getContainedDeclarations() {
        return this._containedDeclarations;
    }

    public Map createContained() {
        if (this._containedDeclarations == null) {
            this._containedDeclarations = new HashMap();
        }
        return this._containedDeclarations;
    }

    public LinkedList getParentScopes() {
        return this._parentScopes;
    }

    private void setBit(boolean b, int mask) {
        this._typeInfo = b ? (this._typeInfo |= mask) : (this._typeInfo &= ~mask);
    }

    private boolean checkBit(int mask) {
        return (this._typeInfo & mask) != 0;
    }

    protected class ParentWrapper {
        public boolean isVirtual = false;
        public Declaration parent = null;

        public ParentWrapper(Declaration p, boolean v) {
            this.parent = p;
            this.isVirtual = v;
        }
    }
}

