/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.cdt.internal.core.parser.NullParserCallback;
import org.eclipse.cdt.internal.core.parser.Token;

public class ExpressionEvaluator
extends NullParserCallback {
    private Stack stack = new Stack();

    private int popInt() {
        return (Integer)this.stack.pop();
    }

    public void expressionOperator(Token operator) throws Exception {
        int second = this.popInt();
        switch (operator.getType()) {
            case 16: {
                int first = this.popInt();
                this.stack.push(new Integer(first + second));
                break;
            }
            case 21: {
                int first = this.popInt();
                this.stack.push(new Integer(first - second));
                break;
            }
            case 23: {
                int first = this.popInt();
                this.stack.push(new Integer(first * second));
                break;
            }
            case 52: {
                int first = this.popInt();
                this.stack.push(new Integer(first / second));
                break;
            }
            case 42: {
                int first = this.popInt();
                this.stack.push(new Integer(first < second ? 1 : 0));
                break;
            }
            case 41: {
                int first = this.popInt();
                this.stack.push(new Integer(first <= second ? 1 : 0));
                break;
            }
            case 46: {
                int first = this.popInt();
                this.stack.push(new Integer(first > second ? 1 : 0));
                break;
            }
            case 45: {
                int first = this.popInt();
                this.stack.push(new Integer(first >= second ? 1 : 0));
                break;
            }
            case 37: {
                int first = this.popInt();
                this.stack.push(new Integer(first == second ? 1 : 0));
                break;
            }
            case 35: {
                int first = this.popInt();
                this.stack.push(new Integer(first != second ? 1 : 0));
                break;
            }
            case 29: {
                int first = this.popInt();
                this.stack.push(new Integer(first != 0 && second != 0 ? 1 : 0));
                break;
            }
            case 32: {
                int first = this.popInt();
                this.stack.push(new Integer(first != 0 || second != 0 ? 1 : 0));
                break;
            }
            case 36: {
                this.stack.push(new Integer(second == 0 ? 1 : 0));
                break;
            }
            default: {
                throw new ExpressionException("Unhandled operator: " + operator);
            }
        }
    }

    public void expressionTerminal(Token terminal) throws Exception {
        switch (terminal.getType()) {
            case 2: {
                this.stack.push(new Integer(terminal.getImage()));
                break;
            }
            default: {
                throw new ExpressionException("Unhandled terminal: " + terminal.getImage());
            }
        }
    }

    public Object getResult() throws EmptyStackException {
        return this.stack.peek();
    }

    public class ExpressionException
    extends Exception {
        public ExpressionException(String msg) {
            super(msg);
        }
    }
}

