/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.IParserCallback;
import org.eclipse.cdt.internal.core.parser.IScanner;
import org.eclipse.cdt.internal.core.parser.NullParserCallback;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.cdt.internal.core.parser.Scanner;
import org.eclipse.cdt.internal.core.parser.Token;

public class Parser {
    private IParserCallback callback;
    private boolean quickParse = false;
    private boolean parsePassed = true;
    private Map currRegion = new HashMap();
    private static int parseCount = 0;
    private static Backtrack backtrack = new Backtrack();
    private IScanner scanner;
    private Token currToken;

    public Parser(IScanner s, IParserCallback c, boolean quick) throws Exception {
        this.callback = c;
        this.scanner = s;
        this.quickParse = quick;
        this.scanner.setQuickScan(quick);
        this.scanner.setCallback(c);
    }

    public Parser(IScanner s, IParserCallback c) throws Exception {
        this(s, c, false);
    }

    public Parser(IScanner s) throws Exception {
        this(s, (IParserCallback)new NullParserCallback(), false);
    }

    public Parser(String code) throws Exception {
        this(new Scanner().initialize(new StringReader(code), null));
    }

    public Parser(String code, IParserCallback c) throws Exception {
        this(new Scanner().initialize(new StringReader(code), null), c, false);
    }

    public Parser(InputStream stream, IParserCallback c, boolean quick) throws Exception {
        this(new Scanner().initialize(new InputStreamReader(stream), null), c, quick);
    }

    public boolean parse() throws Exception {
        long startTime = System.currentTimeMillis();
        this.translationUnit();
        System.out.println("Parse " + ++parseCount + ": " + (System.currentTimeMillis() - startTime) + "ms" + (this.parsePassed ? "" : " - parse failure"));
        return this.parsePassed;
    }

    public void translationUnit() throws Exception {
        Object translationUnit = this.callback.translationUnitBegin();
        Token lastBacktrack = null;
        Token lastToken = null;
        while (this.LT(1) != 0) {
            try {
                lastToken = this.currToken;
                this.declaration(translationUnit);
                if (this.currToken != lastToken) continue;
                this.skipToNextSemi();
            }
            catch (Backtrack b) {
                this.parsePassed = false;
                if (lastBacktrack != null && lastBacktrack == this.LA(1)) {
                    this.skipToNextSemi();
                    continue;
                }
                lastBacktrack = this.LA(1);
            }
        }
        this.callback.translationUnitEnd(translationUnit);
    }

    public void skipToNextSemi() {
        int t = this.LT(1);
        while (t != 0) {
            this.consume();
            if (t == 5) break;
            t = this.LT(1);
        }
    }

    public void declaration(Object container) throws Exception {
        switch (this.LT(1)) {
            case 56: {
                this.consume();
                return;
            }
            case 91: {
                this.consume();
                return;
            }
            case 121: {
                this.consume();
                return;
            }
            case 79: 
            case 111: {
                this.consume();
                return;
            }
            case 80: {
                if (this.LT(2) != 129) break;
                this.consume();
                return;
            }
        }
        this.simpleDeclaration(container);
    }

    public void simpleDeclaration(Object container) throws Exception {
        Object simpleDecl = this.callback.simpleDeclarationBegin(container);
        this.declSpecifierSeq(simpleDecl);
        if (this.LT(1) != 5) {
            try {
                this.initDeclarator(simpleDecl);
                while (this.LT(1) == 6) {
                    this.consume();
                    this.initDeclarator(simpleDecl);
                }
            }
            catch (Backtrack b) {
                // empty catch block
            }
        }
        switch (this.LT(1)) {
            case 5: {
                this.consume();
                break;
            }
            case 4: {
                this.consume();
                while (this.LT(1) != 12) {
                    if (this.consume().getType() != 0) continue;
                    throw backtrack;
                }
            }
            case 12: {
                this.callback.functionBodyBegin();
                if (this.quickParse) {
                    this.consume();
                    int depth = 1;
                    while (depth > 0) {
                        switch (this.consume().getType()) {
                            case 13: {
                                --depth;
                                break;
                            }
                            case 12: {
                                ++depth;
                                break;
                            }
                            case 0: {
                                throw backtrack;
                            }
                        }
                    }
                } else {
                    this.functionBody();
                }
                this.callback.functionBodyEnd();
                break;
            }
        }
        this.callback.simpleDeclarationEnd(simpleDecl);
    }

    public void parameterDeclaration(Object containerObject) throws Exception {
        Object parameterDecl = this.callback.parameterDeclarationBegin(containerObject);
        this.declSpecifierSeq(parameterDecl);
        if (this.LT(1) != 5) {
            try {
                this.initDeclarator(parameterDecl);
            }
            catch (Backtrack backtrack) {
                // empty catch block
            }
        }
        this.callback.parameterDeclarationEnd(parameterDecl);
    }

    public void declSpecifierSeq(Object decl) throws Exception {
        boolean encounteredTypename = false;
        boolean encounteredRawType = false;
        block9: while (true) {
            switch (this.LT(1)) {
                case 57: 
                case 67: 
                case 78: 
                case 80: 
                case 84: 
                case 87: 
                case 90: 
                case 101: 
                case 106: 
                case 116: 
                case 122: 
                case 124: {
                    this.callback.simpleDeclSpecifier(decl, this.consume());
                    continue block9;
                }
                case 60: 
                case 64: 
                case 74: 
                case 82: 
                case 88: 
                case 89: 
                case 104: 
                case 108: 
                case 120: 
                case 123: 
                case 125: {
                    encounteredRawType = true;
                    this.callback.simpleDeclSpecifier(decl, this.consume());
                    continue block9;
                }
                case 118: {
                    this.consume();
                    this.name();
                    continue block9;
                }
                case 3: {
                    this.consume();
                }
                case 1: {
                    if (!encounteredRawType && this.LT(2) != 3 && this.LT(2) != 8) {
                        if (!encounteredTypename) {
                            this.callback.simpleDeclSpecifier(decl, this.consume());
                            encounteredTypename = true;
                            continue block9;
                        }
                        return;
                    }
                    return;
                }
                case 65: 
                case 109: 
                case 119: {
                    this.classSpecifier(decl);
                    return;
                }
                case 77: {
                    this.enumSpecifier(decl);
                    continue block9;
                }
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean name() throws Exception {
        first = this.LA(1);
        last = null;
        this.callback.nameBegin(first);
        if (this.LT(1) == 3) {
            last = this.consume();
        }
        if (this.LT(1) == 34) {
            this.consume();
        }
        switch (this.LT(1)) {
            case 1: {
                last = this.consume();
                if (true) ** GOTO lbl23
            }
            default: {
                throw Parser.backtrack;
            }
        }
        do {
            last = this.consume();
            if (this.LT(1) == 34) {
                this.consume();
            }
            switch (this.LT(1)) {
                case 1: {
                    last = this.consume();
                }
            }
lbl23:
            // 3 sources

        } while (this.LT(1) == 3);
        this.callback.nameEnd(last);
        return true;
    }

    public Object cvQualifier() throws Exception {
        switch (this.LT(1)) {
            case 67: 
            case 124: {
                this.consume();
                return null;
            }
        }
        throw backtrack;
    }

    public void initDeclarator(Object owner) throws Exception {
        Object declarator = this.declarator(owner);
        if (this.LT(1) == 38) {
            this.consume();
            try {
                this.assignmentExpression();
            }
            catch (Backtrack b) {
                // empty catch block
            }
            try {
                this.assignmentExpression();
            }
            catch (Backtrack b) {
                // empty catch block
            }
            if (this.LT(1) == 12) {
                this.consume();
                int depth = 1;
                while (depth > 0) {
                    switch (this.consume().getType()) {
                        case 13: {
                            --depth;
                            break;
                        }
                        case 12: {
                            ++depth;
                            break;
                        }
                        case 0: {
                            throw backtrack;
                        }
                    }
                }
            }
        } else if (this.LT(1) == 8) {
            this.consume();
            this.constantExpression();
            if (this.LT(1) == 9) {
                this.consume();
            }
        }
        this.callback.declaratorEnd(declarator);
    }

    public Object declarator(Object container) throws Exception {
        block11: while (true) {
            Object declarator = this.callback.declaratorBegin(container);
            while (true) {
                try {
                    this.ptrOperator();
                }
                catch (Backtrack b) {
                    if (this.LT(1) == 8) {
                        this.consume();
                        this.declarator(declarator);
                        this.consume(9);
                        return declarator;
                    }
                    this.name();
                    this.callback.declaratorId(declarator);
                    block13: while (true) {
                        switch (this.LT(1)) {
                            case 8: {
                                if (this.LT(2) == 2) break block13;
                                Object clause = this.callback.argumentsBegin(declarator);
                                this.consume();
                                block14: while (true) {
                                    switch (this.LT(1)) {
                                        case 9: {
                                            this.consume();
                                            break block14;
                                        }
                                        case 48: {
                                            this.consume();
                                            continue block14;
                                        }
                                        case 6: {
                                            this.consume();
                                            continue block14;
                                        }
                                        default: {
                                            this.parameterDeclaration(clause);
                                            continue block14;
                                        }
                                    }
                                    break;
                                }
                                this.callback.argumentsEnd(clause);
                                break block13;
                            }
                            case 10: {
                                this.consume();
                                this.consume(11);
                                continue block13;
                            }
                        }
                        break;
                    }
                    if (this.LA(1).getType() == 1) {
                        this.callback.declaratorAbort(container, declarator);
                        declarator = null;
                        continue block11;
                    }
                    return declarator;
                }
            }
            break;
        }
    }

    public Object ptrOperator() throws Exception {
        int t = this.LT(1);
        if (t == 30) {
            this.consume();
            return null;
        }
        Token mark = this.mark();
        if (t == 1 || t == 3) {
            this.name();
        }
        if (t == 23) {
            this.consume();
            while (true) {
                try {
                    this.cvQualifier();
                }
                catch (Backtrack b) {
                    return null;
                }
            }
        }
        this.backup(mark);
        throw backtrack;
    }

    public void enumSpecifier(Object owner) throws Exception {
        if (this.LT(1) != 77) {
            throw backtrack;
        }
        this.consume();
        if (this.LT(1) == 1) {
            this.consume();
        }
        if (this.LT(1) == 12) {
            this.consume();
            int depth = 1;
            while (depth > 0) {
                switch (this.consume().getType()) {
                    case 13: {
                        --depth;
                        break;
                    }
                    case 12: {
                        ++depth;
                        break;
                    }
                    case 0: {
                        throw backtrack;
                    }
                }
            }
        }
    }

    public void classSpecifier(Object owner) throws Exception {
        Token classKey = null;
        switch (this.LT(1)) {
            case 65: 
            case 109: 
            case 119: {
                classKey = this.consume();
                break;
            }
            default: {
                throw backtrack;
            }
        }
        Object classSpec = this.callback.classSpecifierBegin(owner, classKey);
        if (this.LT(1) == 1) {
            this.name();
            this.callback.classSpecifierName(classSpec);
        }
        if (this.LT(1) == 4) {
            this.consume();
            this.baseSpecifier(classSpec);
        }
        if (this.LT(1) == 12) {
            this.consume();
            block9: while (this.LT(1) != 13) {
                Token lastToken = this.currToken;
                switch (this.LT(1)) {
                    case 100: {
                        this.consume();
                        this.consume(4);
                        break;
                    }
                    case 99: {
                        this.consume();
                        this.consume(4);
                        break;
                    }
                    case 98: {
                        this.consume();
                        this.consume(4);
                        break;
                    }
                    case 13: {
                        this.consume(13);
                        break block9;
                    }
                    default: {
                        this.declaration(classSpec);
                    }
                }
                if (lastToken != this.currToken) continue;
                this.skipToNextSemi();
            }
            this.consume();
        }
        this.callback.classSpecifierEnd(classSpec);
    }

    public void baseSpecifier(Object classSpecOwner) throws Exception {
        Object baseSpecifier = this.callback.baseSpecifierBegin(classSpecOwner);
        block6: while (true) {
            switch (this.LT(1)) {
                case 122: {
                    this.callback.baseSpecifierVirtual(baseSpecifier, true);
                    this.consume();
                    continue block6;
                }
                case 98: 
                case 99: 
                case 100: {
                    this.callback.baseSpecifierVisibility(baseSpecifier, this.currToken);
                    this.consume();
                    continue block6;
                }
                case 1: 
                case 3: {
                    this.name();
                    this.callback.baseSpecifierName(baseSpecifier);
                    continue block6;
                }
                case 6: {
                    this.callback.baseSpecifierEnd(baseSpecifier);
                    baseSpecifier = this.callback.baseSpecifierBegin(classSpecOwner);
                    this.consume();
                    continue block6;
                }
            }
            break;
        }
        this.callback.baseSpecifierEnd(baseSpecifier);
    }

    public void functionBody() throws Exception {
        this.compoundStatement();
    }

    public void statement() throws Exception {
        switch (this.LT(1)) {
            case 62: {
                this.consume();
                this.constantExpression();
                this.consume(4);
                this.statement();
                return;
            }
            case 71: {
                this.consume();
                this.consume(4);
                this.statement();
                return;
            }
            case 12: {
                this.compoundStatement();
                return;
            }
            case 86: {
                this.consume();
                this.consume(8);
                this.condition();
                this.consume(9);
                this.statement();
                if (this.LT(1) == 76) {
                    this.consume();
                    this.statement();
                }
                return;
            }
            case 110: {
                this.consume();
                this.consume(8);
                this.condition();
                this.consume(9);
                this.statement();
                return;
            }
            case 126: {
                this.consume();
                this.consume(8);
                this.condition();
                this.consume(9);
                this.statement();
                return;
            }
            case 73: {
                this.consume();
                this.statement();
                this.consume(126);
                this.consume(8);
                this.condition();
                this.consume(9);
                return;
            }
            case 83: {
                this.consume();
                this.consume(8);
                this.forInitStatement();
                if (this.LT(1) != 5) {
                    this.condition();
                }
                this.consume(5);
                if (this.LT(1) != 9) {
                    this.expression();
                }
                this.consume(9);
                this.statement();
                return;
            }
            case 61: {
                this.consume();
                this.consume(5);
                return;
            }
            case 70: {
                this.consume();
                this.consume(5);
                return;
            }
            case 103: {
                this.consume();
                if (this.LT(1) != 5) {
                    this.expression();
                }
                this.consume(5);
                return;
            }
            case 85: {
                this.consume();
                this.consume(1);
                this.consume(5);
                return;
            }
            case 115: {
                this.consume();
                this.compoundStatement();
                while (this.LT(1) == 63) {
                    this.consume();
                    this.consume(8);
                    this.declaration(null);
                    this.consume(9);
                    this.compoundStatement();
                }
                return;
            }
            case 5: {
                this.consume();
                return;
            }
        }
        if (this.LT(1) == 1 && this.LT(2) == 4) {
            this.consume();
            this.consume();
            this.statement();
            return;
        }
        try {
            this.expression();
            this.consume(5);
            return;
        }
        catch (Backtrack backtrack) {
            this.declaration(null);
            return;
        }
    }

    public void condition() throws Exception {
    }

    public void forInitStatement() throws Exception {
    }

    public void compoundStatement() throws Exception {
        this.consume(12);
        while (this.LT(1) != 13) {
            this.statement();
        }
        this.consume();
    }

    public void constantExpression() throws Exception {
        this.conditionalExpression();
    }

    public void expression() throws Exception {
        this.assignmentExpression();
        while (this.LT(1) == 6) {
            Token t = this.consume();
            this.assignmentExpression();
            this.callback.expressionOperator(t);
        }
    }

    public void assignmentExpression() throws Exception {
        if (this.LT(1) == 113) {
            this.throwExpression();
            return;
        }
        if (!this.conditionalExpression()) {
            switch (this.LT(1)) {
                case 14: 
                case 17: 
                case 22: 
                case 24: 
                case 26: 
                case 28: 
                case 31: 
                case 38: 
                case 43: 
                case 47: 
                case 51: {
                    Token t = this.consume();
                    this.conditionalExpression();
                    this.callback.expressionOperator(t);
                }
            }
        }
    }

    public void throwExpression() throws Exception {
        this.consume(113);
        try {
            this.expression();
        }
        catch (Backtrack backtrack) {
            // empty catch block
        }
    }

    public boolean conditionalExpression() throws Exception {
        this.logicalOrExpression();
        if (this.LT(1) == 7) {
            this.consume();
            this.expression();
            this.consume(4);
            this.assignmentExpression();
            return true;
        }
        return false;
    }

    public void logicalOrExpression() throws Exception {
        this.logicalAndExpression();
        while (this.LT(1) == 32) {
            Token t = this.consume();
            this.logicalAndExpression();
            this.callback.expressionOperator(t);
        }
    }

    public void logicalAndExpression() throws Exception {
        this.inclusiveOrExpression();
        while (this.LT(1) == 29) {
            Token t = this.consume();
            this.inclusiveOrExpression();
            this.callback.expressionOperator(t);
        }
    }

    public void inclusiveOrExpression() throws Exception {
        this.exclusiveOrExpression();
        while (this.LT(1) == 33) {
            Token t = this.consume();
            this.exclusiveOrExpression();
            this.callback.expressionOperator(t);
        }
    }

    public void exclusiveOrExpression() throws Exception {
        this.andExpression();
        while (this.LT(1) == 27) {
            Token t = this.consume();
            this.andExpression();
            this.callback.expressionOperator(t);
        }
    }

    public void andExpression() throws Exception {
        this.equalityExpression();
        while (this.LT(1) == 30) {
            Token t = this.consume();
            this.equalityExpression();
            this.callback.expressionOperator(t);
        }
    }

    public void equalityExpression() throws Exception {
        this.relationalExpression();
        block3: while (true) {
            switch (this.LT(1)) {
                case 35: 
                case 37: {
                    Token t = this.consume();
                    this.relationalExpression();
                    this.callback.expressionOperator(t);
                    continue block3;
                }
            }
            break;
        }
    }

    public void relationalExpression() throws Exception {
        this.shiftExpression();
        block3: while (true) {
            switch (this.LT(1)) {
                case 41: 
                case 42: 
                case 45: 
                case 46: {
                    Token t = this.consume();
                    this.shiftExpression();
                    this.callback.expressionOperator(t);
                    continue block3;
                }
            }
            break;
        }
    }

    public void shiftExpression() throws Exception {
        this.additiveExpression();
        block3: while (true) {
            switch (this.LT(1)) {
                case 40: 
                case 44: {
                    Token t = this.consume();
                    this.additiveExpression();
                    this.callback.expressionOperator(t);
                    continue block3;
                }
            }
            break;
        }
    }

    public void additiveExpression() throws Exception {
        this.multiplicativeExpression();
        block3: while (true) {
            switch (this.LT(1)) {
                case 16: 
                case 21: {
                    Token t = this.consume();
                    this.multiplicativeExpression();
                    this.callback.expressionOperator(t);
                    continue block3;
                }
            }
            break;
        }
    }

    public void multiplicativeExpression() throws Exception {
        this.pmExpression();
        block3: while (true) {
            switch (this.LT(1)) {
                case 23: 
                case 25: 
                case 52: {
                    Token t = this.consume();
                    this.pmExpression();
                    this.callback.expressionOperator(t);
                    continue block3;
                }
            }
            break;
        }
    }

    public void pmExpression() throws Exception {
        this.castExpression();
        block3: while (true) {
            switch (this.LT(1)) {
                case 19: 
                case 49: {
                    Token t = this.consume();
                    this.castExpression();
                    this.callback.expressionOperator(t);
                    continue block3;
                }
            }
            break;
        }
    }

    public void castExpression() throws Exception {
        this.unaryExpression();
    }

    public void typeId() throws Exception {
        try {
            this.name();
            return;
        }
        catch (Backtrack backtrack) {
            return;
        }
    }

    public void deleteExpression() throws Exception {
        if (this.LT(1) == 3) {
            this.consume();
        }
        this.consume(72);
        if (this.LT(1) == 10) {
            this.consume();
            this.consume(11);
        }
        this.castExpression();
    }

    public void newExpression() throws Exception {
        if (this.LT(1) == 3) {
            this.consume();
        }
        this.consume(92);
    }

    public void unaryExpression() throws Exception {
        switch (this.LT(1)) {
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 30: 
            case 34: 
            case 36: {
                Token t = this.consume();
                this.castExpression();
                this.callback.expressionOperator(t);
                return;
            }
            case 105: {
                if (this.LT(1) == 8) {
                    this.consume();
                    this.typeId();
                    this.consume(9);
                } else {
                    this.unaryExpression();
                }
                return;
            }
            case 92: {
                this.newExpression();
                return;
            }
            case 72: {
                this.deleteExpression();
                return;
            }
            case 3: {
                switch (this.LT(2)) {
                    case 92: {
                        this.newExpression();
                        return;
                    }
                    case 72: {
                        this.deleteExpression();
                        return;
                    }
                }
                this.postfixExpression();
                return;
            }
        }
        this.postfixExpression();
    }

    public void postfixExpression() throws Exception {
        switch (this.LT(1)) {
            case 118: {
                this.consume();
                break;
            }
            case 69: 
            case 75: 
            case 102: 
            case 107: {
                this.consume();
                this.consume(42);
                this.typeId();
                this.consume(46);
                this.consume(8);
                this.expression();
                this.consume(9);
                break;
            }
            case 117: {
                this.consume();
                this.consume(8);
                try {
                    this.typeId();
                }
                catch (Backtrack b) {
                    this.expression();
                }
                this.consume(9);
                break;
            }
            default: {
                this.primaryExpression();
                break;
            }
        }
        block13: while (true) {
            switch (this.LT(1)) {
                case 10: {
                    this.consume();
                    this.expression();
                    this.consume(11);
                    continue block13;
                }
                case 8: {
                    this.consume();
                    this.expression();
                    this.consume(9);
                    continue block13;
                }
                case 15: 
                case 18: {
                    this.consume();
                    continue block13;
                }
                case 20: 
                case 50: {
                    this.consume();
                    continue block13;
                }
            }
            break;
        }
    }

    public void primaryExpression() throws Exception {
        int type = this.LT(1);
        switch (type) {
            case 2: {
                this.callback.expressionTerminal(this.consume());
                return;
            }
            case 129: {
                this.callback.expressionTerminal(this.consume());
                return;
            }
            case 1: {
                this.callback.expressionTerminal(this.consume());
                return;
            }
            case 112: {
                this.consume();
                return;
            }
            case 8: {
                this.consume();
                this.expression();
                this.consume(9);
                return;
            }
        }
    }

    public void varName() throws Exception {
        if (this.LT(1) == 3) {
            this.consume();
        }
        block8: while (true) {
            switch (this.LT(1)) {
                case 1: {
                    this.consume();
                    if (this.LT(1) == 3) {
                        switch (this.LT(2)) {
                            case 1: 
                            case 34: 
                            case 95: {
                                this.consume();
                                continue block8;
                            }
                        }
                        return;
                    }
                    return;
                }
                case 34: {
                    this.consume();
                    this.consume(1);
                    return;
                }
                case 95: {
                    this.consume();
                    return;
                }
            }
            break;
        }
        throw backtrack;
    }

    private Token fetchToken() {
        try {
            return this.scanner.nextToken();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Token LA(int i) {
        if (i < 1) {
            return null;
        }
        if (this.currToken == null) {
            this.currToken = this.fetchToken();
        }
        Token retToken = this.currToken;
        while (i > 1) {
            if (retToken.getNext() == null) {
                this.fetchToken();
            }
            retToken = retToken.getNext();
            --i;
        }
        return retToken;
    }

    protected int LT(int i) {
        return this.LA((int)i).type;
    }

    protected Token consume() {
        if (this.currToken.getNext() == null) {
            this.fetchToken();
        }
        Token retToken = this.currToken;
        this.currToken = this.currToken.getNext();
        return retToken;
    }

    protected Token consume(int type) throws Exception {
        if (this.LT(1) == type) {
            return this.consume();
        }
        throw backtrack;
    }

    protected Token mark() {
        return this.currToken;
    }

    protected void backup(Token mark) {
        this.currToken = mark;
    }

    public static String generateName(Token startToken) throws Exception {
        Token currToken = startToken.getNext();
        if (currToken == null || currToken.getType() != 3) {
            return startToken.getImage();
        }
        StringBuffer buff = new StringBuffer(startToken.getImage());
        while (currToken != null && currToken.getType() == 3) {
            if ((currToken = currToken.getNext()) == null || currToken.getType() != 1) {
                throw new ParserException(startToken);
            }
            buff.append("::");
            buff.append(currToken.getImage());
            currToken = currToken.getNext();
        }
        return buff.toString();
    }

    private static class Backtrack
    extends Exception {
        private Backtrack() {
        }
    }
}

