/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.internal.core.parser.Declaration;
import org.eclipse.cdt.internal.core.parser.ParserSymbolTableException;

public class ParserSymbolTable {
    private Stack _contextStack = new Stack();
    private Declaration _compilationUnit = new Declaration();
    static /* synthetic */ Class class$org$eclipse$cdt$internal$core$parser$Declaration;
    static /* synthetic */ Class class$java$util$LinkedList;

    public ParserSymbolTable() {
        this.push(this._compilationUnit);
    }

    public void push(Declaration obj) {
        if (!this._contextStack.empty() && obj.getContainingScope() == null) {
            obj.setContainingScope((Declaration)this._contextStack.peek());
        }
        this._contextStack.push(obj);
    }

    public Declaration pop() {
        return (Declaration)this._contextStack.pop();
    }

    public Declaration peek() {
        return (Declaration)this._contextStack.peek();
    }

    public Declaration getCompilationUnit() {
        return this._compilationUnit;
    }

    public Declaration Lookup(String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, -1);
        return ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
    }

    public Declaration ElaboratedLookup(int type, String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, type);
        return ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
    }

    public Declaration LookupNestedNameSpecifier(String name) throws ParserSymbolTableException {
        return this.LookupNestedNameSpecifier(name, (Declaration)this._contextStack.peek());
    }

    private Declaration LookupNestedNameSpecifier(String name, Declaration inDeclaration) throws ParserSymbolTableException {
        Declaration foundDeclaration = null;
        LookupData data = new LookupData(name, 1);
        data.upperType = 4;
        foundDeclaration = ParserSymbolTable.LookupInContained(data, inDeclaration);
        if (foundDeclaration == null && inDeclaration._containingScope != null) {
            foundDeclaration = this.LookupNestedNameSpecifier(name, inDeclaration._containingScope);
        }
        return foundDeclaration;
    }

    public Declaration QualifiedLookup(String name) throws ParserSymbolTableException {
        LookupData data = new LookupData(name, -1);
        data.qualified = true;
        return ParserSymbolTable.Lookup(data, (Declaration)this._contextStack.peek());
    }

    public void addUsingDirective(Declaration namespace) throws ParserSymbolTableException {
        if (namespace.getType() != 1) {
            throw new ParserSymbolTableException();
        }
        Declaration declaration = (Declaration)this._contextStack.peek();
        if (declaration._usingDirectives == null) {
            declaration._usingDirectives = new LinkedList();
        }
        declaration._usingDirectives.add(namespace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDeclaration(Declaration obj) throws ParserSymbolTableException {
        Declaration containing = (Declaration)this._contextStack.peek();
        Map declarations = containing.getContainedDeclarations();
        Object origObj = null;
        obj.setContainingScope(containing);
        if (declarations == null) {
            declarations = containing.createContained();
        } else {
            origObj = declarations.get(obj.getName());
        }
        if (origObj != null) {
            Declaration origDecl = null;
            LinkedList<Declaration> origList = null;
            if (origObj.getClass() == (class$org$eclipse$cdt$internal$core$parser$Declaration == null ? (class$org$eclipse$cdt$internal$core$parser$Declaration = ParserSymbolTable.class$("org.eclipse.cdt.internal.core.parser.Declaration")) : class$org$eclipse$cdt$internal$core$parser$Declaration)) {
                origDecl = (Declaration)origObj;
            } else {
                if (origObj.getClass() != (class$java$util$LinkedList == null ? (class$java$util$LinkedList = ParserSymbolTable.class$("java.util.LinkedList")) : class$java$util$LinkedList)) throw new ParserSymbolTableException();
                origList = (LinkedList<Declaration>)origObj;
            }
            if (!(origList == null ? ParserSymbolTable.isValidOverload(origDecl, obj) : ParserSymbolTable.isValidOverload(origList, obj))) throw new ParserSymbolTableException();
            if (origList == null) {
                origList = new LinkedList<Declaration>();
                origList.add(origDecl);
                origList.add(obj);
                declarations.remove(obj);
                declarations.put(obj.getName(), origList);
                return;
            } else {
                origList.add(obj);
            }
            return;
        } else {
            declarations.put(obj.getName(), obj);
        }
    }

    private static Declaration Lookup(LookupData data, Declaration inDeclaration) throws ParserSymbolTableException {
        if (data.type != -1 && data.type < 2 && data.upperType > 4) {
            throw new ParserSymbolTableException(1);
        }
        Declaration decl = null;
        LinkedList tempList = null;
        LinkedList<Declaration> foundNames = new LinkedList<Declaration>();
        LinkedList transitives = new LinkedList();
        decl = ParserSymbolTable.LookupInContained(data, inDeclaration);
        if (decl != null) {
            foundNames.add(decl);
        }
        data.visited.clear();
        tempList = ParserSymbolTable.LookupInNominated(data, inDeclaration, transitives);
        if (tempList != null) {
            foundNames.addAll(tempList);
        }
        if (!data.qualified || foundNames.size() == 0) {
            ParserSymbolTable.ProcessDirectives(inDeclaration, data, transitives);
            if (inDeclaration._usingDirectives != null) {
                ParserSymbolTable.ProcessDirectives(inDeclaration, data, inDeclaration._usingDirectives);
            }
            while (data.usingDirectives != null && data.usingDirectives.get(inDeclaration) != null) {
                transitives.clear();
                tempList = ParserSymbolTable.LookupInNominated(data, inDeclaration, transitives);
                if (tempList != null) {
                    foundNames.addAll(tempList);
                }
                if (data.qualified && foundNames.size() != 0) continue;
                ParserSymbolTable.ProcessDirectives(inDeclaration, data, transitives);
            }
        }
        if ((decl = ParserSymbolTable.ResolveAmbiguities(foundNames)) != null) {
            return decl;
        }
        data.visited.clear();
        decl = ParserSymbolTable.LookupInParents(data, inDeclaration);
        if (decl == null && inDeclaration._containingScope != null) {
            decl = ParserSymbolTable.Lookup(data, inDeclaration._containingScope);
        }
        return decl;
    }

    private static LinkedList LookupInNominated(LookupData data, Declaration declaration, LinkedList transitiveDirectives) throws ParserSymbolTableException {
        if (data.usingDirectives == null) {
            return null;
        }
        LinkedList<Declaration> found = null;
        LinkedList list = null;
        Iterator iter = null;
        Declaration decl = null;
        Declaration temp = null;
        int size = 0;
        list = (LinkedList)data.usingDirectives.remove(declaration);
        if (list == null) {
            return null;
        }
        iter = list.iterator();
        int i = size = list.size();
        while (i > 0) {
            decl = (Declaration)iter.next();
            if (!data.visited.contains(decl)) {
                data.visited.add(decl);
                temp = ParserSymbolTable.LookupInContained(data, decl);
                if (temp != null) {
                    if (found == null) {
                        found = new LinkedList<Declaration>();
                    }
                    found.add(temp);
                }
                if (!(data.qualified && temp != null || decl._usingDirectives == null)) {
                    transitiveDirectives.addAll(decl._usingDirectives);
                }
            }
            --i;
        }
        return found;
    }

    private static Declaration LookupInContained(LookupData data, Declaration lookIn) throws ParserSymbolTableException {
        LinkedList<Declaration> found = null;
        Declaration temp = null;
        Object obj = null;
        Map declarations = lookIn.getContainedDeclarations();
        if (declarations == null) {
            return null;
        }
        obj = declarations.get(data.name);
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == (class$org$eclipse$cdt$internal$core$parser$Declaration == null ? (class$org$eclipse$cdt$internal$core$parser$Declaration = ParserSymbolTable.class$("org.eclipse.cdt.internal.core.parser.Declaration")) : class$org$eclipse$cdt$internal$core$parser$Declaration)) {
            if (((Declaration)obj).isType(data.type, data.upperType)) {
                return (Declaration)obj;
            }
        } else {
            found = new LinkedList<Declaration>();
            LinkedList objList = (LinkedList)obj;
            Iterator iter = objList.iterator();
            int size = objList.size();
            int i = 0;
            while (i < size) {
                temp = (Declaration)iter.next();
                if (temp.isType(data.type, data.upperType)) {
                    found.add(temp);
                }
                ++i;
            }
        }
        if (found == null || found.size() == 0) {
            return null;
        }
        return ParserSymbolTable.ResolveAmbiguities(found);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Declaration LookupInParents(LookupData data, Declaration lookIn) throws ParserSymbolTableException {
        int size;
        LinkedList scopes = lookIn.getParentScopes();
        Declaration decl = null;
        Declaration temp = null;
        Iterator iterator = null;
        Declaration.ParentWrapper wrapper = null;
        if (scopes == null) {
            return null;
        }
        iterator = scopes.iterator();
        int i = size = scopes.size();
        while (i > 0) {
            wrapper = (Declaration.ParentWrapper)iterator.next();
            if (!wrapper.isVirtual || !data.visited.contains(wrapper.parent)) {
                if (wrapper.isVirtual) {
                    data.visited.add(wrapper.parent);
                }
                if ((temp = ParserSymbolTable.LookupInContained(data, wrapper.parent)) == null) {
                    temp = ParserSymbolTable.LookupInParents(data, wrapper.parent);
                }
            }
            if (temp != null && temp.isType(data.type)) {
                if (decl == null) {
                    decl = temp;
                } else if (temp != null) {
                    if (decl != temp || !temp.isStatic() && temp.getType() != 14) throw new ParserSymbolTableException(0);
                    temp = null;
                }
            } else {
                temp = null;
            }
            --i;
        }
        return decl;
    }

    private static boolean isValidOverload(Declaration origDecl, Declaration newDecl) {
        int origType = origDecl.getType();
        int newType = newDecl.getType();
        if (origType >= 2 && origType <= 5 && (newType == 0 || newType >= 6 && newType <= 31)) {
            return true;
        }
        return origType == 6 && newType == 6;
    }

    private static boolean isValidOverload(LinkedList origList, Declaration newDecl) {
        if (origList.size() == 1) {
            return ParserSymbolTable.isValidOverload((Declaration)origList.getFirst(), newDecl);
        }
        if (origList.size() > 1) {
            if (newDecl.getType() != 6) {
                return false;
            }
            Iterator iter = origList.iterator();
            Declaration decl = (Declaration)iter.next();
            boolean valid = decl.getType() >= 2 && decl.getType() <= 5 || decl.getType() == 6;
            while (valid && iter.hasNext()) {
                decl = (Declaration)iter.next();
                boolean bl = valid = decl.getType() == 6;
            }
            return valid;
        }
        return true;
    }

    private static Declaration ResolveAmbiguities(LinkedList items) throws ParserSymbolTableException {
        Declaration decl = null;
        int size = items.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (Declaration)items.getFirst();
        }
        Declaration first = (Declaration)items.removeFirst();
        if (first.getType() >= 2 && first.getType() <= 5) {
            return ParserSymbolTable.ResolveAmbiguities(items);
        }
        boolean needSame = first.getType() != 6;
        Iterator iter = items.iterator();
        int i = size - 1;
        while (i > 0) {
            decl = (Declaration)iter.next();
            if (needSame ? decl != first : decl.getType() != 6) {
                throw new ParserSymbolTableException();
            }
            --i;
        }
        if (needSame) {
            return first;
        }
        items.addFirst(first);
        return ParserSymbolTable.ResolveFunction(items);
    }

    private static Declaration ResolveFunction(LinkedList functions) {
        return null;
    }

    private static void ProcessDirectives(Declaration decl, LookupData data, LinkedList directives) {
        Declaration enclosing = null;
        Declaration temp = null;
        int size = directives.size();
        Iterator iter = directives.iterator();
        int i = size;
        while (i > 0) {
            temp = (Declaration)iter.next();
            if (!data.visited.contains(temp)) {
                LinkedList<Declaration> list;
                enclosing = ParserSymbolTable.getClosestEnclosingDeclaration(decl, temp);
                LinkedList<Declaration> linkedList = list = data.usingDirectives == null ? null : (LinkedList<Declaration>)data.usingDirectives.get(enclosing);
                if (list == null) {
                    list = new LinkedList<Declaration>();
                    list.add(temp);
                    if (data.usingDirectives == null) {
                        data.usingDirectives = new HashMap();
                    }
                    data.usingDirectives.put(enclosing, list);
                } else {
                    list.add(temp);
                }
            }
            --i;
        }
    }

    private static Declaration getClosestEnclosingDeclaration(Declaration decl1, Declaration decl2) {
        if (decl1 == decl2) {
            return decl1;
        }
        if (decl1._depth == decl2._depth) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(decl1._containingScope, decl2._containingScope);
        }
        if (decl1._depth > decl2._depth) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(decl1._containingScope, decl2);
        }
        return ParserSymbolTable.getClosestEnclosingDeclaration(decl1, decl2._containingScope);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LookupData {
        public String name;
        public Map usingDirectives;
        public Set visited = new HashSet();
        public int type = -1;
        public int upperType = 0;
        public boolean qualified = false;

        public LookupData(String n, int t) {
            this.name = n;
            this.type = t;
        }
    }
}

