/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class VCErrorParser
implements IErrorParser {
    public boolean processLine(String line, ErrorParserManager eoParser) {
        String firstPart;
        StringTokenizer tok;
        int firstColon = line.indexOf(58);
        if (firstColon != -1 && (tok = new StringTokenizer(firstPart = line.substring(0, firstColon), "()")).hasMoreTokens()) {
            String fileName = tok.nextToken();
            if (tok.hasMoreTokens()) {
                String lineNumber = tok.nextToken();
                try {
                    IFile file;
                    int num = Integer.parseInt(lineNumber);
                    int i = fileName.lastIndexOf(File.separatorChar);
                    if (i != -1) {
                        fileName = fileName.substring(i + 1);
                    }
                    if ((file = eoParser.findFileName(fileName)) != null || eoParser.isConflictingName(fileName)) {
                        String desc = line.substring(firstColon + 1).trim();
                        if (file == null) {
                            desc = "*" + desc;
                        }
                        int severity = 2;
                        if (desc.startsWith("warning")) {
                            severity = 1;
                        }
                        eoParser.generateMarker((IResource)file, num, desc, severity, null);
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

