/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.parser;

import org.eclipse.cdt.internal.parser.IStructurizerCallback;
import org.eclipse.cdt.internal.parser.LinePositionInputStream;
import org.eclipse.cdt.internal.parser.generated.Token;

public final class ParserCallback {
    public static final int K_CLASS = 64;
    public static final int K_STRUCT = 65;
    public static final int K_UNION = 66;
    public static final int K_FUNCTION = 71;
    public static final int K_DECL = 70;
    public static final int K_CTOR = 256;
    public static final int K_DTOR = 512;
    public static final int K_STATIC = 1024;
    public static final int K_EXTERN = 2048;
    private LinePositionInputStream fLinePositions;
    private IStructurizerCallback fCallback;
    private int fStorage;

    public ParserCallback(LinePositionInputStream lpiStream, IStructurizerCallback callback) {
        this.fLinePositions = lpiStream;
        this.fCallback = callback;
    }

    public void functionDeclBegin(Token nameToken, Token firstToken, int kind) {
        int declStart = this.fLinePositions.getPosition(firstToken.beginLine, firstToken.beginColumn);
        int nameStart = this.fLinePositions.getPosition(nameToken.beginLine, nameToken.beginColumn);
        int nameEnd = this.fLinePositions.getPosition(nameToken.endLine, nameToken.endColumn);
        this.fCallback.functionDeclBegin(nameToken.image, nameStart, nameEnd, declStart, firstToken.beginLine, kind, this.fStorage);
        this.fStorage = 0;
    }

    public void functionDeclEnd(Token lastToken) {
        int declEnd = this.fLinePositions.getPosition(lastToken.endLine, lastToken.endColumn);
        boolean prototype = ";".equals(lastToken.image);
        this.fCallback.functionDeclEnd(declEnd, lastToken.endLine, prototype);
    }

    public void structDeclBegin(Token nameToken, int kind, Token firstToken) {
        int declStart = this.fLinePositions.getPosition(firstToken.beginLine, firstToken.beginColumn);
        int nameStart = this.fLinePositions.getPosition(nameToken.beginLine, nameToken.beginColumn);
        int nameEnd = this.fLinePositions.getPosition(nameToken.endLine, nameToken.endColumn);
        this.fCallback.structDeclBegin(nameToken.image, kind, nameStart, nameEnd, declStart, firstToken.beginLine, this.fStorage);
        this.fStorage = 0;
    }

    public void structDeclEnd(Token lastToken) {
        int declEnd = this.fLinePositions.getPosition(lastToken.endLine, lastToken.endColumn);
        this.fCallback.structDeclEnd(declEnd, lastToken.endLine);
    }

    public void fieldDecl(Token nameToken, Token firstToken, Token lastToken) {
        int declStart = this.fLinePositions.getPosition(firstToken.beginLine, firstToken.beginColumn);
        int declEnd = this.fLinePositions.getPosition(lastToken.endLine, lastToken.endColumn);
        int nameStart = this.fLinePositions.getPosition(nameToken.beginLine, nameToken.beginColumn);
        int nameEnd = this.fLinePositions.getPosition(nameToken.endLine, nameToken.endColumn);
        this.fCallback.fieldDecl(nameToken.image, nameStart, nameEnd, declStart, declEnd, firstToken.beginLine, lastToken.endLine, this.fStorage);
        this.fStorage = 0;
    }

    public void superDecl(String name) {
        this.fCallback.superDecl(name);
    }

    public void includeDecl(String name, int line, int column) {
        int start = this.fLinePositions.getPosition(line, column);
        int end = this.fLinePositions.getPosition(line, column + name.length()) - 1;
        this.fCallback.includeDecl(name, start, end, line, line);
    }

    public void defineDecl(String name, int line, int column) {
        int start = this.fLinePositions.getPosition(line, column);
        int end = this.fLinePositions.getPosition(line, column + name.length()) - 1;
        this.fCallback.defineDecl(name, start, end, line, line);
    }

    public void storageSpecifier(int kind) {
        this.fStorage |= kind;
    }

    public boolean isStorageClassSpecifier(Token token) {
        String str = token.image;
        if (str != null) {
            if ("JNIEXPORT".equals(str)) {
                return true;
            }
            if (str.startsWith("__declspec")) {
                return true;
            }
            if ("JNICALL".equals(str)) {
                return true;
            }
        }
        return false;
    }

    public boolean overreadBlocks() {
        return true;
    }

    public static Token createToken(String name, Token positions) {
        Token res = new Token();
        res.image = name;
        res.beginColumn = positions.beginColumn;
        res.beginLine = positions.beginLine;
        res.endColumn = positions.endColumn;
        res.endLine = positions.endLine;
        return res;
    }

    public static Token createToken(String name, Token positionBegin, Token positionEnd) {
        Token res = new Token();
        res.image = name;
        res.beginColumn = positionBegin.beginColumn;
        res.beginLine = positionBegin.beginLine;
        res.endColumn = positionEnd.endColumn;
        res.endLine = positionEnd.endLine;
        return res;
    }
}

