/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.command.MIExecContinue;
import org.eclipse.cdt.debug.mi.core.command.MIExecFinish;
import org.eclipse.cdt.debug.mi.core.command.MIExecNext;
import org.eclipse.cdt.debug.mi.core.command.MIExecNextInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecReturn;
import org.eclipse.cdt.debug.mi.core.command.MIExecRun;
import org.eclipse.cdt.debug.mi.core.command.MIExecStep;
import org.eclipse.cdt.debug.mi.core.command.MIExecStepInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecUntil;
import org.eclipse.cdt.debug.mi.core.command.MIInfoThreads;
import org.eclipse.cdt.debug.mi.core.command.MIJump;
import org.eclipse.cdt.debug.mi.core.command.MISignal;
import org.eclipse.cdt.debug.mi.core.command.MITargetDetach;
import org.eclipse.cdt.debug.mi.core.command.MIThreadSelect;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataEvaluateExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoThreadsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIThreadSelectInfo;

public class Target
implements ICDITarget {
    Session session;
    Thread[] noThreads = new Thread[0];
    Thread[] currentThreads;
    int currentThreadId;
    int lastExecutionToken;

    public Target(Session s) {
        this.session = s;
        this.currentThreads = this.noThreads;
    }

    public Session getCSession() {
        return this.session;
    }

    public int getLastExecutionToken() {
        return this.lastExecutionToken;
    }

    public ICDISession getSession() {
        return this.session;
    }

    public ICDITarget getTarget() {
        return this;
    }

    public void setCurrentThread(ICDIThread cthread) throws CDIException {
        if (!(cthread instanceof Thread)) {
            throw new CDIException("unknown thread");
        }
        this.setCurrentThread(cthread, true);
    }

    public void setCurrentThread(ICDIThread cthread, boolean doUpdate) throws CDIException {
        if (!(cthread instanceof Thread)) {
            throw new CDIException("unknown thread");
        }
        this.setCurrentThread((Thread)cthread, doUpdate);
    }

    public void setCurrentThread(Thread cthread, boolean doUpdate) throws CDIException {
        MISession mi;
        this.session.setCurrentTarget(this);
        int id = cthread.getId();
        if (id == 0) {
            return;
        }
        if (this.currentThreadId != id) {
            mi = this.session.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIThreadSelect select = factory.createMIThreadSelect(id);
            try {
                mi.postCommand(select);
                MIThreadSelectInfo info = select.getMIThreadSelectInfo();
                if (info == null) {
                    throw new CDIException("No Answer");
                }
                this.currentThreadId = info.getNewThreadId();
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            if (doUpdate) {
                RegisterManager regMgr = (RegisterManager)this.session.getRegisterManager();
                regMgr.update();
            }
        }
        if (this.currentThreadId != id) {
            mi = this.session.getMISession();
            mi.fireEvent(new MIThreadExitEvent(id));
            throw new CDIException("Can not swith to thread " + id);
        }
    }

    public void updateState(int newThreadId) {
        int j;
        int j2;
        Thread[] oldThreads = this.currentThreads;
        this.currentThreadId = newThreadId;
        this.currentThreads = this.getCThreads();
        ArrayList<Integer> cList = new ArrayList<Integer>(this.currentThreads.length);
        int i = 0;
        while (i < this.currentThreads.length) {
            boolean found = false;
            j2 = 0;
            while (j2 < oldThreads.length) {
                if (this.currentThreads[i].getId() == oldThreads[j2].getId()) {
                    oldThreads[j2].clearState();
                    this.currentThreads[i] = oldThreads[j2];
                    found = true;
                    break;
                }
                ++j2;
            }
            if (!found) {
                cList.add(new Integer(this.currentThreads[i].getId()));
            }
            ++i;
        }
        if (!cList.isEmpty()) {
            MIEvent[] events = new MIThreadCreatedEvent[cList.size()];
            j2 = 0;
            while (j2 < events.length) {
                int id = (Integer)cList.get(j2);
                events[j2] = new MIThreadCreatedEvent(id);
                ++j2;
            }
            MISession miSession = this.session.getMISession();
            miSession.fireEvents(events);
        }
        ArrayList<Integer> dList = new ArrayList<Integer>(oldThreads.length);
        int i2 = 0;
        while (i2 < oldThreads.length) {
            boolean found = false;
            j = 0;
            while (j < this.currentThreads.length) {
                if (this.currentThreads[j].getId() == oldThreads[i2].getId()) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                dList.add(new Integer(oldThreads[i2].getId()));
            }
            ++i2;
        }
        if (!dList.isEmpty()) {
            MIEvent[] events = new MIThreadExitEvent[dList.size()];
            j = 0;
            while (j < events.length) {
                int id = (Integer)dList.get(j);
                events[j] = new MIThreadExitEvent(id);
                ++j;
            }
            MISession miSession = this.session.getMISession();
            miSession.fireEvents(events);
        }
    }

    public Thread[] getCThreads() {
        Thread[] cthreads = this.noThreads;
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIInfoThreads tids = factory.createMIInfoThreads();
        try {
            mi.postCommand(tids);
            MIInfoThreadsInfo info = tids.getMIInfoThreadsInfo();
            int[] ids = info == null ? new int[]{} : info.getThreadIds();
            if (ids != null && ids.length > 0) {
                cthreads = new Thread[ids.length];
                int i = 0;
                while (i < ids.length) {
                    cthreads[i] = new Thread(this, ids[i]);
                    ++i;
                }
            } else {
                cthreads = new Thread[]{new Thread(this, 0)};
            }
            this.currentThreadId = info.getCurrentThread();
            if (this.currentThreadId == 0 && cthreads.length > 0) {
                this.currentThreadId = cthreads[0].getId();
            }
        }
        catch (MIException e) {
            // empty catch block
        }
        return cthreads;
    }

    public ICDIThread getCurrentThread() throws CDIException {
        ICDIThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            Thread cthread = (Thread)threads[i];
            if (cthread.getId() == this.currentThreadId) {
                return cthread;
            }
            ++i;
        }
        return null;
    }

    public ICDIThread[] getThreads() throws CDIException {
        if (this.currentThreads.length == 0) {
            this.currentThreads = this.getCThreads();
        }
        return this.currentThreads;
    }

    public ICDIThread getThread(int tid) {
        Thread th = null;
        if (this.currentThreads != null) {
            int i = 0;
            while (i < this.currentThreads.length) {
                Thread cthread = this.currentThreads[i];
                if (cthread.getId() == tid) {
                    th = cthread;
                    break;
                }
                ++i;
            }
        }
        return th;
    }

    public void restart() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecRun run = factory.createMIExecRun(new String[0]);
        try {
            mi.postCommand(run);
            MIInfo info = run.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = run.getToken();
    }

    public void resume() throws CDIException {
        MISession mi = this.session.getMISession();
        if (mi.getMIInferior().isRunning()) {
            throw new CDIException("Inferior already running");
        }
        if (mi.getMIInferior().isSuspended()) {
            CommandFactory factory = mi.getCommandFactory();
            MIExecContinue cont = factory.createMIExecContinue();
            try {
                mi.postCommand(cont);
                MIInfo info = cont.getMIInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            this.lastExecutionToken = cont.getToken();
        } else if (mi.getMIInferior().isTerminated()) {
            this.restart();
        } else {
            this.restart();
        }
    }

    public void stepInto() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecStep step = factory.createMIExecStep();
        try {
            mi.postCommand(step);
            MIInfo info = step.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = step.getToken();
    }

    public void stepIntoInstruction() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecStepInstruction stepi = factory.createMIExecStepInstruction();
        try {
            mi.postCommand(stepi);
            MIInfo info = stepi.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = stepi.getToken();
    }

    public void stepOver() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecNext next = factory.createMIExecNext();
        try {
            mi.postCommand(next);
            MIInfo info = next.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = next.getToken();
    }

    public void stepOverInstruction() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecNextInstruction nexti = factory.createMIExecNextInstruction();
        try {
            mi.postCommand(nexti);
            MIInfo info = nexti.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = nexti.getToken();
    }

    public void stepReturn() throws CDIException {
        this.stepReturn(true);
    }

    public void stepReturn(boolean execute) throws CDIException {
        if (execute) {
            this.finish();
        } else {
            this.execReturn();
        }
    }

    protected void finish() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecFinish finish = factory.createMIExecFinish();
        try {
            mi.postCommand(finish);
            MIInfo info = finish.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = finish.getToken();
    }

    protected void execReturn() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIExecReturn ret = factory.createMIExecReturn();
        try {
            mi.postCommand(ret);
            MIInfo info = ret.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = ret.getToken();
    }

    public void suspend() throws CDIException {
        MISession mi = this.session.getMISession();
        try {
            mi.getMIInferior().interrupt();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void disconnect() throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MITargetDetach detach = factory.createMITargetDetach();
        try {
            mi.postCommand(detach);
            MIInfo info = detach.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        MISession miSession = this.session.getMISession();
        miSession.fireEvent(new MIDetachedEvent(detach.getToken()));
        this.session.getMISession().getMIInferior().setDisconnected();
    }

    public void runUntil(ICDILocation location) throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        String loc = "";
        if (location.getFile() != null && location.getFile().length() > 0) {
            loc = location.getFile() + ":" + location.getLineNumber();
        } else if (location.getFunction() != null && location.getFunction().length() > 0) {
            loc = location.getFunction();
        } else if (location.getAddress() != 0L) {
            loc = "*" + location.getAddress();
        }
        MIExecUntil until = factory.createMIExecUntil(loc);
        try {
            mi.postCommand(until);
            MIInfo info = until.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = until.getToken();
    }

    public void jump(ICDILocation location) throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        String loc = "";
        if (location.getFile() != null && location.getFile().length() > 0) {
            loc = location.getFile() + ":" + location.getLineNumber();
        } else if (location.getFunction() != null && location.getFunction().length() > 0) {
            loc = location.getFunction();
        } else if (location.getAddress() != 0L) {
            loc = "*" + location.getAddress();
        }
        MIJump jump = factory.createMIJump(loc);
        try {
            mi.postCommand(jump);
            MIInfo info = jump.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.lastExecutionToken = jump.getToken();
    }

    public String evaluateExpressionToString(String expressionText) throws CDIException {
        MISession mi = this.session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataEvaluateExpression evaluate = factory.createMIDataEvaluateExpression(expressionText);
        try {
            mi.postCommand(evaluate);
            MIDataEvaluateExpressionInfo info = evaluate.getMIDataEvaluateExpressionInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            return info.getExpression();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void terminate() throws CDIException {
        this.session.getMISession().getMIInferior().destroy();
    }

    public boolean isTerminated() {
        return this.session.getMISession().getMIInferior().isTerminated();
    }

    public boolean isDisconnected() {
        return !this.session.getMISession().getMIInferior().isConnected();
    }

    public boolean isSuspended() {
        return this.session.getMISession().getMIInferior().isSuspended();
    }

    public boolean isRunning() {
        return this.session.getMISession().getMIInferior().isRunning();
    }

    public Process getProcess() {
        return this.session.getMISession().getMIInferior();
    }

    public void signal() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MISignal signal = factory.createMISignal("0");
        try {
            mi.postCommand(signal);
            MIInfo info = signal.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void signal(ICDISignal signal) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MISignal sig = factory.createMISignal(signal.getName());
        try {
            mi.postCommand(sig);
            MIInfo info = sig.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }
}

