/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIValue;
import org.eclipse.cdt.debug.mi.core.output.MIVar;

public class MIVarCreateInfo
extends MIInfo {
    String name = "";
    int numChild;
    String type = "";
    MIVar child;

    public MIVarCreateInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    public MIVar getMIVar() {
        if (this.child == null) {
            this.child = new MIVar(this.name, this.numChild, this.type);
        }
        return this.child;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("name")) {
                    this.name = str;
                } else if (var.equals("numchild")) {
                    try {
                        this.numChild = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException e) {}
                } else if (var.equals("type")) {
                    this.type = str;
                }
                ++i;
            }
        }
    }
}

