/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.builder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.builder.ICBuildConfigPoint;
import org.eclipse.cdt.core.builder.ICBuildVariablePoint;
import org.eclipse.cdt.core.builder.ICToolPoint;
import org.eclipse.cdt.core.builder.ICToolchainPoint;
import org.eclipse.cdt.core.builder.internal.CBuildConfigPoint;
import org.eclipse.cdt.core.builder.internal.CBuildVariablePoint;
import org.eclipse.cdt.core.builder.internal.CToolPoint;
import org.eclipse.cdt.core.builder.internal.CToolTypePoint;
import org.eclipse.cdt.core.builder.internal.CToolchainPoint;
import org.eclipse.cdt.core.builder.model.ICToolType;
import org.eclipse.cdt.core.builder.model.internal.CBuildConfigManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;

public class BuilderPlugin {
    private static BuilderPlugin thisPlugin = new BuilderPlugin();
    private CBuildConfigManager fBuildConfigManager = new CBuildConfigManager();
    private Map fToolTypes;
    private Map fToolProviders;
    private Map fToolchainProviders;
    private Map fBuildConfigProviders;
    private Map fBuildVarProviders;

    private BuilderPlugin() {
    }

    private void dump() {
        Iterator iter = this.fToolTypes.entrySet().iterator();
        while (iter.hasNext()) {
            ICToolType element = (ICToolType)iter.next().getValue();
            System.err.println("Tool type (" + element.getName() + ", " + element.getId() + ")");
        }
        Iterator iter2 = this.fToolProviders.entrySet().iterator();
        while (iter2.hasNext()) {
            ICToolPoint element = (ICToolPoint)iter2.next().getValue();
            System.err.println("Tool (" + element.getName() + ", " + element.getId() + ", " + element.getProviderClassName() + ")");
        }
        Iterator iter3 = this.fToolchainProviders.entrySet().iterator();
        while (iter3.hasNext()) {
            ICToolchainPoint element = (ICToolchainPoint)iter3.next().getValue();
            System.err.println("Toolchain (" + element.getId() + ", " + element.getProviderClassName() + ")");
        }
        Iterator iter4 = this.fBuildConfigProviders.entrySet().iterator();
        while (iter4.hasNext()) {
            ICBuildConfigPoint element = (ICBuildConfigPoint)iter4.next().getValue();
            System.err.println("BuildConfig (" + element.getName() + ", " + element.getId() + ", " + element.getProviderClassName() + ")");
        }
        Iterator iter5 = this.fBuildVarProviders.entrySet().iterator();
        while (iter5.hasNext()) {
            ICBuildVariablePoint element = (ICBuildVariablePoint)iter5.next().getValue();
            System.err.println("BuildVar (" + element.getId() + ", " + element.getProviderClassName() + ")");
        }
    }

    public static BuilderPlugin getDefault() {
        return thisPlugin;
    }

    public IPluginDescriptor getDescriptor() {
        return CCorePlugin.getDefault().getDescriptor();
    }

    public CBuildConfigManager getBuildConfigurationManager() {
        return this.fBuildConfigManager;
    }

    public Map getToolTypes() {
        return this.fToolTypes;
    }

    public Map getToolProviders() {
        return this.fToolProviders;
    }

    public Map getToolchainProviders() {
        return this.fToolchainProviders;
    }

    public Map getBuildConfigurationProviders() {
        return this.fBuildConfigProviders;
    }

    public Map getBuildVariableProviders() {
        return this.fBuildVarProviders;
    }

    private void loadToolTypes() {
        IPluginDescriptor descriptor = BuilderPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("CToolType");
        IExtension[] exts = extensionPoint.getExtensions();
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fToolTypes = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            CToolTypePoint provider = new CToolTypePoint(configurationElement);
            this.fToolTypes.put(provider.getId(), provider);
            ++i;
        }
    }

    private void loadToolProviders() {
        IPluginDescriptor descriptor = BuilderPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("CTool");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fToolProviders = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            CToolPoint provider = new CToolPoint(configurationElement);
            this.fToolProviders.put(provider.getId(), provider);
            ++i;
        }
    }

    private void loadToolchainProviders() {
        IPluginDescriptor descriptor = BuilderPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("CToolchain");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fToolchainProviders = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            CToolchainPoint provider = new CToolchainPoint(configurationElement);
            this.fToolchainProviders.put(provider.getId(), provider);
            ++i;
        }
    }

    private void loadConfigProviders() {
        IPluginDescriptor descriptor = BuilderPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("CBuildConfig");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fBuildConfigProviders = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            CBuildConfigPoint provider = new CBuildConfigPoint(configurationElement);
            this.fBuildConfigProviders.put(provider.getId(), provider);
            ++i;
        }
    }

    private void loadBuildVarProviders() {
        IPluginDescriptor descriptor = BuilderPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("CBuildVariable");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fBuildVarProviders = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            CBuildVariablePoint provider = new CBuildVariablePoint(configurationElement);
            this.fBuildVarProviders.put(provider.getId(), provider);
            ++i;
        }
    }

    static {
        thisPlugin.loadToolTypes();
        thisPlugin.loadToolProviders();
        thisPlugin.loadToolchainProviders();
        thisPlugin.loadConfigProviders();
        thisPlugin.loadBuildVarProviders();
        thisPlugin.dump();
    }
}

