/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.HashMap;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.internal.core.CDescriptor;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CDescriptorManager
implements IResourceChangeListener {
    private static HashMap fDescriptorMap;

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void shutdown() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void startup() {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (fDescriptorMap == null) {
            return;
        }
        IResource resource = event.getResource();
        int eventType = event.getType();
        switch (eventType) {
            case 4: {
                if (resource.getType() != 4) break;
                fDescriptorMap.remove(resource);
                break;
            }
            case 1: {
                IFile file;
                IResource dResource;
                IResourceDelta delta = event.getDelta();
                if (delta == null || !((dResource = delta.getResource()) instanceof IFile) || (file = (IFile)dResource) == null || !file.getName().endsWith(".cdtproject") || file.exists() || fDescriptorMap == null) break;
                fDescriptorMap.remove(resource);
            }
        }
    }

    public synchronized ICDescriptor getDescriptor(IProject project) throws CoreException {
        CDescriptor cproject;
        if (fDescriptorMap == null) {
            fDescriptorMap = new HashMap();
        }
        if ((cproject = (CDescriptor)fDescriptorMap.get(project)) == null) {
            cproject = new CDescriptor(project);
            cproject.setAutoSave(true);
            fDescriptorMap.put(project, cproject);
        }
        return cproject;
    }

    public synchronized void configure(IProject project, String id) throws CoreException {
        CDescriptor cproject2;
        if (fDescriptorMap == null) {
            fDescriptorMap = new HashMap();
        }
        if (fDescriptorMap.get(project) != null) {
            Status status = new Status(4, "org.eclipse.cdt.core", 1, "CDTProject already configured", (Throwable)null);
            throw new CoreException((IStatus)status);
        }
        try {
            cproject2 = new CDescriptor(project, id);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status.getCode() == 1) {
                CDescriptor cproject2 = new CDescriptor(project);
                fDescriptorMap.put(project, cproject2);
                return;
            }
            throw e;
        }
        COwner cowner = new COwner(id);
        cowner.configure(project, cproject2);
        cproject2.saveInfo();
        cproject2.setAutoSave(true);
        fDescriptorMap.put(project, cproject2);
    }

    public synchronized void convert(IProject project, String id) throws CoreException {
        if (fDescriptorMap == null) {
            fDescriptorMap = new HashMap();
        }
        COwner cowner = new COwner(id);
        CDescriptor cproject = new CDescriptor(project, cowner);
        cowner.configure(project, cproject);
        cproject.saveInfo();
        cproject.setAutoSave(true);
        fDescriptorMap.put(project, cproject);
    }
}

