/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.ArchiveInfo;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Archive
extends Openable
implements IArchive {
    public Archive(ICElement parent, IFile file) {
        this(parent, file.getLocation());
    }

    public Archive(ICElement parent, IPath path) {
        super(parent, path, 18);
    }

    public IBinary[] getBinaries() {
        ICElement[] e = this.getChildren();
        IBinary[] b = new IBinary[e.length];
        System.arraycopy(e, 0, b, 0, e.length);
        return b;
    }

    public CElementInfo createElementInfo() {
        return new ArchiveInfo(this);
    }

    protected ArchiveInfo getArchiveInfo() {
        return (ArchiveInfo)this.getElementInfo();
    }

    protected boolean generateInfos(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        CModelManager.getDefault().putInfo(this, info);
        return this.computeChildren(info, underlyingResource);
    }

    public boolean computeChildren(OpenableInfo info, IResource res) {
        IBinaryParser.IBinaryArchive ar = this.getBinaryArchive(res);
        if (ar != null) {
            IBinaryParser.IBinaryObject[] objects = ar.getObjects();
            int i = 0;
            while (i < objects.length) {
                final IBinaryParser.IBinaryObject obj = objects[i];
                Binary binary = new Binary(this, res.getLocation().append(obj.getName())){

                    protected IBinaryParser.IBinaryObject getBinaryObject(IResource res) {
                        return obj;
                    }
                };
                binary.getElementInfo();
                info.addChild(binary);
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    IBinaryParser.IBinaryArchive getBinaryArchive(IResource res) {
        IBinaryParser.IBinaryArchive archive = null;
        IProject project = null;
        IBinaryParser parser = null;
        if (res != null) {
            project = res.getProject();
        }
        if (project != null) {
            parser = CModelManager.getDefault().getBinaryParser(project);
        }
        if (parser != null) {
            try {
                IPath path = res.getLocation();
                IBinaryParser.IBinaryFile bfile = parser.getBinary(path);
                if (bfile instanceof IBinaryParser.IBinaryArchive) {
                    archive = (IBinaryParser.IBinaryArchive)bfile;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return archive;
    }
}

