/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.BinaryInfo;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class Binary
extends Openable
implements IBinary {
    public Binary(ICElement parent, IFile file) {
        this(parent, file.getLocation());
    }

    public Binary(ICElement parent, IPath path) {
        super(parent, path, 14);
    }

    public Binary(ICElement parent, IFile file, String name) {
        super(parent, (IResource)file, name, 14);
    }

    public boolean hasDebug() {
        return ((BinaryInfo)this.getElementInfo()).hasDebug();
    }

    public boolean isExecutable() {
        return ((BinaryInfo)this.getElementInfo()).isExecutable();
    }

    public boolean isObject() {
        return ((BinaryInfo)this.getElementInfo()).isObject();
    }

    public boolean isSharedLib() {
        return ((BinaryInfo)this.getElementInfo()).isSharedLib();
    }

    public boolean isCore() {
        return ((BinaryInfo)this.getElementInfo()).isCore();
    }

    public String[] getNeededSharedLibs() {
        return ((BinaryInfo)this.getElementInfo()).getNeededSharedLibs();
    }

    public String getCPU() {
        return ((BinaryInfo)this.getElementInfo()).getCPU();
    }

    public long getText() {
        return ((BinaryInfo)this.getElementInfo()).getText();
    }

    public long getData() {
        return ((BinaryInfo)this.getElementInfo()).getData();
    }

    public long getBSS() {
        return ((BinaryInfo)this.getElementInfo()).getBSS();
    }

    public String getSoname() {
        return ((BinaryInfo)this.getElementInfo()).getSoname();
    }

    public boolean isLittleEndian() {
        return ((BinaryInfo)this.getElementInfo()).isLittleEndian();
    }

    public CElementInfo createElementInfo() {
        return new BinaryInfo(this);
    }

    protected boolean generateInfos(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        CModelManager.getDefault().putInfo(this, info);
        return this.computeChildren(info, underlyingResource);
    }

    boolean computeChildren(OpenableInfo info, IResource res) {
        IBinaryParser.IBinaryObject bin = this.getBinaryObject(res);
        if (bin != null) {
            HashMap hash = new HashMap();
            IBinaryParser.ISymbol[] symbols = bin.getSymbols();
            int i = 0;
            while (i < symbols.length) {
                switch (symbols[i].getType()) {
                    case 1: {
                        this.addFunction(info, symbols[i], hash);
                        break;
                    }
                    case 2: {
                        this.addVariable(info, symbols[i], hash);
                    }
                }
                ++i;
            }
            if (info instanceof BinaryInfo) {
                ((BinaryInfo)info).loadInfo(bin);
            }
        } else {
            return false;
        }
        return true;
    }

    protected IBinaryParser.IBinaryObject getBinaryObject(IResource res) {
        IBinaryParser.IBinaryObject binary = null;
        IBinaryParser parser = null;
        IProject project = null;
        if (res != null) {
            project = res.getProject();
        }
        if (project != null) {
            parser = CModelManager.getDefault().getBinaryParser(project);
        }
        if (parser != null) {
            try {
                IPath path = res.getLocation();
                IBinaryParser.IBinaryFile bfile = parser.getBinary(path);
                if (bfile instanceof IBinaryParser.IBinaryObject) {
                    binary = (IBinaryParser.IBinaryObject)bfile;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return binary;
    }

    private void addFunction(OpenableInfo info, IBinaryParser.ISymbol symbol, Map hash) {
        Binary parent = this;
        String filename = symbol.getFilename();
        Function function = null;
        if (filename != null && !filename.equals("??")) {
            TranslationUnit tu = null;
            Path path = new Path(filename);
            if (hash.containsKey(path)) {
                tu = (TranslationUnit)hash.get(path);
            } else {
                tu = new TranslationUnit(parent, (IPath)path){
                    ArrayList array = new ArrayList(5);

                    public void addChild(ICElement e) {
                        this.array.add(e);
                        this.array.trimToSize();
                    }

                    public ICElement[] getChildren() {
                        return this.array.toArray(new ICElement[0]);
                    }

                    protected boolean generateInfos(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
                        return true;
                    }
                };
                hash.put(path, tu);
                info.addChild(tu);
            }
            function = new Function(tu, symbol.getName());
            tu.addChild(function);
        } else {
            function = new Function(parent, symbol.getName());
            info.addChild(function);
        }
    }

    private void addVariable(OpenableInfo info, IBinaryParser.ISymbol symbol, Map hash) {
        String filename = symbol.getFilename();
        Binary parent = this;
        Variable variable = null;
        if (filename != null && !filename.equals("??")) {
            TranslationUnit tu = null;
            Path path = new Path(filename);
            if (hash.containsKey(path)) {
                tu = (TranslationUnit)hash.get(path);
            } else {
                tu = new TranslationUnit(parent, (IPath)path){
                    ArrayList array = new ArrayList(5);

                    public void addChild(ICElement e) {
                        this.array.add(e);
                        this.array.trimToSize();
                    }

                    public ICElement[] getChildren() {
                        return this.array.toArray(new ICElement[0]);
                    }

                    protected boolean generateInfos(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
                        return true;
                    }
                };
                hash.put(path, tu);
                info.addChild(tu);
            }
            variable = new Variable(tu, symbol.getName());
            tu.addChild(variable);
        } else {
            variable = new Variable(parent, symbol.getName());
            info.addChild(variable);
        }
    }
}

