/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElementDeltaBuilder;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.resources.IResource;

public class CommitWorkingCopyOperation
extends CModelOperation {
    public CommitWorkingCopyOperation(ITranslationUnit element, boolean force) {
        super(new ICElement[]{element}, force);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws CModelException {
        block12: {
            block11: {
                try {
                    this.beginTask("workingCopy.commit", 2);
                    WorkingCopy copy = (WorkingCopy)this.getElementToProcess();
                    ITranslationUnit original = copy.getOriginalElement();
                    if (!original.isOpen()) {
                        original.open(null);
                    }
                    CElementDeltaBuilder deltaBuilder = new CElementDeltaBuilder(original);
                    IBuffer originalBuffer = original.getBuffer();
                    if (originalBuffer == null) {
                        Object var11_5 = null;
                        this.done();
                        return;
                    }
                    char[] originalContents = originalBuffer.getCharacters();
                    boolean hasSaved = false;
                    try {
                        IBuffer copyBuffer = copy.getBuffer();
                        if (copyBuffer == null) {
                            Object var9_12 = null;
                            if (!hasSaved) {
                                originalBuffer.setContents(originalContents);
                            }
                            break block11;
                        }
                        originalBuffer.setContents(copyBuffer.getCharacters());
                        original.save(this.fMonitor, this.fForce);
                        this.hasModifiedResource = true;
                        hasSaved = true;
                    }
                    catch (Throwable throwable) {
                        Object var9_14 = null;
                        if (hasSaved) throw throwable;
                        originalBuffer.setContents(originalContents);
                        throw throwable;
                    }
                    Object var9_13 = null;
                    if (!hasSaved) {
                        originalBuffer.setContents(originalContents);
                    }
                    copy.updateTimeStamp((TranslationUnit)original);
                    copy.makeConsistent(this);
                    this.worked(1);
                    if (deltaBuilder != null) {
                        deltaBuilder.buildDeltas();
                        if (deltaBuilder.delta != null) {
                            this.addDelta(deltaBuilder.delta);
                        }
                    }
                    this.worked(1);
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    this.done();
                    throw throwable;
                }
            }
            Object var11_6 = null;
            this.done();
            return;
        }
        Object var11_7 = null;
        this.done();
    }

    public ICModelStatus verify() {
        IWorkingCopy wc = (IWorkingCopy)this.getElementToProcess();
        if (!wc.isWorkingCopy()) {
            return new CModelStatus(967, wc);
        }
        ITranslationUnit original = wc.getOriginalElement();
        IResource resource = original.getResource();
        if (!wc.isBasedOn(resource) && !this.fForce) {
            return new CModelStatus(981);
        }
        return CModelStatus.VERIFIED_OK;
    }
}

