/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public abstract class Parent
extends CElement
implements IParent {
    protected IResource resource;

    public Parent(ICElement parent, IPath path, int type) {
        this(parent, (IResource)ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path), path.lastSegment(), type);
    }

    public Parent(ICElement parent, String name, int type) {
        this(parent, null, name, type);
    }

    public Parent(ICElement parent, IResource resource, String name, int type) {
        super(parent, name, type);
        this.resource = resource;
    }

    protected void addChild(ICElement member) {
        this.getElementInfo().addChild(member);
    }

    protected void removeChild(ICElement member) {
        this.getElementInfo().removeChild(member);
    }

    protected void removeChildren() {
        this.getElementInfo().removeChildren();
    }

    public ICElement[] getChildren() {
        return this.getElementInfo().getChildren();
    }

    public ArrayList getChildrenOfType(int type) {
        ICElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<CElement> list = new ArrayList<CElement>(size);
        int i = 0;
        while (i < size) {
            CElement elt = (CElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public boolean hasChildren() {
        return this.getElementInfo().hasChildren();
    }

    public void setUnderlyingResource(IResource res) {
        this.resource = res;
    }

    public IResource getUnderlyingResource() throws CModelException {
        ICElement p;
        if (this.resource == null && (p = this.getParent()) != null) {
            return p.getUnderlyingResource();
        }
        return this.resource;
    }

    public IResource getResource() {
        return this.resource;
    }

    protected void setChanged() {
        this.getElementInfo().setChanged();
    }

    protected boolean hasChanged() {
        return this.getElementInfo().hasChanged();
    }

    protected abstract CElementInfo createElementInfo();
}

